/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.virtual;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDecorator
implements InvocationHandler {
    private List<OntologyService> ontoServices;
    private int nThreads = 5;
    private static final Logger log = Logger.getLogger(CompositeDecorator.class);

    public void setNumberOfThreads(int val) {
        this.nThreads = val;
    }

    public int getNumberOfThreads() {
        return this.nThreads;
    }

    private CompositeDecorator(List<OntologyService> ontoServices) {
        this.ontoServices = ontoServices;
    }

    private static Object createProxy(Object obj, List list) throws OntologyServiceException {
        try {
            obj.getClass().getMethod("searchAll", String.class, OntologyService.SearchOptions[].class);
            obj.getClass().getMethod("getOntologies", new Class[0]);
            obj.getClass().getMethod("getTermPath", String.class, String.class);
            obj.getClass().getMethod("getTermPath", OntologyTerm.class);
        }
        catch (Exception e) {
            log.fatal("Signature has changed in proxy pattern!");
            throw new OntologyServiceException(e);
        }
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new CompositeDecorator(list));
    }

    public static OntologyService getService(List list) throws OntologyServiceException {
        return (OntologyService)CompositeDecorator.createProxy(new OlsOntologyService(), list);
    }

    public static OntologyService getService(OntologyService ... list) throws OntologyServiceException {
        return (OntologyService)CompositeDecorator.createProxy(new OlsOntologyService(), Arrays.asList(list));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Cloneable result = null;
        ExecutorService ec = Executors.newFixedThreadPool(this.nThreads);
        if (method.getReturnType() == List.class) {
            result = new ArrayList();
        }
        if (method.getReturnType() == Map.class) {
            result = new HashMap();
        }
        if (method.getReturnType() == Set.class) {
            result = new HashSet();
        }
        ArrayList<InvokeTask> tasks = new ArrayList<InvokeTask>();
        for (OntologyService ontologyService : this.ontoServices) {
            tasks.add(new InvokeTask(ontologyService, method, args));
        }
        if (method.getName().equalsIgnoreCase("searchAll") || method.getName().equalsIgnoreCase("getOntologies")) {
            for (Future future : ec.invokeAll(tasks)) {
                try {
                    ((List)((Object)result)).addAll((Collection)future.get());
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NoResultsException) {
                        log.debug(e.getCause().getMessage());
                        continue;
                    }
                    log.error(e + " " + e.getCause().getMessage());
                }
            }
        } else {
            try {
                result = ec.invokeAny(tasks);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof NoResultsException) {
                    log.debug(e.getCause().getMessage());
                }
                log.error(e + " " + e.getCause().getMessage());
            }
        }
        if (method.getName().equalsIgnoreCase("searchAll")) {
            Collections.sort((List)((Object)result));
        }
        ec.shutdown();
        return result;
    }

    public class NoResultsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoResultsException(String str) {
            super(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvokeTask
    implements Callable<Object> {
        private Object target;
        private Method method;
        private Object[] args;

        public InvokeTask(Object target, Method method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
        }

        @Override
        public Object call() throws Exception {
            Object result = this.method.invoke(this.target, this.args);
            NoResultsException e = new NoResultsException("No results from " + this.method.getName() + " in " + this.target.getClass().getSimpleName());
            if (result == null) {
                throw e;
            }
            if (result instanceof Map && ((Map)result).size() == 0) {
                throw e;
            }
            if (result instanceof Set && ((Set)result).size() == 0) {
                throw e;
            }
            if (result instanceof List) {
                Integer listSize = ((List)result).size();
                String methodName = this.method.getName();
                if (listSize == 0 || methodName.equalsIgnoreCase("getTermPath") && listSize == 1) {
                    throw e;
                }
            }
            return result;
        }
    }
}

