/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.util.ObjectPropertySimplifier;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectPropertyExpressionImpl
extends OWLPropertyExpressionImpl<OWLClassExpression, OWLObjectPropertyExpression>
implements OWLObjectPropertyExpression {
    private OWLObjectPropertyExpression simplestForm;
    private OWLObjectPropertyExpression inverse;

    public OWLObjectPropertyExpressionImpl(OWLDataFactory dataFactory) {
        super(dataFactory);
    }

    @Override
    protected Set<? extends OWLPropertyDomainAxiom> getDomainAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyDomainAxioms(this);
    }

    @Override
    public boolean isObjectPropertyExpression() {
        return true;
    }

    @Override
    public boolean isDataPropertyExpression() {
        return false;
    }

    @Override
    public boolean isFunctional(OWLOntology ontology) {
        return ontology.getFunctionalObjectPropertyAxioms(this).size() > 0;
    }

    @Override
    public boolean isFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInverseFunctional(OWLOntology ontology) {
        return !ontology.getInverseFunctionalObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isInverseFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isInverseFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSymmetric(OWLOntology ontology) {
        return !ontology.getSymmetricObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isSymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isSymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAsymmetric(OWLOntology ontology) {
        return !ontology.getAsymmetricObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isAsymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isAsymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReflexive(OWLOntology ontology) {
        return !ontology.getReflexiveObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isReflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isReflexive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIrreflexive(OWLOntology ontology) {
        return !ontology.getIrreflexiveObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isIrreflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isIrreflexive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransitive(OWLOntology ontology) {
        return !ontology.getTransitiveObjectPropertyAxioms(this).isEmpty();
    }

    @Override
    public boolean isTransitive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isTransitive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<? extends OWLPropertyRangeAxiom<OWLObjectPropertyExpression, OWLClassExpression>> getRangeAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyRangeAxioms(this);
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLObjectPropertyExpression>> getSubPropertyAxioms(OWLOntology ontology) {
        return ontology.getObjectSubPropertyAxiomsForSubProperty(this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getEquivalentPropertiesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentObjectPropertiesAxioms(this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getDisjointPropertiesAxioms(OWLOntology ontology) {
        return ontology.getDisjointObjectPropertiesAxioms(this);
    }

    @Override
    public Set<OWLObjectPropertyExpression> getInverses(OWLOntology ontology) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLInverseObjectPropertiesAxiom ax : ontology.getInverseObjectPropertyAxioms(this)) {
            if (ax.getFirstProperty().equals(this)) {
                result.add(ax.getSecondProperty());
                continue;
            }
            result.add(ax.getFirstProperty());
        }
        return result;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getInverses(Set<OWLOntology> ontologies) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getInverses(ont));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLObjectPropertyExpression;
    }

    @Override
    public OWLObjectPropertyExpression getSimplified() {
        if (this.simplestForm == null) {
            ObjectPropertySimplifier simplifier = new ObjectPropertySimplifier(this.getOWLDataFactory());
            this.simplestForm = simplifier.getSimplified(this);
        }
        return this.simplestForm;
    }

    @Override
    public OWLObjectPropertyExpression getInverseProperty() {
        if (this.inverse == null) {
            this.inverse = this.getOWLDataFactory().getOWLObjectInverseOf(this);
        }
        return this.inverse;
    }

    @Override
    public OWLObjectProperty getNamedProperty() {
        OWLObjectPropertyExpression simp = this.getSimplified();
        if (simp.isAnonymous()) {
            return ((OWLObjectInverseOf)simp).getInverse().asOWLObjectProperty();
        }
        return simp.asOWLObjectProperty();
    }
}

