### R code from vignette source 'ontoCAT.Rnw'

###################################################
### code chunk number 1: R.hide (eval = FALSE)
###################################################
## library(ontoCAT)
## efo <- getEFO()
## biotop <- getOntology("http://purl.org/biotop/biotop.owl")


###################################################
### code chunk number 2: R.hide (eval = FALSE)
###################################################
## getAllTerms(biotop)
## getAllTermIds(efo)


###################################################
### code chunk number 3: R.hide (eval = FALSE)
###################################################
## term_efo <- getTermById(efo,"EFO_0000322")
## term_biotop <- getTermById(biotop,"DeadBody")
## getTermNameById(efo,"EFO_0000311")
## getTermNameById(biotop,"EmbryonicStructure")


###################################################
### code chunk number 4: R.hide (eval = FALSE)
###################################################
## getAllTermParentsById(efo,"EFO_0000322")
## getAllTermChildrenById(biotop,"DeadBody")
## getAllTermParents(efo,term_efo)
## getAllTermChildren(biotop,term_biotop)


###################################################
### code chunk number 5: R.hide (eval = FALSE)
###################################################
## getTermParentsById(efo,"EFO_0000322")
## getTermChildrenById(efo,"EFO_0000322")
## getTermParents(efo,term_efo)
## getTermChildren(biotop,term_biotop)


###################################################
### code chunk number 6: R.hide (eval = FALSE)
###################################################
## getTermAndAllChildren(efo,term_efo)
## getTermAndAllChildrenById(biotop,"DeadBody")


###################################################
### code chunk number 7: R.hide (eval = FALSE)
###################################################
## showHierarchyDownToTermById(efo,"EFO_0000322")
## showHierarchyDownToTerm(efo,term_efo)


###################################################
### code chunk number 8: R.hide (eval = FALSE)
###################################################
## getTermDefinitionsById(efo,"EFO_0000322")
## getTermSynonymsById(efo,"EFO_0000322")
## getTermDefinitions(efo,term_efo)
## getTermSynonyms(efo,term_efo)


###################################################
### code chunk number 9: R.hide (eval = FALSE)
###################################################
## getOntologyAccession(efo)
## getOntologyDescription(efo)


###################################################
### code chunk number 10: R.hide (eval = FALSE)
###################################################
## hasTerm(efo,"CL000023")
## hasTerm(efo,"EFO_0000322")


###################################################
### code chunk number 11: R.hide (eval = FALSE)
###################################################
## searchTerm(efo,"thymus")
## searchTermPrefix(efo,"thym")


###################################################
### code chunk number 12: R.hide (eval = FALSE)
###################################################
## isRootById(efo,"EFO_0000322")
## isRoot(efo,term_efo)
## getRoots(efo)
## getRootIds(efo)


###################################################
### code chunk number 13: R.hide (eval = FALSE)
###################################################
## getOntologyRelationNames(efo)


###################################################
### code chunk number 14: R.hide (eval = FALSE)
###################################################
## getTermRelationNamesById(efo,"EFO_0000322")
## getTermRelationNames(efo,term_efo)


###################################################
### code chunk number 15: R.hide (eval = FALSE)
###################################################
## getTermRelationsById(efo,"EFO_0000322","has_part")
## getTermRelations(efo,term_efo,"has_part")


###################################################
### code chunk number 16: R.hide (eval = FALSE)
###################################################
## getEFOBranchRootIds(efo)
## isEFOBranchRootById(efo,"EFO_0000322")
## isEFOBranchRoot(efo,term_efo)


###################################################
### code chunk number 17: R.hide (eval = FALSE)
###################################################
## term <- getTermById(efo,"EFO_0000322")
## getLabel(term)
## getAccession(term)
## term


###################################################
### code chunk number 18: R.hide (eval = FALSE)
###################################################
## library(ontoCAT)
## batch <- getEFOBatch()


###################################################
### code chunk number 19: R.hide (eval = FALSE)
###################################################
## searchTermInBatch(batch,"thymus")


###################################################
### code chunk number 20: R.hide (eval = FALSE)
###################################################
## searchTermInBioportal(batch,"thymus")
## searchTermInOLS(batch,"thymus")


###################################################
### code chunk number 21: R.hide (eval = FALSE)
###################################################
## searchTermInAll(batch,"thymus")


###################################################
### code chunk number 22: R.hide (eval = FALSE)
###################################################
## addOntology(batch,"http://purl.org/biotop/biotop.owl")
## addEFO(batch)


###################################################
### code chunk number 23: R.hide (eval = FALSE)
###################################################
## listLoadedOntologies(batch)


###################################################
### code chunk number 24: R.hide (eval = FALSE)
###################################################
## ontology <- getOntologyFromBatch(batch,"EFO")


