### R code from vignette source 'phyloseq_basics.Rnw'

###################################################
### code chunk number 1: phyloseq_basics.Rnw:75-76 (eval = FALSE)
###################################################
## vignette("phyloseq_analysis")


###################################################
### code chunk number 2: load-packages
###################################################
  library("phyloseq")


###################################################
### code chunk number 3: phyloseq_basics.Rnw:137-141 (eval = FALSE)
###################################################
##   otufilename <- "../data/ex1_otu_table.txt"
##   mapfilename <- "../data/ex1_sample_data.txt"
##   trefilename <- "../data/ex1_tree.tre"
##   MyExpmt1 <- import_qiime(otufilename, mapfilename, trefilename)


###################################################
### code chunk number 4: phyloseq_basics.Rnw:172-178 (eval = FALSE)
###################################################
## mothlist  <- system.file("extdata", "esophagus.fn.list.gz", package="phyloseq")
## mothgroup <- system.file("extdata", "esophagus.good.groups.gz", package="phyloseq")
## mothtree  <- system.file("extdata", "esophagus.tree.gz", package="phyloseq")
## show_mothur_list_cutoffs(mothlist)
## cutoff    <- "0.10"
## import_mothur(mothlist, mothgroup, mothtree, cutoff)	


###################################################
### code chunk number 5: phyloseq_basics.Rnw:204-207 (eval = FALSE)
###################################################
##   pyrotagger_tab_file <- "path/to/my/filename.txt"
##   myData1 <- import_pyrotagger_tab(pyrotagger_tab_file,
##     strict_taxonomy=FALSE, keep_potential_chimeras=FALSE)


###################################################
### code chunk number 6: phyloseq_basics.Rnw:211-212 (eval = FALSE)
###################################################
##   myData1 <- import_pyrotagger_tab(pyrotagger_tab_file)  


###################################################
### code chunk number 7: phyloseq_basics.Rnw:223-224 (eval = FALSE)
###################################################
##   myOTU1 <- import_RDP_cluster("path/to/my/filename.clust")


###################################################
### code chunk number 8: phyloseq_basics.Rnw:246-250 (eval = FALSE)
###################################################
##   data(GlobalPatterns)
##   data(esophagus)
##   data(enterotype)
##   data(soilrep) 


###################################################
### code chunk number 9: phyloseq_basics.Rnw:263-265
###################################################
  data(GlobalPatterns)
  GlobalPatterns


###################################################
### code chunk number 10: phyloseq_basics.Rnw:305-309 (eval = FALSE)
###################################################
## otu1 <- otu_table(raw_abundance_matrix, taxa_are_rows=FALSE)
## sam1 <- sample_data(raw_sample_data.frame) 
## tax1 <- tax_table(raw_taxonomy_matrix)
## tre1 <- read.nexus(my_nexus_file)


###################################################
### code chunk number 11: phyloseq_basics.Rnw:314-315 (eval = FALSE)
###################################################
## ex1b <- phyloseq(my_otu_table, my_sample_data, my_taxonomyTable, my_tree)


###################################################
### code chunk number 12: phyloseq_basics.Rnw:319-320 (eval = FALSE)
###################################################
## ex1c <- phyloseq(my_otu_table, my_sample_data)


###################################################
### code chunk number 13: phyloseq_basics.Rnw:382-383
###################################################
topN <- 20


###################################################
### code chunk number 14: phyloseq_basics.Rnw:386-389
###################################################
data(GlobalPatterns)
most_abundant_taxa <- sort(taxa_sums(GlobalPatterns), TRUE)[1:topN]
ex2 <- prune_taxa(names(most_abundant_taxa), GlobalPatterns)


###################################################
### code chunk number 15: phyloseq_basics.Rnw:395-397
###################################################
topFamilies <- tax_table(ex2)[, "Family"]
as(topFamilies, "vector")


###################################################
### code chunk number 16: phyloseq_basics.Rnw:409-415 (eval = FALSE)
###################################################
## testOTU <- otu_table(matrix(sample(1:50, 25, replace=TRUE), 5, 5), taxa_are_rows=FALSE)
## f1  <- filterfun_sample(topk(2))
## wh1 <- genefilter_sample(testOTU, f1, A=2)
## wh2 <- c(T, T, T, F, F)
## prune_taxa(wh1, testOTU)
## prune_taxa(wh2, testOTU)


###################################################
### code chunk number 17: phyloseq_basics.Rnw:419-424
###################################################
data(GlobalPatterns)
f1  <- filterfun_sample(topp(0.1))
wh1 <- genefilter_sample(GlobalPatterns, f1, A=(1/2*nsamples(GlobalPatterns)))
sum(wh1)
ex2 <- prune_taxa(wh1, GlobalPatterns)


###################################################
### code chunk number 18: phyloseq_basics.Rnw:427-428
###################################################
  print(ex2)


###################################################
### code chunk number 19: phyloseq_basics.Rnw:435-440 (eval = FALSE)
###################################################
## data(GlobalPatterns)
## f1  <- filterfun_sample(topf(0.9))
## wh1 <- genefilter_sample(GlobalPatterns, f1, A=(1/3*nsamples(GlobalPatterns)))
## sum(wh1)
## prune_taxa(wh1, GlobalPatterns)


###################################################
### code chunk number 20: phyloseq_basics.Rnw:461-469
###################################################
data("enterotype")
library("genefilter")
flist    <- filterfun(kOverA(5, 2e-05))
ent.logi <- filter_taxa(enterotype, flist)
ent.trim <- filter_taxa(enterotype, flist, TRUE)
identical(ent.trim, prune_taxa(ent.logi, enterotype)) 
identical(sum(ent.logi), ntaxa(ent.trim))
filter_taxa(enterotype, flist, TRUE)


###################################################
### code chunk number 21: phyloseq_basics.Rnw:474-475
###################################################
ex3 <- subset_samples(GlobalPatterns, SampleType%in%c("Freshwater", "Ocean", "Freshwater (creek)"))


###################################################
### code chunk number 22: phyloseq_basics.Rnw:478-479
###################################################
ex3


###################################################
### code chunk number 23: phyloseq_basics.Rnw:485-486
###################################################
subset(sample_data(GlobalPatterns), SampleType%in%c("Freshwater", "Ocean", "Freshwater (creek)"))


###################################################
### code chunk number 24: phyloseq_basics.Rnw:492-493
###################################################
ex4 <- subset_taxa(GlobalPatterns, Phylum=="Firmicutes")


###################################################
### code chunk number 25: phyloseq_basics.Rnw:496-497
###################################################
ex4


###################################################
### code chunk number 26: phyloseq_basics.Rnw:503-505
###################################################
randomSpecies100 <- sample(taxa_names(GlobalPatterns), 100, replace=FALSE)
ex5 <- prune_taxa(randomSpecies100, GlobalPatterns)


###################################################
### code chunk number 27: phyloseq_basics.Rnw:515-517 (eval = FALSE)
###################################################
## data(GlobalPatterns)
## ex2 <- transform_sample_counts(GlobalPatterns, I)


###################################################
### code chunk number 28: phyloseq_basics.Rnw:524-525
###################################################
ex4  <- transform_sample_counts(GlobalPatterns, threshrankfun(500))


###################################################
### code chunk number 29: phyloseq_basics.Rnw:536-537 (eval = FALSE)
###################################################
## ex6 <- tax_glom(GlobalPatterns, taxlevel="Genus")


###################################################
### code chunk number 30: phyloseq_basics.Rnw:543-544 (eval = FALSE)
###################################################
## ex7 <- tip_glom(GlobalPatterns, speciationMinLength = 0.05)


###################################################
### code chunk number 31: phyloseq_basics.Rnw:602-606 (eval = FALSE)
###################################################
##   install.packages("doParallel")
##   install.packages("doMC")
##   install.packages("doSNOW")
##   install.packages("doMPI")


