### Script used for updating all the datasets in
### SNPlocs.Hsapiens.dbSNP.20100427 from the old format (used
### prior to version 0.99.4 of the package) to the new format
### used in version 0.99.4.

library(SNPlocs.Hsapiens.dbSNP.20100427)

seqlevels <- names(getSNPcount())
rsids <- vector("list", length=length(seqlevels))
names(rsids) <- seqlevels

for (ch in seqlevels) {
    cat("Re-packaging SNPs for ", ch, " ... ", sep="")
    snplocs <- getSNPlocs(ch, caching=FALSE) 
    rsids[[ch]] <- snplocs$RefSNP_id
    alleles <- charToRaw(paste(snplocs$alleles_as_ambig, collapse=""))
    snplocs <- data.frame(loc=snplocs$loc, alleles=alleles)
    cat("OK\n")

    objname <- paste(ch, "_snplocs", sep="")
    filename <- paste(objname, ".rda", sep="")
    cat("Saving ", objname, " ... ", sep="")
    assign(objname, snplocs)
    save(list=objname, file=filename, compress="xz")
    cat("OK\n")
}

if (!identical(sapply(rsids, length), getSNPcount()))
    stop("nb of rs ids per chromosome doesn't match getSNPcount()")

all_rsids <- unlist(rsids, recursive=FALSE, use.names=FALSE)

if ("0" %in% unique(substr(all_rsids, 1L, 1L)))
    stop("some rs ids start with rs0... Not good!")

all_rsids <- as.integer(all_rsids)

cat("Saving all_rsids ... ", sep="")
save(all_rsids, file="all_rsids.rda", compress="xz")
cat("OK\n")

