### R code from vignette source 'nov09rv.Rnw'

###################################################
### code chunk number 1: lkd1-1
###################################################
library(ind1KG)
library(Rsamtools)


###################################################
### code chunk number 2: workaround
###################################################
readPileup <- selectMethod("readPileup", "connection")


###################################################
### code chunk number 3: lkd1-2
###################################################
pup17 <- gzfile(system.file("pileups/n240_17.pup.gz", package="ind1KG"))
c17p.i <- readPileup(pup17, variant="indel")
levels(seqnames(c17p.i))
seqlevels(c17p.i) = gsub("17", "chr17", seqlevels(c17p.i))
c17p.i


###################################################
### code chunk number 4: li
###################################################
library(SNPlocs.Hsapiens.dbSNP.20090506)
c6 <- getSNPlocs("chr6")
head(c6, 5)


###################################################
### code chunk number 5: getg
###################################################
library(org.Hs.eg.db)
egid <- get("CDRT4", revmap(org.Hs.egSYMBOL))
kgid <- get(egid, org.Hs.egUCSCKG)
library(GenomicFeatures)
library(TxDb.Hsapiens.UCSC.hg18.knownGene)
txdb = TxDb.Hsapiens.UCSC.hg18.knownGene
txloc <- transcripts(txdb)
cdrt4txloc <- txloc[elementMetadata(txloc)$tx_name %in% kgid]
subsetByOverlaps(c17p.i, cdrt4txloc)


###################################################
### code chunk number 6: lkm
###################################################
cdrt4txid <- as.character(elementMetadata(cdrt4txloc)$tx_id)
cdrt4exloc <- exonsBy(txdb)[cdrt4txid]
subsetByOverlaps(c17p.i, cdrt4exloc)


###################################################
### code chunk number 7: lkd
###################################################
library(ind1KG)
library(chopsticks)
data(yri240_6)
yri240_6$hm
head(yri240_6$supp, 10)


###################################################
### code chunk number 8: lklu
###################################################
library(lumiHumanIDMapping)
con <- lumiHumanIDMapping_dbconn()
dbListTables(con)
dbGetQuery(con, "select * from HumanWG6_V1 limit 5")


###################################################
### code chunk number 9: ll
###################################################
sessionInfo()


