### R code from vignette source 'create_objects.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: create_objects.Rnw:73-86
###################################################
library("parathyroid")
library("GEOquery")
gse37211 <- getGEO(filename=system.file("extdata/GSE37211_series_matrix.txt",
                               package="parathyroid",mustWork=TRUE))
samples <- pData(gse37211)[,c("characteristics_ch1","characteristics_ch1.2",
                              "characteristics_ch1.3","relation")]
colnames(samples) <- c("patient","treatment","time","experiment")
samples$patient <- sub("patient: (.+)","\\1",samples$patient)
samples$treatment <- sub("agent: (.+)","\\1",samples$treatment)
samples$time <- sub("time: (.+)","\\1",samples$time)
samples$experiment <- sub("SRA: http://www.ncbi.nlm.nih.gov/sra\\?term=(.+)","\\1",
                          samples$experiment)
samples


###################################################
### code chunk number 2: create_objects.Rnw:93-100 (eval = FALSE)
###################################################
## library("SRAdb")
## sqlfile <- getSRAdbFile()
## sra_con <- dbConnect(SQLite(),sqlfile)
## conversion <- sraConvert(in_acc = samples$experiment, out_type = 
##                          c("sra","submission","study","sample","experiment","run"), 
##                          sra_con = sra_con)
## write.table(conversion,file="inst/extdata/conversion.txt")


###################################################
### code chunk number 3: create_objects.Rnw:105-110
###################################################
conversion <- read.table(system.file("extdata/conversion.txt",
                                     package="parathyroid",mustWork=TRUE))
samplesFull <- merge(samples, conversion)
samplesFull <- samplesFull[order(samplesFull$run),]
samplesFull <- as.data.frame(lapply(samplesFull, factor))


###################################################
### code chunk number 4: create_objects.Rnw:117-123 (eval = FALSE)
###################################################
## library("DESeq")
## genecountfiles <- paste(samplesFull$run,"_gene_counts.txt",sep="")
## sampleTable <- cbind(samplenames=samplesFull$run, 
##                      countfiles = genecountfiles, 
##                      samplesFull)
## parathyroidGenes <- newCountDataSetFromHTSeqCount(sampleTable,directory=".")


###################################################
### code chunk number 5: create_objects.Rnw:128-140 (eval = FALSE)
###################################################
## expdata = new("MIAME",
##   name="Felix Haglund",
##   lab="Science for Life Laboratory Stockholm",
##   contact="Mikael Huss",
##   title="DPN and Tamoxifen treatments of parathyroid adenoma cells",
##   url="http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE37211",
##   abstract="Primary hyperparathyroidism (PHPT) is most frequently present in postmenopausal women. Although the involvement of estrogen has been suggested, current literature indicates that parathyroid tumors are estrogen receptor (ER) alpha negative. Objective: The aim of the study was to evaluate the expression of ERs and their putative function in parathyroid tumors. Design: A panel of 37 parathyroid tumors was analyzed for expression and promoter methylation of the ESR1 and ESR2 genes as well as expression of the ERalpha and ERbeta1/ERbeta2 proteins. Transcriptome changes in primary cultures of parathyroid adenoma cells after treatment with the selective ERbeta1 agonist diarylpropionitrile (DPN) and 4-hydroxytamoxifen were identified using next-generation RNA sequencing. Results: Immunohistochemistry revealed very low expression of ERalpha, whereas all informative tumors expressed ERbeta1 (n = 35) and ERbeta2 (n = 34). Decreased nuclear staining intensity and mosaic pattern of positive and negative nuclei of ERbeta1 were significantly associated with larger tumor size. Tumor ESR2 levels were significantly higher in female vs. male cases. In cultured cells, significantly increased numbers of genes with modified expression were detected after 48 h, compared to 24-h treatments with DPN or 4-hydroxytamoxifen, including the parathyroid-related genes CASR, VDR, JUN, CALR, and ORAI2. Bioinformatic analysis of transcriptome changes after DPN treatment revealed significant enrichment in gene sets coupled to ER activation, and a highly significant similarity to tumor cells undergoing apoptosis. Conclusions: Parathyroid tumors express ERbeta1 and ERbeta2. Transcriptional changes after ERbeta1 activation and correlation to clinical features point to a role of estrogen signaling in parathyroid function and disease.")
## pubMedIds(expdata) <- "23024189"
## n <- nrow(samplesFull)
## protocoldata <- AnnotatedDataFrame(data.frame(treatment=rep("cells were plated and treated with 100 nM DPN (Tocris Bioscience), or 100 nM OHT (Sigma-Aldrich, Stockholm, Sweden) for 24h or 48h, respectively. Untreated cells cultured in parallel were used as controls.",n), growth=rep("Tissue for cell culturing was obtained from four parathyroid adenomas collected directly at surgery. All samples were from female, postmenopausal patients with chief cell adenoma with no preoperative signs of malignancy or kidney failure. Isolation of cells and cell culturing were performed essentially as previously described by Lu et al. In brief, tissues were cut and digested into cells with 1.5 mg/mL collagenase type II. About 1106 cells were plated",n),extracted_molecule=rep("total RNA",n),extraction=rep("Illumina TruSeq RNA",n),library_strategy=rep("RNA-Seq",n),library_source=rep("transcriptomic",n),library_selection=rep("cDNA",n),instrument_model=rep("Illumina HiSeq 2000",n),data_processing=rep("Alignment to GRCh37 using TopHat-2.0.4, default settings for paired-end reads",n),row.names=samplesFull$run))
## experimentData(parathyroidGenes) <- expdata
## protocolData(parathyroidGenes) <- protocoldata


###################################################
### code chunk number 6: create_objects.Rnw:147-157 (eval = FALSE)
###################################################
## library("DEXSeq")
## exoncountfiles <- paste(samplesFull$run,"_exon_counts.txt",sep="")
## annotationfile <- "Hsap.GRCh37.DEXSeq.gff"
## design <- data.frame(lapply(samplesFull, factor))
## parathyroidExons <- read.HTSeqCounts(countfiles = exoncountfiles, 
##                                      design = design,
##                                      flattenedfile = annotationfile)
## sampleNames(parathyroidExons) <- pData(parathyroidExons)$run
## experimentData(parathyroidExons) <- expdata
## protocolData(parathyroidExons) <- protocoldata


###################################################
### code chunk number 7: create_objects.Rnw:164-166
###################################################
library("DESeq")
library("DEXSeq")


###################################################
### code chunk number 8: create_objects.Rnw:170-177
###################################################
data(parathyroidGenes)
data(parathyroidExons)
plot(colSums(counts(parathyroidGenes)),colSums(counts(parathyroidExons)),
     xlab="sum over genes",ylab="sum over exons",
     main="Parathyroid sample counts",cex.axis=.7)
abline(0,2)
legend("bottomright","y = 2x",lty=1)


###################################################
### code chunk number 9: create_objects.Rnw:183-185 (eval = FALSE)
###################################################
## save(parathyroidGenes,file="data/parathyroidGenes.RData")
## save(parathyroidExons,file="data/parathyroidExons.RData")


###################################################
### code chunk number 10: create_objects.Rnw:190-191
###################################################
toLatex(sessionInfo())


