### R code from vignette source 'CopyNumber450k.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: setup
###################################################
options(keep.source=TRUE)


###################################################
### code chunk number 2: load
###################################################
library(CopyNumber450k)
library(CopyNumber450kData)
library(minfiData)


###################################################
### code chunk number 3: loaddata
###################################################
# Load control data (n=52) from CopyNumber450kData
data(RGcontrolSetEx)

# Load example data (n=6) from minfiData
data(RGsetEx)
# In order to reduce example time, let's use only one sample
# and 30 controls (instead of 52). In real life situations, it is advised to
# use all the available controls.
RGsetEx <- RGsetEx[, 5]
RGcontrolSetEx <- RGcontrolSetEx[, sample(1:ncol(RGcontrolSetEx), 30)]


###################################################
### code chunk number 4: createobject
###################################################
# Ensure that Sample_Group values are valid
head(pData(RGcontrolSetEx)$Sample_Group)
head(pData(RGsetEx)$Sample_Group)

# Combine both RGsets in a single RGset
RGset <- combine(RGcontrolSetEx, RGsetEx)

# Create the object
mcds <- CNV450kSet(RGset)

# In order to speed up example computation, we will randomly subset the
# probes used by CopyNumber450k. THIS SHOULD NEVER BE DONE AS IT SERVES
# ONLY FOR SPEEDING UP THE EXAMPLE.
mcds <- mcds[sample(1:nrow(mcds), 10000), ]


###################################################
### code chunk number 5: dropSNPprobes
###################################################
mcds <- dropSNPprobes(mcds, maf_threshold=0.01)


###################################################
### code chunk number 6: densityplot
###################################################
plotDensity(mcds, main="Pre-normalization density plot",
        color.by="array.row")


###################################################
### code chunk number 7: PCAplot
###################################################
plotPCA(mcds, main="Pre-normalization PCA plot",
        color.by="sample.group")


###################################################
### code chunk number 8: quannorm
###################################################
mcds.q <- normalize(mcds, "quantile")


###################################################
### code chunk number 9: funnormDensity
###################################################
mcds.f <- normalize(mcds, "functional")
plotDensity(mcds.f, main="Density plot of functional normalized data")


###################################################
### code chunk number 10: segmentation
###################################################
mcds.q <- segmentize(mcds.q)


###################################################
### code chunk number 11: writecsv (eval = FALSE)
###################################################
## write.csv(mcds.q, file="segments.csv")


###################################################
### code chunk number 12: plotSample
###################################################
plotSample(mcds.q, 1, main="Genomic view of Sample 1")


###################################################
### code chunk number 13: plotSampleFocal
###################################################
plotSample(mcds.q, 1, chr="chr1",
        main="Zoom of chr1", ylim=c(-.25,.25))


###################################################
### code chunk number 14: sessionInfo
###################################################
toLatex(sessionInfo())


