### R code from vignette source 'DECIPHERing.Rnw'

###################################################
### code chunk number 1: DECIPHERing.Rnw:51-53
###################################################
options(continue=" ")
options(width=60)


###################################################
### code chunk number 2: startup
###################################################
library(DECIPHER)


###################################################
### code chunk number 3: expr1
###################################################
# access a sequence file included in the package:
gen <- system.file("extdata", "Bacteria_175seqs.gen", package="DECIPHER")

# connect to a database:
dbConn <- dbConnect(SQLite(), ":memory:")

# import the sequences into the sequence database
Seqs2DB(gen, "GenBank", dbConn, "Bacteria")


###################################################
### code chunk number 4: expr2
###################################################
BrowseDB(dbConn)


###################################################
### code chunk number 5: expr3
###################################################
l <- IdLengths(dbConn)
head(l)
Add2DB(l, dbConn)
BrowseDB(dbConn, maxChars=20)


###################################################
### code chunk number 6: expr4
###################################################
r <- IdentifyByRank(dbConn, add2tbl=TRUE)
BrowseDB(dbConn, maxChars=20)


###################################################
### code chunk number 7: expr5
###################################################
dna <- SearchDB(dbConn, id="Bacteroidetes")
BrowseSequences(subseq(dna, 140, 240))


###################################################
### code chunk number 8: expr6
###################################################
d <- DistanceMatrix(dna, correction="Jukes-Cantor", verbose=FALSE)
c <- IdClusters(d, method="ML", cutoff=.05, showPlot=TRUE, myXStringSet=dna, verbose=FALSE)


###################################################
### code chunk number 9: expr7
###################################################
dbDisconnect(dbConn)


###################################################
### code chunk number 10: sessinfo
###################################################
toLatex(sessionInfo(), locale=FALSE)


