### R code from vignette source 'GEOmetadb.Rnw'

###################################################
### code chunk number 1: GEOmetadb.Rnw:49-50
###################################################
options(width=55)


###################################################
### code chunk number 2: GEOmetadb.Rnw:57-58
###################################################
library(GEOmetadb)


###################################################
### code chunk number 3: GEOmetadb.Rnw:62-63
###################################################
getSQLiteFile()


###################################################
### code chunk number 4: GEOmetadb.Rnw:70-71
###################################################
file.info('GEOmetadb.sqlite')


###################################################
### code chunk number 5: GEOmetadb.Rnw:75-77
###################################################
con <- dbConnect(SQLite(),'GEOmetadb.sqlite')
dbDisconnect(con)


###################################################
### code chunk number 6: GEOmetadb.Rnw:90-91
###################################################
con <- dbConnect(SQLite(),'GEOmetadb.sqlite')


###################################################
### code chunk number 7: GEOmetadb.Rnw:95-97
###################################################
geo_tables <- dbListTables(con)
geo_tables


###################################################
### code chunk number 8: GEOmetadb.Rnw:101-102
###################################################
dbListFields(con,'gse')


###################################################
### code chunk number 9: GEOmetadb.Rnw:106-107
###################################################
sqliteQuickSQL(con,'PRAGMA TABLE_INFO(gpl)')


###################################################
### code chunk number 10: GEOmetadb.Rnw:113-115
###################################################
rs <- dbGetQuery(con,'select * from gse limit 5')
rs[,1:7]


###################################################
### code chunk number 11: GEOmetadb.Rnw:119-122
###################################################
rs <- dbGetQuery(con,paste("select gse,title from gse where",
                           "contributor like '%Sean%Davis%'",sep=" "))
rs


###################################################
### code chunk number 12: GEOmetadb.Rnw:127-131
###################################################
rs <- dbGetQuery(con,paste("select gsm,supplementary_file",
                           "from gsm where gpl='GPL96'",
                           "and supplementary_file like '%CEL.gz'"))
dim(rs)


###################################################
### code chunk number 13: GEOmetadb.Rnw:136-142
###################################################
rs <- dbGetQuery(con,paste("select gpl.bioc_package,gsm.gpl,",
                           "gsm,gsm.supplementary_file",
                           "from gsm join gpl on gsm.gpl=gpl.gpl",
                           "where gpl.manufacturer='Affymetrix'",
                           "and gsm.supplementary_file like '%CEL.gz' "))
rs[1:5,]


###################################################
### code chunk number 14: GEOmetadb.Rnw:146-151
###################################################
getTableCounts <- function(tableName,conn) {
  sql <- sprintf("select count(*) from %s",tableName)
  return(dbGetQuery(conn,sql)[1,1])
}
do.call(rbind,sapply(geo_tables,getTableCounts,con,simplify=FALSE))


###################################################
### code chunk number 15: GEOmetadb.Rnw:160-161
###################################################
conversion <- geoConvert('GPL96')


###################################################
### code chunk number 16: GEOmetadb.Rnw:166-171
###################################################
lapply(conversion, dim)
conversion$gse[1:5,]
conversion$gsm[1:5,]
conversion$gds[1:5,]
conversion$sMatrix[1:5,]


###################################################
### code chunk number 17: GEOmetadb.Rnw:178-179
###################################################
getBiocPlatformMap(con, bioc=c('hgu133a','hgu95av2'))


###################################################
### code chunk number 18: GEOmetadb.Rnw:185-198
###################################################
sql <- paste("SELECT DISTINCT gse.title,gse.gse",
             "FROM",
             "  gsm JOIN gse_gsm ON gsm.gsm=gse_gsm.gsm",
             "  JOIN gse ON gse_gsm.gse=gse.gse",
             "  JOIN gse_gpl ON gse_gpl.gse=gse.gse",
             "  JOIN gpl ON gse_gpl.gpl=gpl.gpl",
             "WHERE",
             "  gsm.molecule_ch1 like '%total RNA%' AND",
             "  gse.title LIKE '%breast cancer%' AND",
             "  gpl.organism LIKE '%Homo sapiens%'",sep=" ")
rs <- dbGetQuery(con,sql)
dim(rs)
print(rs[1:5,],right=FALSE)


###################################################
### code chunk number 19: GEOmetadb.Rnw:203-204
###################################################
dbDisconnect(con)


###################################################
### code chunk number 20: GEOmetadb.Rnw:208-209
###################################################
file.remove('GEOmetadb.sqlite')


