### R code from vignette source 'MANOR.Rnw'

###################################################
### code chunk number 1: MANOR.Rnw:68-69
###################################################
require(MANOR)


###################################################
### code chunk number 2: MANOR.Rnw:97-103
###################################################
SNR.FUN <- function(arrayCGH, var.FG, var.BG, snr.thr) {
  which(arrayCGH$arrayValues[[var.FG]] < arrayCGH$arrayValues[[var.BG]]*snr.thr)
}
SNR.char <- "B"
SNR.label <- "Low signal to noise ratio"
SNR.flag <- to.flag(SNR.FUN, SNR.char, args=alist(var.FG="REF_F_MEAN", var.BG="REF_B_MEAN", snr.thr=3))


###################################################
### code chunk number 3: MANOR.Rnw:108-118
###################################################
global.spatial.FUN <- function(arrayCGH, var)
  {
    if (!is.null(arrayCGH$arrayValues$Flag))
        arrayCGH$arrayValues$LogRatio[which(arrayCGH$arrayValues$Flag!="")] <- NA
##     Trend <- arrayTrend(arrayCGH, var, span=0.03, degree=1, iterations=3, family="symmetric")
    Trend <- arrayTrend(arrayCGH, var, span=0.03, degree=1, iterations=3)
    arrayCGH$arrayValues[[var]] <- Trend$arrayValues[[var]]-Trend$arrayValues$Trend
    arrayCGH
  }
global.spatial.flag <- to.flag(global.spatial.FUN, args=alist(var="LogRatio"))


###################################################
### code chunk number 4: MANOR.Rnw:125-135
###################################################
chromosome.FUN <- function(arrayCGH, var) {
  var.rep <- arrayCGH$id.rep
  w <- which(!is.na(match(as.character(arrayCGH$cloneValues[[var]]), c("X", "Y"))))
  l <- arrayCGH$cloneValues[w, var.rep]
  which(!is.na(match(arrayCGH$arrayValues[[var.rep]], as.character(l))))
}

chromosome.char <- "X"
chromosome.label <- "Sexual chromosome"
chromosome.flag <- to.flag(chromosome.FUN, chromosome.char, type="temp.flag", args=alist(var="Chromosome"), label=chromosome.label)


###################################################
### code chunk number 5: MANOR.Rnw:142-143
###################################################
args(to.flag)


###################################################
### code chunk number 6: MANOR.Rnw:152-153
###################################################
args(flag.arrayCGH)


###################################################
### code chunk number 7: MANOR.Rnw:159-160
###################################################
args(flag.summary.arrayCGH)


###################################################
### code chunk number 8: MANOR.Rnw:164-165
###################################################
args(flag.summary.default)


###################################################
### code chunk number 9: MANOR.Rnw:181-187
###################################################
pct.spot.FUN <- function(arrayCGH, var) {
  100*sum(!is.na(arrayCGH$arrayValues[[var]]))/dim(arrayCGH$arrayValues)[1]
}
pct.spot.name <- "SPOT_PCT"
pct.spot.label <- "Proportion of spots after normalization"
pct.spot.qscore <- to.qscore(pct.spot.FUN, name=pct.spot.name, args=alist(var="LogRatioNorm"), label=pct.spot.label)


###################################################
### code chunk number 10: MANOR.Rnw:194-195
###################################################
args(to.qscore)


###################################################
### code chunk number 11: MANOR.Rnw:200-201
###################################################
args(qscore.arrayCGH)


###################################################
### code chunk number 12: MANOR.Rnw:206-207
###################################################
args(qscore.summary.arrayCGH)


###################################################
### code chunk number 13: MANOR.Rnw:215-216
###################################################
data(spatial)


###################################################
### code chunk number 14: MANOR.Rnw:228-232
###################################################
data(spatial)

## edge: example of array with local spatial effects
arrayPlot(edge, "LogRatio", main="Local spatial effects", zlim=c(-1,1), mediancenter=TRUE, bar="h")


###################################################
### code chunk number 15: MANOR.Rnw:243-245
###################################################
data(spatial)
arrayPlot(gradient, "LogRatio", main="Spatial gradient" , zlim=c(-2,2), mediancenter=TRUE, bar="h")


###################################################
### code chunk number 16: MANOR.Rnw:272-274
###################################################
data(spatial)
genome.plot(edge.norm, chrLim="LimitChr", cex=1)


###################################################
### code chunk number 17: MANOR.Rnw:282-285
###################################################
data(spatial)
edge.norm$cloneValues$ZoneGNL <- as.factor(edge.norm$cloneValues$ZoneGNL)
genome.plot(edge.norm, col.var="ZoneGNL", chrLim="LimitChr", cex=1)


###################################################
### code chunk number 18: MANOR.Rnw:297-299
###################################################
data(spatial)
report.plot(edge.norm, chrLim="LimitChr", zlim=c(-1,1), cex=1)


###################################################
### code chunk number 19: MANOR.Rnw:310-317
###################################################
dir.in <- system.file("extdata", package="MANOR")

## import from 'spot' files
spot.names <- c("LogRatio", "RefFore", "RefBack", "DapiFore", "DapiBack", "SpotFlag", "ScaledLogRatio")
clone.names <- c("PosOrder", "Chromosome")
edge <- import(paste(dir.in, "/edge.txt", sep=""), type="spot",
spot.names=spot.names, clone.names=clone.names, add.lines=TRUE)


###################################################
### code chunk number 20: MANOR.Rnw:322-331
###################################################
data(flags)
data(spatial)

## local.spatial.flag$args <- alist(var="ScaledLogRatio", by.var=NULL, nk=5, prop=0.25, thr=0.15, beta=1, family="symmetric")
local.spatial.flag$args <- alist(var="ScaledLogRatio", by.var=NULL, nk=5, prop=0.25, thr=0.15, beta=1, family="gaussian")
flag.list <- list(spatial=local.spatial.flag, spot=spot.corr.flag, ref.snr=ref.snr.flag, dapi.snr=dapi.snr.flag, rep=rep.flag, unique=unique.flag)

edge.norm <- norm(edge, flag.list=flag.list, FUN=median, na.rm=TRUE)
edge.norm <- sort(edge.norm, position.var="PosOrder")


###################################################
### code chunk number 21: MANOR.Rnw:336-337
###################################################
report.plot(edge.norm, chrLim="LimitChr", zlim=c(-1,1), cex=1)


###################################################
### code chunk number 22: MANOR.Rnw:345-360
###################################################
##DNA copy number assessment: GLAD
profileCGH <- as.profileCGH(edge.norm$cloneValues)

profileCGH <- daglad(profileCGH, smoothfunc="lawsglad", lkern="Exponential", model="Gaussian", qlambda=0.999,  bandwidth=10, base=FALSE, round=2, lambdabreak=6, lambdaclusterGen=20, param=c(d=6), alpha=0.001, msize=2, method="centroid", nmin=1, nmax=8, amplicon=1, deletion=-5, deltaN=0.10,  forceGL=c(-0.15,0.15), nbsigma=3, MinBkpWeight=0.35, verbose=FALSE)

edge.norm$cloneValues <- as.data.frame(profileCGH)
edge.norm$cloneValues$ZoneGNL <- as.factor(edge.norm$cloneValues$ZoneGNL)

data(qscores)
## list of relevant quality scores
qscore.list <- list(smoothness=smoothness.qscore,
                    var.replicate=var.replicate.qscore,
                    dynamics=dynamics.qscore)
edge.norm$quality <- qscore.summary.arrayCGH(edge.norm, qscore.list)
edge.norm$quality


###################################################
### code chunk number 23: MANOR.Rnw:367-368
###################################################
html.report(edge.norm, dir.out=".", array.name="an array with local bias", chrLim="LimitChr", light=FALSE, pch=20, zlim=c(-2,2), file.name="edge")


###################################################
### code chunk number 24: MANOR.Rnw:378-395
###################################################
## import from 'gpr' files
spot.names <- c("Clone", "FLAG", "TEST_B_MEAN", "REF_B_MEAN", "TEST_F_MEAN", "REF_F_MEAN", "ChromosomeArm")
clone.names <- c("Clone", "Chromosome", "Position", "Validation")

ac <- import(paste(dir.in, "/gradient.gpr", sep=""), type="gpr", spot.names=spot.names, clone.names=clone.names, sep="\t", comment.char="@", add.lines=TRUE)

## compute log-ratio
ac$arrayValues$F1 <- log(ac$arrayValues[["TEST_F_MEAN"]], 2)
ac$arrayValues$F2 <- log(ac$arrayValues[["REF_F_MEAN"]], 2)
ac$arrayValues$B1 <- log(ac$arrayValues[["TEST_B_MEAN"]], 2)
ac$arrayValues$B2 <- log(ac$arrayValues[["REF_B_MEAN"]], 2)

Ratio <- (ac$arrayValues[["TEST_F_MEAN"]]-ac$arrayValues[["TEST_B_MEAN"]])/
    (ac$arrayValues[["REF_F_MEAN"]]-ac$arrayValues[["REF_B_MEAN"]])
Ratio[(Ratio<=0)|(abs(Ratio)==Inf)] <- NA
ac$arrayValues$LogRatio <- log(Ratio, 2)
gradient <- ac


###################################################
### code chunk number 25: MANOR.Rnw:401-408
###################################################
data(spatial)
data(flags)

flag.list <- list(local.spatial=local.spatial.flag, spot=spot.flag, SNR=SNR.flag, global.spatial=global.spatial.flag, val.mark=val.mark.flag, position=position.flag, unique=unique.flag, amplicon=amplicon.flag, chromosome=chromosome.flag, replicate=replicate.flag)

gradient.norm <- norm(gradient, flag.list=flag.list, FUN=median, na.rm=TRUE)
gradient.norm <- sort(gradient.norm)


###################################################
### code chunk number 26: MANOR.Rnw:412-413
###################################################
genome.plot(gradient.norm, chrLim="LimitChr", cex=1)


###################################################
### code chunk number 27: MANOR.Rnw:420-433
###################################################
##DNA copy number assessment: GLAD
profileCGH <- as.profileCGH(gradient.norm$cloneValues)

profileCGH <- daglad(profileCGH, smoothfunc="lawsglad", lkern="Exponential", model="Gaussian", qlambda=0.999,  bandwidth=10, base=FALSE, round=2, lambdabreak=6, lambdaclusterGen=20, param=c(d=6), alpha=0.001, msize=2, method="centroid", nmin=1, nmax=8, amplicon=1, deletion=-5, deltaN=0.10,  forceGL=c(-0.15,0.15), nbsigma=3, MinBkpWeight=0.35, verbose=FALSE)

gradient.norm$cloneValues <- as.data.frame(profileCGH)
gradient.norm$cloneValues$ZoneGNL <- as.factor(gradient.norm$cloneValues$ZoneGNL)

data(qscores)
## list of relevant quality scores
qscore.list <- list(smoothness=smoothness.qscore, var.replicate=var.replicate.qscore, dynamics=dynamics.qscore)
gradient.norm$quality <- qscore.summary.arrayCGH(gradient.norm, qscore.list)
gradient.norm$quality


###################################################
### code chunk number 28: MANOR.Rnw:440-441
###################################################
html.report(gradient.norm, dir.out=".", array.name="an array with spatial gradient", chrLim="LimitChr", light=FALSE, pch=20, zlim=c(-2,2), file.name="gradient")


###################################################
### code chunk number 29: MANOR.Rnw:450-451
###################################################
sessionInfo()


###################################################
### code chunk number 30: MANOR.Rnw:459-460
###################################################
Sys.sleep(20)


