### R code from vignette source 'RamiGO.Rnw'

###################################################
### code chunk number 1: setup
###################################################
##library(pgfSweave)
##setCacheDir("cache")
options(keep.source=TRUE)
options(width=60)


###################################################
### code chunk number 2: loadpackages
###################################################
library(RamiGO)


###################################################
### code chunk number 3: getAmigoTreePNG
###################################################
goIDs <- c("GO:0051130","GO:0019912","GO:0005783","GO:0043229","GO:0050789")
color <- c("lightblue","red","yellow","green","pink")
pngRes <- getAmigoTree(goIDs=goIDs, color=color, filename="example", picType="png", saveResult=TRUE)


###################################################
### code chunk number 4: getAmigoTreeSVG (eval = FALSE)
###################################################
## svgRes <- getAmigoTree(goIDs=goIDs, color=color, filename="example", picType="svg", saveResult=TRUE)


###################################################
### code chunk number 5: getAmigoTreeDOT
###################################################
dotRes <- getAmigoTree(goIDs=goIDs, color=color, filename="example", picType="dot", saveResult=TRUE)
tt <- readAmigoDot(object=dotRes)
## reading the file would also work!
## tt <- readAmigoDot(filename="example.dot")
show(tt)


###################################################
### code chunk number 6: leaves
###################################################
leavesTT <- leaves(tt)
leavesTT[,c("node","GO_ID","description")]


###################################################
### code chunk number 7: adjM2gml (eval = FALSE)
###################################################
## gg <- adjM2gml(adjMatrix(tt),relations(tt)$color,annot(tt)$fillcolor,annot(tt)$GO_ID,annot(tt)$description,"example")


###################################################
### code chunk number 8: c5gomapping
###################################################
data(c5.go.mapping)
head(c5.go.mapping)


###################################################
### code chunk number 9: gseaexec (eval = FALSE)
###################################################
## ## paths to gsea jar and gmt file
## exe.path <- exe.path.string
## gmt.path <- gmt.path.string
## 
## gsea.collapse <- "false"
## ## number of permutations
## nperm <- 10000
## gsea.seed <- 54321
## gsea.out <- "out-folder"
## 
## ## build GSEA command
## gsea.report <- "report-file"
## rnk.path <- "rank-file"
## gsea.cmd <- sprintf("java -Xmx4g -cp %s xtools.gsea.GseaPreranked -gmx %s -collapse %s -nperm %i -rnk %s -scoring_scheme weighted -rpt_label %s -include_only_symbols true -make_sets true -plot_top_x 75 -rnd_seed %i -set_max 500 -set_min 15 -zip_report true -out %s -gui false", exe.path, gmt.path, gsea.collapse, nperm, rnk.path, gsea.report, gsea.seed, gsea.out)
## 
## ## execute command on the system
## system(gsea.cmd)


###################################################
### code chunk number 10: readgseaxls (eval = FALSE)
###################################################
## resn <- "xxx" ## number generated by GSEA that you can get with grep(), strsplit() and dir()
## tt <- rbind(read.table(sprintf("%s/%s/gsea_report_for_na_pos_%s.xls", gsea.out, gsea.report,resn), stringsAsFactors=FALSE, sep="\t", header=TRUE), read.table(sprintf("%s/%s/gsea_report_for_na_neg_%s.xls", gsea.out, gsea.report, restn), stringsAsFactors=FALSE, sep="\t", header=TRUE))


###################################################
### code chunk number 11: strapplyexample
###################################################
strapply(c("node25 -> node30"), "node([\\d]+) -> node([\\d]+)", c, backref = -2)


###################################################
### code chunk number 12: sessionInfo
###################################################
toLatex(sessionInfo())


