### R code from vignette source 'crlmmDownstream.Rnw'

###################################################
### code chunk number 1: loadData
###################################################
library(oligoClasses)
library(VanillaICE)
library(crlmm)
library(SNPchip)
library(IRanges)
library(foreach)


###################################################
### code chunk number 2: data
###################################################
data(cnSetExample, package="crlmm")


###################################################
### code chunk number 3: snow (eval = FALSE)
###################################################
## ##registerDoSEQ()
## library(snow)
## library(doSNOW)
## cl <- makeCluster(2, type="SOCK")
## registerDoSNOW(cl)
## ocSamples(2)


###################################################
### code chunk number 4: crlmmDownstream.Rnw:60-61
###################################################
registerDoSEQ()


###################################################
### code chunk number 5: coerce2OligoSnpSet
###################################################
oligoList <- BafLrrSetList(cnSetExample)
oligoList[[1]]


###################################################
### code chunk number 6: windowselection (eval = FALSE)
###################################################
## library(ArrayTV)
## i <- seq_len(ncol(oligoList))
## ocSamples(20)
## increms <- c(10,1000,100e3)
## wins <- c(100,10e3,1e6)
## tvScores <- gcCorrect(oligoList[, 1],
## 		      increms=increms,
## 		      maxwins=wins,
## 		      returnOnlyTV=TRUE,
## 		      verbose=TRUE)
## order(tvScores[[1]][,2], decreasing=TRUE)


###################################################
### code chunk number 7: gccontent (eval = FALSE)
###################################################
## gc.matrix <- computeGC(oligoList, c(10, 10e3), c(10,10e3))


###################################################
### code chunk number 8: gccorrect (eval = FALSE)
###################################################
## oligoList2 <- gcCorrect(oligoList, increms=c(10,10e3), maxwins=c(10,10e3),
## 			providedGC=gc.matrix)


###################################################
### code chunk number 9: hmm
###################################################
res <- hmm(oligoList, p.hom=0.1, nupdates=5, TAUP=1e10)


###################################################
### code chunk number 10: subset
###################################################
oligoSet <- oligoList[[1]]


###################################################
### code chunk number 11: accessors
###################################################
r <- lrr(oligoSet)
b <- baf(oligoSet)


###################################################
### code chunk number 12: integerscale
###################################################
range(r, na.rm=TRUE)
range(b, na.rm=TRUE)


###################################################
### code chunk number 13: originalscale
###################################################
r <- r/100
b <- b/1000


###################################################
### code chunk number 14: gr.altered
###################################################
gr <- unlist(res)
gr <- gr[state(gr) %in% c(1,2,5,6) & sampleNames(gr) == "NA19007",]


###################################################
### code chunk number 15: gr.altered
###################################################
chr <- paste("chr", chromosome(oligoList), sep="")
brList <- oligoList[chr %in% chromosome(gr)]
brList <- brList[, match(sampleNames(gr)[1], sampleNames(brList))]
se <- as(brList, "SummarizedExperiment")


###################################################
### code chunk number 16: data.frame
###################################################
df <- dataFrame(gr, se, maxgap=500e3)
head(df)


###################################################
### code chunk number 17: latticefigs
###################################################
colors <- c("red", "orange", "white", "white",
	    "lightblue", "blue")[state(gr)]
figs <- latticeFigs(gr, df, colors=colors)


###################################################
### code chunk number 18: arrangeFig
###################################################
library(grid)
library(lattice)
arrangeFigs(figs)


###################################################
### code chunk number 19: parallelEnvironment (eval = FALSE)
###################################################
## library(foreach)
## library(snow)
## library(doSNOW)
## cl <- makeCluster(2, type="SOCK")
## registerDoSNOW(cl)
## ocSamples(2)


###################################################
### code chunk number 20: fitParallel (eval = FALSE)
###################################################
## res2 <- hmm(oligoList, p.hom=0, TAUP=1e10, nupdates=5)


###################################################
### code chunk number 21: stopcl (eval = FALSE)
###################################################
## stopCluster(cl)


###################################################
### code chunk number 22: crlmmDownstream.Rnw:305-306
###################################################
toLatex(sessionInfo())


