### R code from vignette source 'alsace.Rnw'

###################################################
### code chunk number 1: alsace.Rnw:115-125
###################################################
library(alsace)
data(tea)
tpoints <- as.numeric(rownames(tea.raw[[1]]))
lambdas <- as.numeric(colnames(tea.raw[[1]]))
par(mfrow = c(1,5))
for (i in 1:5)
    contour(tpoints, lambdas, tea.raw[[i]], col = terrain.colors(15),
            main = names(tea.raw)[i],
            xlab = "Retention time (min.)", ylab = "Wavelength (nm)")



###################################################
### code chunk number 2: alsace.Rnw:182-185 (eval = FALSE)
###################################################
## allf <- list.files("foo", pattern = "csv", full.names = TRUE)
## mydata <- lapply(allf, read.csv)
## names(mydata) <- paste("f", 1:length(allf), sep = "")


###################################################
### code chunk number 3: alsace.Rnw:194-195
###################################################
lapply(tea.raw[1:2], function(x) x[1:4, 1:6])


###################################################
### code chunk number 4: alsace.Rnw:217-223
###################################################
new.lambdas <- seq(260, 500, by = 2)
tea <- lapply(tea.raw,
              preprocess,
              dim2 = new.lambdas)
dim(tea.raw[[1]])
dim(tea[[1]])


###################################################
### code chunk number 5: alsace.Rnw:262-263
###################################################
tea.opa <- opa(tea, 4)


###################################################
### code chunk number 6: alsace.Rnw:273-277
###################################################
matplot(new.lambdas, tea.opa, lty = 1, ylab = "Response",
        xlab = expression(lambda), type = "l")
legend("topright", legend = paste("Comp.", 1:4), bty = "n",
       lty = 1, col = 1:4)


###################################################
### code chunk number 7: alsace.Rnw:316-318
###################################################
tea.als <- doALS(tea, tea.opa)
summary(tea.als)


###################################################
### code chunk number 8: alsace.Rnw:334-339
###################################################
par(mfrow = c(1,2))
plot(tea.als)
plot(tea.als, what = "profiles", mat.idx = 1)
legend("topleft", legend = paste("Comp.", 1:4), bty = "n",
       lty = 1, col = 1:4)


###################################################
### code chunk number 9: alsace.Rnw:367-369
###################################################
smallC <- smallComps(tea.als, Ithresh = 10)
smallC


###################################################
### code chunk number 10: alsace.Rnw:441-443
###################################################
pks <- getAllPeaks(tea.als$CList, span = 5)
sapply(pks, function(x) sapply(x, nrow))


###################################################
### code chunk number 11: alsace.Rnw:475-477
###################################################
warping.models <- correctRT(tea.als$CList, reference = 1,
                            what = "models")


###################################################
### code chunk number 12: alsace.Rnw:482-484
###################################################
pks.corrected <- correctPeaks(pks, warping.models)
pks.corrected[[2]][[1]]


###################################################
### code chunk number 13: alsace.Rnw:499-501
###################################################
pkTab <- getPeakTable(pks.corrected, response = "height")
head(pkTab)


###################################################
### code chunk number 14: alsace.Rnw:553-557
###################################################
maxResid <- max(abs(range(tea.als$resid)))
showALSresult(tea.als, tea.als$resid, tp = tpoints, wl = new.lambdas,
              logsc = FALSE, img.col = cm.colors(9), 
              mat.idx = 1:2, zlim =c(-maxResid, maxResid))


###################################################
### code chunk number 15: alsace.Rnw:585-586
###################################################
tea.split <- splitTimeWindow(tea, c(12, 14), overlap = 10)


###################################################
### code chunk number 16: alsace.Rnw:590-597
###################################################
tea.alslist <- lapply(tea.split,
                       function(Xl) {
                         Xl.opa <- opa(Xl, 4)
                         doALS(Xl, Xl.opa)
                       })
tea.merged <- mergeTimeWindows(tea.alslist)
dim(tea.merged$CList[[1]])


###################################################
### code chunk number 17: alsace.Rnw:612-618
###################################################
myPalette <- colorRampPalette(c("black", "red", "blue", "green"))
mycols <- myPalette(ncol(tea.merged$S))
par(mfrow = c(2,2))
plot(tea.merged, what = "profiles", mat.idx = 1:4, col = mycols)
legend("topleft", lty = 1, col = mycols, bty = "n", cex = .7,
       legend = paste("C", 1:ncol(tea.merged$S)))


###################################################
### code chunk number 18: alsace.Rnw:633-637
###################################################
full.time <- system.time({
  tea.opa <- opa(tea, 4)
  tea.als <- doALS(tea, tea.opa)
})


###################################################
### code chunk number 19: alsace.Rnw:639-648
###################################################
windows.time <- system.time({
  tea.split <- splitTimeWindow(tea, c(12, 14), overlap = 10)
  tea.alslist <- lapply(tea.split,
                        function(Xl) {
                          Xl.opa <- opa(Xl, 4)
                          doALS(Xl, Xl.opa)
                        })
  tea.merged <- mergeTimeWindows(tea.alslist)
})


###################################################
### code chunk number 20: alsace.Rnw:650-652
###################################################
full.time
windows.time


