### R code from vignette source 'ddgraph.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width=70)
set.seed(20)


###################################################
### code chunk number 2: toydata
###################################################
library(ddgraph)
data(toyExample)

toyExample
head(rawData(toyExample))


###################################################
### code chunk number 3: marginal
###################################################
ciTest(toyExample, "class", "A", test="fisher")
ciTest(toyExample, "class", "B", test="fisher")


###################################################
### code chunk number 4: cluster
###################################################
heatmap(as.matrix(rawData(toyExample)), scale="none", col=c("white", "black"))


###################################################
### code chunk number 5: cond2
###################################################
ciTest(toyExample, "class", "B", "A")


###################################################
### code chunk number 6: cond1
###################################################
ciTest(toyExample, "class", "A", "B")


###################################################
### code chunk number 7: toyfinal
###################################################
res <- calcDependence(toyExample)
causalNeigh <- res$nbr
causalNeigh


###################################################
### code chunk number 8: data
###################################################
options(width=70)
set.seed(10)


###################################################
### code chunk number 9: data
###################################################
library(ddgraph)
data(mesoBin)
names(mesoBin)
head(rawData(mesoBin$VM))


###################################################
### code chunk number 10: calcDep
###################################################
data(mesoBin)
calcDependence(mesoBin$VM, "ncpc", verbose=FALSE)
calcDependence(mesoBin$VM, "hc-bic")


###################################################
### code chunk number 11: ncpc
###################################################
data(mesoBin)
res <- calcDependence(mesoBin$VM, "ncpc", verbose=FALSE)
names(res)
dd <- res$obj
class(dd)
names(dd)
dd$params
dd$joint


###################################################
### code chunk number 12: ddgraph-plot
###################################################
plot(dd, col=TRUE)


###################################################
### code chunk number 13: ddgraph-plot
###################################################
combinationsTest(mesoBin$VM, c("Bin 6-8h", "Bin 8-10h"), 
	p.adjust.method="fdr", verbose=FALSE)


###################################################
### code chunk number 14: data-new
###################################################
data <- matrix(rbinom(50, 1, 0.5), ncol=5)
target <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
d <- makeDDDataSet(data, name="example data", classLabels=target)
d
rawData(d)
names(d)
d$V1
d$class


###################################################
### code chunk number 15: sessionInfo
###################################################
toLatex(sessionInfo())


