### R code from vignette source 'fastLiquidAssociation.Rnw'

###################################################
### code chunk number 1: SuppressLoadData
###################################################
library(WGCNA)
library(LiquidAssociation)
library(parallel)


###################################################
### code chunk number 2: loadData
###################################################
library(fastLiquidAssociation)
library(yeastCC)
library(org.Sc.sgd.db)
data(spYCCES)
lae <- spYCCES[,-(1:4)]
### get rid of samples with high % NA elements
lae <- lae[apply(is.na(exprs(lae)),1,sum) < ncol(lae)*0.3,]
probname <- rownames(exprs(lae))
data <- t(exprs(lae))
data <- data[,1:50]
dim(data)


###################################################
### code chunk number 3: calculate top MLA
###################################################
 
example <- fastMLA(data=data,topn=50,nvec=1:5,rvalue=0.5,cut=4)
example[1:5,]


###################################################
### code chunk number 4: Calculate CNM
###################################################
 
#from our example with fastMLA
CNMcalc <- mass.CNM(data=data,GLA.mat=example,nback=5)
CNMcalc


###################################################
### code chunk number 5: Calculate CNM boots
###################################################
 
fulldata <- t(exprs(lae))
load(system.file('data','testmat.RData',package='fastLiquidAssociation'))
notsense <- testmat
CNMother <- mass.CNM(data=fulldata,GLA.mat=notsense,nback=5)
CNMother


###################################################
### code chunk number 6: Time comparison
###################################################
 
#determine number of processors for multicore systems
cores <- detectCores()
cores
clust <- makeCluster(cores)
boottrips <- CNMother[[2]]
dim(boottrips)


###################################################
### code chunk number 7: Quantile normalization
###################################################
stand2 <- function(object){
	ans <- (object-mean(object,na.rm=TRUE))/sd(object,na.rm=TRUE)
	return(ans)
}

quant.norm <- function(vector){
	myvect <- vector
	n <- sum(as.numeric(!is.na(myvect)))
	rmyvect <- rank(myvect,na.last="keep")/(n+1)
	nmyvect <- sapply(rmyvect, qnorm)
	return(nmyvect)
}

dat.q <- apply(fulldata,2,quant.norm)
qnormdata <- apply(dat.q,2,stand2)


###################################################
### code chunk number 8: Speed Test
###################################################
 
bootlist <- qnormdata[,boottrips[1,1:3]]
dim(bootlist)
#We take the results for the first triplet and put it in matrix format 
example.boots <- t(as.matrix(boottrips[1,]))
dim(example.boots)
set.seed(1)
system.time(GLAnew <- fastboots.GLA(tripmat=example.boots,data=fulldata, clust=clust, boots=30, perm=500, cut=4))
set.seed(1)
system.time(GLAold <- getsGLA(bootlist,perm=500,boots=30, cut=4))
GLAnew
GLAold

#the matrix conversion is not needed for the 2 line result
set.seed(1)
system.time(GLAtwo <- fastboots.GLA(tripmat=boottrips,data=fulldata, clust=clust, boots=30, perm=500, cut=4))
GLAtwo
stopCluster(clust)


###################################################
### code chunk number 9: Extend Example
###################################################
library(GOstats)
library("org.Sc.sgd.db")
##X3 genes
topX3 <- unique(example[,3])
hyp.cutoff <- 0.05
####
params <- new("GOHyperGParams", geneIds=topX3,universeGeneIds=colnames(data),
annotation="org.Sc.sgd.db",ontology="BP",pvalueCutoff=hyp.cutoff,conditional=TRUE,
testDirection="over")
GOout <- hyperGTest(params)
summary(GOout,categorySize=5)


###################################################
### code chunk number 10: Obtain gene list
###################################################
###extracts GO list elements of summary(hyperGtestobj)<cutoff
###converts ORFids to Gene names and returns under GO list element
##for ontology BP
GOids <- summary(GOout,categorySize=5)$GOBPID
check <- GOout@goDag@nodeData@data
subset <- check[GOids]
terms <- summary(GOout,categorySize=5)$Term
test <- sapply(subset,function(m) m[1])
orflist <- lapply(test,function(x) intersect(x,topX3))
##creates mapping of ORFids to gene names
x <- org.Sc.sgdGENENAME
mappedgenes <- mappedkeys(x)
xx <- as.list(x[mappedgenes])
mapid <- names(xx)
##creates list of GO ids
genename1 <- lapply(orflist,function(x) xx[match(x,mapid)])
###
###if reduced num of terms desired use next line else skip to next ##
for(i in 1:length(genename1)){
if (length(genename1[[i]])>10) genename1[[i]]<-genename1[[i]][1:10]
}
##for full list use below
genelist <- lapply(genename1,function(x) paste(x,collapse=", "))
ugenes <- unlist(genelist)
names <- sapply(names(ugenes), function(x) unlist(strsplit(x, split='.', fixed=TRUE))[1])
umat <- matrix(ugenes)
umat <- cbind(terms,umat)
rownames(umat) <- names
colnames(umat) <- c("GO description","Associated genes")
umat


###################################################
### code chunk number 11: Session info
###################################################
sessionInfo()


