## set global options
options(
        ## the following options configure the menu bar
        home.url="/gcmap/index.rhtml",
        feedback.url="https://docs.google.com/a/gene.com/spreadsheet/viewform?formkey=dFZtSDRQTkR1MFVxSTIzMmRGbHIzN3c6MQ#gid=0",
        contact.email="mailto:gcmap-d@gene.com?Subject=gCMAP",
        name.out="gRED",
        link.out="http://gred.gene.com/groups/gred/index.html",
        ## limit the number of results displayed ( for which gene-level results are generated)
        max.results=50,
        ## suppress storage of intermediate files
        save.intermediates=TRUE,
        ## the following options specify the example queries filled into the UI when the 'Example query' button is clicked
        index.text="Compare your favorite genes to thousands of experiments performed inside and outside Genentech. Correlate results across different platforms - and connect genes, disease phenotypes and treatments.",
        profile.input.example="100505783, 4.11\\n100131096, 3.7\\n100130992, 3.06\\n100505703, 2.9\\n10014, 2.87\\n100126693, 2.61\\n100292680, 2.61\\n100422894, 2.55\\n100506262, 2.55\\n10023, 2.5\\n100505551, 2.48\\n100131347, 2.41\\n100131679, 2.34\\n100505695, 2.32\\n100506368, 2.27\\n100129434, 2.25\\n1000, 2.16\\n100289495, 2.15\\n100158262, 2.09\\n100131774, 2.06\\n100506453, 2.01\\n100287175, 1.97\\n100506267, 1.97\\n100131275, 1.92\\n100271722, 1.91\\n100506394, 1.9\\n100505988, 1.82\\n100289255, 1.75\\n100132183, 1.74\\n100288911, 1.72\\n100422874, 1.71\\n100505519, 1.7\\n100289298, 1.65\\n100132781, 1.63\\n100506428, 1.63\\n100268168, 1.6\\n100506495, 1.6\\n10006, 1.56\\n100287314, 1.53\\n100506643, 1.52\\n100379251, 1.51\\n100422914, 1.49\\n10000, 1.48\\n100289151, 1.48\\n100506528, 1.46\\n100506523, 1.43\\n100128155, 1.42\\n100505938, 1.41\\n100129940, 1.4\\n100129148, -1.42\\n100422842, -1.42\\n100505661, -1.43\\n100302138, -1.44\\n100506374, -1.45\\n100506683, -1.45\\n100132273, -1.46\\n10011, -1.48\\n100289379, -1.48\\n100129781, -1.5\\n100423037, -1.5\\n10004, -1.51\\n100302240, -1.54\\n100101490, -1.55\\n100302197, -1.55\\n100302221, -1.58\\n100506174, -1.59\\n100505564, -1.6\\n100133286, -1.62\\n100505899, -1.62\\n100505573, -1.63\\n100134713, -1.64\\n100113393, -1.65\\n100130800, -1.65\\n100500860, -1.65\\n100288413, -1.66\\n100505488, -1.66\\n100505875, -1.66\\n100506670, -1.67\\n100128726, -1.68\\n100505905, -1.71\\n100113378, -1.72\\n100286793, -1.73\\n100506544, -1.73\\n10036, -1.78\\n100505585, -1.81\\n100286988, -1.83\\n100506048, -1.84\\n100233156, -1.89\\n100129354, -1.98\\n100170841, -2.01\\n100506211, -2.04\\n100287042, -2.1\\n10046, -2.15\\n100130548, -2.18\\n100302739, -2.23\\n100131213, -2.27\\n100506285, -2.31\\n100505869, -2.43\\n100134868, -2.55\\n100500864, -2.87",
        unsigned.input.example="100130992, 100131096, 100505783, 100652757, 100653089, 10202, 10420, 10628, 10957, 113791, 114907, 127544, 128312, 153222, 169270, 2123, 222699, 22898, 2300, 23460, 255394, 256302, 26050, 26220, 26959, 283991, 2886, 28984, 29799, 3007, 3303, 3304, 3306, 345643, 374819, 388403, 388743, 390010, 407004, 440689, 4435, 4498, 4504, 5029, 51646, 5166, 54206, 54762, 54800, 54823, 54913, 55616, 558, 55818, 56204, 57180, 57599, 5971, 60468, 6095, 6103, 6340, 639, 64421, 6907, 7042, 7056, 727869, 7480, 7582, 7852, 80323, 80325, 83401, 8364, 8366, 84842, 84915, 84969, 868, 8736, 8780, 901, 9108, 9173, 9185, 9214, 9535, 9590, 9619, 9734, 9982",
        signed.input.example.down="101, 10124, 10487, 10826, 11309, 11313, 1316, 1390, 1443, 1509, 1645, 1646, 199, 2039, 2057, 2099, 212, 2232, 22941, 23344, 23462, 23616, 2564, 25816, 26020, 2623, 26286, 272, 29125, 2962, 2994, 3043, 30851, 3145, 3231, 3397, 360, 3662, 3726, 375346, 3757, 3856, 3858, 3875, 389, 391, 3927, 3937, 3992, 4005, 4059, 4066, 4162, 4170, 4253, 4354, 4609, 4668, 4758, 4778, 50488, 51092, 51393, 51573, 5190, 5292, 54480, 54507, 54863, 54918, 55501, 55652, 55846, 56, 56652, 57804, 5788, 5869, 5872, 5880, 598, 6006, 6007, 6016, 6282, 6296, 6320, 6397, 64092, 64170, 6464, 6483, 6515, 6623, 6774, 6776, 7138, 7360, 7525, 793, 7984, 823, 8237, 8273, 863, 871, 8942, 8991, 9181, 9289, 9562, 967, 9751, 976, 9840, 9871",
        signed.input.example.up="10007, 10273, 10434, 10560, 10636, 10794, 11001, 11137, 142, 1434, 1503, 150726, 1717, 1728, 1852, 2030, 730101, 22984, 23065, 23076, 23086, 23139, 23214, 23225, 23277, 23313, 23596, 25800, 25898, 2639, 2653, 26574, 26872, 27339, 2744, 27440, 29803, 29923, 3714, 3953, 4023, 4145, 4552, 4902, 4953, 5019, 5037, 51031, 51073, 51076, 51293, 51324, 51499, 54663, 54832, 54929, 55057, 55630, 55794, 55893, 57030, 5754, 5830, 5864, 6004, 642, 6502, 6526, 6652, 706, 7371, 8021, 81887, 84864, 8624, 8669, 8725, 898, 89944, 9019, 9110, 9221, 9775, 9975"
        )

##----- read & validate config file, load specified reference datasets
config.file.path <- "/gne/home/sandmat1/repository/bioinfo/projects/R/trunk/gCMAPWeb/inst/config/genentech_config.yml"
conf_data <- validate_config_file( config.file.path )
reference.cmaps <- load_cmaps( conf_data )

## create temporary directory for results
dir.create(file.path(tempdir(),'results'), showWarnings=FALSE)
