/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.geese.common;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.systemsbiology.gaggle.core.Boss;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.geese.common.GaggleConnectionListener;

public class RmiGaggleConnector {
    private Goose goose;
    private Boss boss;
    final String DEFAULT_HOSTNAME = "localhost";
    String serviceName = "gaggle";
    String hostname = "localhost";
    String uri = "rmi://" + this.hostname + "/" + this.serviceName;
    private Set<GaggleConnectionListener> listeners = new CopyOnWriteArraySet<GaggleConnectionListener>();
    private boolean exported = false;
    private boolean autoStartBoss = true;
    private long timerInterval = 200L;
    private long timerTimeout = 15000L;
    private boolean verbose = true;

    public RmiGaggleConnector(Goose goose) {
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        System.out.println("ttl settings changed in goose");
        if (goose == null) {
            throw new NullPointerException("RmiGaggleConnector requires a non-null goose.");
        }
        this.goose = goose;
        if (goose instanceof GaggleConnectionListener) {
            this.addListener((GaggleConnectionListener)((Object)goose));
        }
    }

    private synchronized void exportObject(Goose goose) throws Exception {
        try {
            UnicastRemoteObject.exportObject((Remote)goose, 0);
            this.exported = true;
        }
        catch (Exception e) {
            System.err.println("RmiGaggleConnector failed to export remote object: " + e.getMessage());
            throw e;
        }
    }

    public synchronized void connectToGaggle(String hostname) throws Exception {
        this.hostname = hostname;
        this.uri = "rmi://" + hostname + "/" + this.serviceName;
        this.connectToGaggle();
    }

    public synchronized void connectToGaggle() throws Exception {
        try {
            if (!this.exported) {
                this.exportObject(this.goose);
            }
            if (this.autoStartBoss && this.hostname.equals("localhost")) {
                try {
                    this.boss = (Boss)Naming.lookup(this.uri);
                }
                catch (Exception ex) {
                    if (ex.getMessage().startsWith("Connection refused to host:")) {
                        System.out.println("Couldn't find a boss, trying to start one....");
                        this.tryToStartBoss();
                    }
                }
            } else {
                this.boss = (Boss)Naming.lookup(this.uri);
            }
            String gooseName = this.boss.register(this.goose);
            this.goose.setName(gooseName);
            this.fireConnectionEvent(true);
        }
        catch (NullPointerException npe) {
            System.out.println("Boss isn't quite ready yet, trying again...");
        }
        catch (Exception e) {
            if (!this.autoStartBoss) {
                System.err.println("failed to connect to gaggle at " + this.uri + ": " + e.getMessage());
                if (this.verbose) {
                    e.printStackTrace();
                }
            }
            this.boss = null;
            this.fireConnectionEvent(false);
            throw e;
        }
    }

    private void tryToStartBoss() {
        String command = System.getProperty("java.home");
        command = command + File.separator + "bin" + File.separator + "javaws " + "http://gaggle.systemsbiology.net/2007-04/minimizedBoss.jnlp";
        try {
            Runtime.getRuntime().exec(command);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new WaitForBossStart(), 0L, this.timerInterval);
        }
        catch (IOException e) {
            System.out.println("Failed to start boss process!");
            e.printStackTrace();
        }
    }

    public synchronized void disconnectFromGaggle(boolean printStackTrace) {
        if (this.boss != null) {
            try {
                System.out.println("received disconnect request from " + this.goose.getName());
                this.boss.unregister(this.goose.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.boss = null;
        }
        if (this.exported) {
            block6: {
                try {
                    System.out.println("received disconnect request from " + this.goose.getName());
                    UnicastRemoteObject.unexportObject(this.goose, true);
                }
                catch (Exception e) {
                    if (!printStackTrace) break block6;
                    e.printStackTrace();
                }
            }
            this.exported = false;
        }
        this.fireConnectionEvent(false);
    }

    public synchronized void addListener(GaggleConnectionListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(GaggleConnectionListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireConnectionEvent(boolean connected) {
        for (GaggleConnectionListener listener : this.listeners) {
            try {
                listener.setConnected(connected, this.boss);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isConnected() {
        return this.boss != null;
    }

    public void setAutoStartBoss(boolean autoStartBoss) {
        this.autoStartBoss = autoStartBoss;
    }

    public boolean getAutoStartBoss() {
        return this.autoStartBoss;
    }

    public synchronized Boss getBoss() {
        return this.boss;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTimerTimeout(long timerTimeout) {
        this.timerTimeout = timerTimeout;
    }

    class WaitForBossStart
    extends TimerTask {
        long startTime = System.currentTimeMillis();

        WaitForBossStart() {
        }

        public void run() {
            long elapsed = System.currentTimeMillis() - this.startTime;
            if (elapsed > RmiGaggleConnector.this.timerTimeout) {
                System.out.println("Didn't hear from the boss for 15 seconds, timing out.");
                this.cancel();
            }
            try {
                Naming.lookup(RmiGaggleConnector.this.uri);
                RmiGaggleConnector.this.connectToGaggle();
                this.cancel();
            }
            catch (ConnectException ce) {
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    RmiGaggleConnector.this.connectToGaggle();
                    this.cancel();
                }
                catch (Exception ex) {
                    System.out.println("exception trying to connect using boss autostart: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

