### R code from vignette source 'inSilicoMerging.Rnw'

###################################################
### code chunk number 1: example_1
###################################################
library(inSilicoDb)
eset1 = getDataset("GSE19804", "GPL570", norm="FRMA", features = "gene", curation = 17470);
eset2 = getDataset("GSE10072", "GPL96",  norm="FRMA", features = "gene", curation = 17469);
esets = list(eset1,eset2);


###################################################
### code chunk number 2: example_2
###################################################
table(pData(eset1)[,"Disease"]);
table(pData(eset2)[,"Disease"]);


###################################################
### code chunk number 3: example_3
###################################################
library(inSilicoMerging);
eset_FRMA = merge(esets);


###################################################
### code chunk number 4: example_4
###################################################
plotMDS(eset_FRMA, 
        colLabel="Disease",
        symLabel="Study",
        main="FRMA (No Transformation)");


###################################################
### code chunk number 5: example_5
###################################################
eset_COMBAT = merge(esets, method="COMBAT");
plotMDS(eset_COMBAT,
        colLabel="Disease",
        symLabel="Study",
        main="COMBAT");


###################################################
### code chunk number 6: example_6a (eval = FALSE)
###################################################
## par(mfrow=c(1,2))
## select = sample(1:ncol(eset_FRMA),25);
## plotRLE(eset_FRMA[,select], colLabel="Study", legend=FALSE, main="FRMA");
## plotRLE(eset_COMBAT[,select], colLabel="Study", legend=FALSE, main="COMBAT");


###################################################
### code chunk number 7: example_6b
###################################################
ofile = "example_9.pdf";
pdf(file=ofile, paper="special", width=10, height=6);

par(mfrow=c(1,2))
select = sample(1:ncol(eset_FRMA),25);
plotRLE(eset_FRMA[,select], colLabel="Study", legend=FALSE, main="FRMA");
plotRLE(eset_COMBAT[,select], colLabel="Study", legend=FALSE, main="COMBAT");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 8: example_7a (eval = FALSE)
###################################################
## gene = "CA4";
## eset_BMC = merge(esets, method="BMC");
## eset_DWD = merge(esets, method="DWD");
## par(mfrow=c(2,2));
## plotGeneWiseBoxPlot(eset_FRMA, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=TRUE, main="FRMA");
## plotGeneWiseBoxPlot(eset_COMBAT, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="COMBAT");
## plotGeneWiseBoxPlot(eset_BMC, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="BMC");
## plotGeneWiseBoxPlot(eset_DWD, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="DWD");


###################################################
### code chunk number 9: example_7b
###################################################
ofile = "example_10.pdf";
pdf(file=ofile, paper="special", width=8, height=6);

gene = "CA4";
eset_BMC = merge(esets, method="BMC");
eset_DWD = merge(esets, method="DWD");
par(mfrow=c(2,2));
plotGeneWiseBoxPlot(eset_FRMA, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=TRUE, main="FRMA");
plotGeneWiseBoxPlot(eset_COMBAT, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=FALSE, main="COMBAT");
plotGeneWiseBoxPlot(eset_BMC, colLabel="Disease", batchLabel="Study", 
                                           gene=gene, legend=FALSE, main="BMC");
plotGeneWiseBoxPlot(eset_DWD, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=FALSE, main="DWD");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 10: example_8a (eval = FALSE)
###################################################
## gene = "RPL37A";
## par(mfrow=c(2,2));
## plotGeneWiseBoxPlot(eset_FRMA, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=TRUE, main="FRMA");
## plotGeneWiseBoxPlot(eset_COMBAT, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="COMBAT");
## plotGeneWiseBoxPlot(eset_BMC, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="BMC");
## plotGeneWiseBoxPlot(eset_DWD, colLabel="Disease", batchLabel="Study", 
##                     gene=gene, legend=FALSE, main="DWD");


###################################################
### code chunk number 11: example_8b
###################################################
ofile = "example_11.pdf";
pdf(file=ofile, paper="special", width=8, height=6);

gene = "RPL37A";
par(mfrow=c(2,2));
plotGeneWiseBoxPlot(eset_FRMA, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=TRUE, main="FRMA");
plotGeneWiseBoxPlot(eset_COMBAT, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=FALSE, main="COMBAT");
plotGeneWiseBoxPlot(eset_BMC, colLabel="Disease", batchLabel="Study", 
                                           gene=gene, legend=FALSE, main="BMC");
plotGeneWiseBoxPlot(eset_DWD, colLabel="Disease", batchLabel="Study", 
                                          gene=gene, legend=FALSE, main="DWD");

for(i in 1:1) { dev.off(); }
cat("\\begin{center}\\includegraphics[width=\\textwidth]{", ofile, "}\\end{center}\n\n", sep="");


###################################################
### code chunk number 12: inSilicoMerging.Rnw:265-266
###################################################
sessionInfo()


