/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.Spectra;
import java.util.HashMap;

class PsmPool {
    private HashMap<String, Spectra> psmHashMap = new HashMap();
    private HashMap<String, Integer> charge2targetPsMap = new HashMap();
    private HashMap<String, Integer> charge2decoyPsMap = new HashMap();
    private HashMap<String, Spectra> charge2lastPSM = new HashMap();

    public void addPsm(Spectra psm) {
        this.psmHashMap.put(psm.getIndex(), psm);
    }

    public HashMap<String, Spectra> getPsm() {
        return this.psmHashMap;
    }

    public void addPsm2chargeMap(Spectra psm) {
        String chargeClassString = psm.getChargeClass();
        if (psm.isDecoy()) {
            if (this.charge2decoyPsMap.containsKey(chargeClassString)) {
                int n = this.charge2decoyPsMap.get(chargeClassString);
                this.charge2decoyPsMap.put(chargeClassString, n + 1);
            } else {
                this.charge2decoyPsMap.put(chargeClassString, 1);
            }
        } else if (this.charge2targetPsMap.containsKey(chargeClassString)) {
            int n = this.charge2targetPsMap.get(chargeClassString);
            this.charge2targetPsMap.put(chargeClassString, n + 1);
        } else {
            this.charge2targetPsMap.put(chargeClassString, 1);
        }
    }

    public void putCharge2lastPSM(String chargeClass, Spectra psm) {
        this.charge2lastPSM.put(chargeClass, psm);
    }

    public HashMap<String, Spectra> getCharge2lastPSM() {
        return this.charge2lastPSM;
    }

    public int getTargetHitNum(String chargeClass) {
        return this.charge2targetPsMap.get(chargeClass);
    }

    public int getDecoyHitNum(String chargeClass) {
        return this.charge2decoyPsMap.get(chargeClass);
    }

    public HashMap<String, Integer> getCharge2targetPsMap() {
        return this.charge2targetPsMap;
    }

    public HashMap<String, Integer> getCharge2decoyPsMap() {
        return this.charge2decoyPsMap;
    }
}

