/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class WorkflowWizard {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    private Model wizardModel = new Model();
    private Controller wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;

    public WorkflowWizard(Frame desktop) {
        this.wizardDialog = new JDialog(desktop);
        this.initWizardComponents();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        this.wizardDialog.setLocationRelativeTo(this.wizardDialog.getParent());
        this.wizardDialog.show();
        return this.returnCode;
    }

    public void setCurrentPanel(Object id) {
        PanelDescriptor oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.backButton.setEnabled(this.wizardModel.getBackButtonEnabled());
        this.nextButton.setEnabled(this.wizardModel.getNextButtonEnabled());
        this.cardLayout.show(this.cardPanel, id.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void registerWizardPanel(Object id, PanelDescriptor panel) {
        this.cardPanel.add(panel.getPanelComponent(), id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    private void initWizardComponents() {
        this.wizardController = new Controller(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setText("Back");
        this.nextButton.setText("Next");
        this.cancelButton.setText("Cancel");
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.wizardDialog.getContentPane().add((Component)buttonPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    private Model getModel() {
        return this.wizardModel;
    }

    private Controller getController() {
        return this.wizardController;
    }

    public void close(int code) {
        this.returnCode = code;
        this.wizardDialog.dispose();
    }

    private static class Model {
        private PanelDescriptor currentPanel;
        private HashMap panelHashmap = new HashMap();

        PanelDescriptor getCurrentPanelDescriptor() {
            return this.currentPanel;
        }

        void registerPanel(Object id, PanelDescriptor descriptor) {
            this.panelHashmap.put(id, descriptor);
        }

        boolean setCurrentPanel(Object id) {
            PanelDescriptor nextPanel = (PanelDescriptor)this.panelHashmap.get(id);
            if (nextPanel == null) {
                throw new IllegalArgumentException();
            }
            PanelDescriptor oldPanel = this.currentPanel;
            this.currentPanel = nextPanel;
            return true;
        }

        boolean getBackButtonEnabled() {
            return this.currentPanel.getBackPanelDescriptor() != null;
        }

        boolean getNextButtonEnabled() {
            return this.currentPanel.getNextPanelDescriptor() != null;
        }
    }

    private static class Controller
    implements ActionListener {
        private WorkflowWizard wizard;

        public Controller(WorkflowWizard ww) {
            this.wizard = ww;
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals(WorkflowWizard.CANCEL_BUTTON_ACTION_COMMAND)) {
                this.cancelButtonPressed();
            } else if (evt.getActionCommand().equals(WorkflowWizard.BACK_BUTTON_ACTION_COMMAND)) {
                this.backButtonPressed();
            } else if (evt.getActionCommand().equals(WorkflowWizard.NEXT_BUTTON_ACTION_COMMAND)) {
                this.nextButtonPressed();
            }
        }

        private void cancelButtonPressed() {
            this.wizard.close(1);
        }

        private void nextButtonPressed() {
            Model model = this.wizard.getModel();
            PanelDescriptor descriptor = model.getCurrentPanelDescriptor();
            descriptor.nextButtonPressed();
            Object nextPanelDescriptor = descriptor.getNextPanelDescriptor();
            if (nextPanelDescriptor instanceof PanelDescriptor.FinishIdentifier) {
                this.wizard.close(0);
            } else {
                this.wizard.setCurrentPanel(nextPanelDescriptor);
            }
        }

        private void backButtonPressed() {
            Model model = this.wizard.getModel();
            PanelDescriptor descriptor = model.getCurrentPanelDescriptor();
            Object backPanelDescriptor = descriptor.getBackPanelDescriptor();
            this.wizard.setCurrentPanel(backPanelDescriptor);
        }
    }

    public static class PanelDescriptor {
        private static final String DEFAULT_PANEL_IDENTIFIER = "defaultPanelIdentifier";
        public static final FinishIdentifier FINISH = new FinishIdentifier();
        private WorkflowWizard wizard;
        private Component targetPanel;
        private Object panelIdentifier;

        public PanelDescriptor() {
            this.panelIdentifier = DEFAULT_PANEL_IDENTIFIER;
            this.targetPanel = new JPanel();
        }

        public PanelDescriptor(Object id) {
            this.panelIdentifier = id;
            this.targetPanel = new JPanel();
        }

        public PanelDescriptor(Object id, Component panel) {
            this.panelIdentifier = id;
            this.targetPanel = panel;
        }

        public void setPanelComponent(Component panel) {
            this.targetPanel = panel;
        }

        public final Component getPanelComponent() {
            return this.targetPanel;
        }

        public Object getNextPanelDescriptor() {
            return null;
        }

        public Object getBackPanelDescriptor() {
            return null;
        }

        public void setWizard(WorkflowWizard aThis) {
            this.wizard = aThis;
        }

        public final WorkflowWizard getWizard() {
            return this.wizard;
        }

        public void aboutToHidePanel() {
        }

        public void aboutToDisplayPanel() {
        }

        public void displayingPanel() {
        }

        public void nextButtonPressed() {
        }

        static class FinishIdentifier {
            public static final String ID = "FINISH";

            FinishIdentifier() {
            }
        }
    }
}

