/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytoscape.logger.CyLogger;
import cytospade.CytoSpade;
import cytospade.SpadeContext;
import cytospade.SpadeController;
import cytospade.WorkflowWizard;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class WorkflowWizardPanels {

    public static class GeneratePDFs
    extends WorkflowWizard.PanelDescriptor {
        public static final String IDENTIFIER = "GENERATE_PDFS_PANEL";
        private SpadeContext cxt;
        private SpadeController ctl = null;
        private JPanel contentPanel;
        private JButton jButton1;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JTextField jTextField1;

        public GeneratePDFs(SpadeContext cxt) {
            super(IDENTIFIER);
            this.cxt = cxt;
            this.setPanelComponent(this.createPanel());
        }

        public Object getNextPanelDescriptor() {
            return WorkflowWizard.PanelDescriptor.FINISH;
        }

        public void aboutToDisplayPanel() {
            this.getWizard().setTitle("Generate PDFs");
        }

        public void displayingPanel() {
        }

        public void aboutToHidePanel() {
            this.ctl = null;
        }

        public void nextButtonPressed() {
        }

        private JPanel createPanel() {
            this.contentPanel = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jButton1 = new JButton();
            this.jTextField1 = new JTextField();
            this.jLabel1.setText("Node Size Scale Factor");
            this.jLabel2.setText("Set parameters for PDF Generation");
            this.jButton1.setText("Generate PDFs");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GeneratePDFs.this.jButton1ActionPerformed(evt);
                }
            });
            this.jTextField1.setHorizontalAlignment(11);
            this.jTextField1.setText(Double.toString(this.cxt.getNodeSizeScaleFactor()));
            this.jTextField1.setToolTipText("Increase scaling factor to increase node size in PDFs");
            GroupLayout layout = new GroupLayout((Container)this.contentPanel);
            this.contentPanel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.jTextField1, -2, 100, -2)).add((Component)this.jLabel2)).addContainerGap(253, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(381, Short.MAX_VALUE).add((Component)this.jButton1).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.jLabel2).add(24, 24, 24).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jTextField1, -2, -1, -2)).addPreferredGap(0, 223, Short.MAX_VALUE).add((Component)this.jButton1).addContainerGap()));
            return this.contentPanel;
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            try {
                this.cxt.setNodeSizeScaleFactor(Double.parseDouble(this.jTextField1.getText()));
                this.cxt.authorPlotSpade("plotSPADE.R");
                this.ctl = new SpadeController(this.cxt.getPath(), "plotSPADE.R");
                this.ctl.exec();
            }
            catch (IOException ex) {
                CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
            }
        }
    }

    public static class SummaryAndRun
    extends WorkflowWizard.PanelDescriptor {
        public static final String IDENTIFIER = "SUMMARY_AND_RUN_PANEL";
        private SpadeContext cxt;
        private SpadeController ctl = null;
        private JPanel contentPanel;
        private JButton jButton1;
        private JButton jButton2;
        private JScrollPane jScrollPane1;
        private JTextArea jTextArea1;

        public SummaryAndRun(SpadeContext cxt) {
            super(IDENTIFIER);
            this.cxt = cxt;
            this.setPanelComponent(this.createPanel());
        }

        public Object getBackPanelDescriptor() {
            return "PANEL_CREATOR_PANEL";
        }

        public Object getNextPanelDescriptor() {
            return WorkflowWizard.PanelDescriptor.FINISH;
        }

        public void aboutToDisplayPanel() {
            this.getWizard().setTitle("Summary and Run");
        }

        public void displayingPanel() {
            this.jTextArea1.setText(this.cxt.getContextAsFormattedString());
        }

        public void aboutToHidePanel() {
            this.ctl = null;
        }

        public void nextButtonPressed() {
            try {
                if (this.ctl != null && (Integer)this.ctl.get() == 0) {
                    System.err.println(this.cxt.getPath().getAbsolutePath() + File.separator + "output");
                    this.cxt.setPath(new File(this.cxt.getPath().getAbsolutePath() + File.separator + "output"));
                }
            }
            catch (IllegalArgumentException ex) {
                CyLogger.getLogger((String)WorkflowWizardPanels.class.getName()).error(null, (Throwable)ex);
            }
            catch (InterruptedException ex) {
                CyLogger.getLogger((String)WorkflowWizardPanels.class.getName()).error(null, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                CyLogger.getLogger((String)WorkflowWizardPanels.class.getName()).error(null, (Throwable)ex);
            }
        }

        private JPanel createPanel() {
            this.contentPanel = new JPanel();
            this.jScrollPane1 = new JScrollPane();
            this.jTextArea1 = new JTextArea();
            this.jButton1 = new JButton();
            this.jButton2 = new JButton();
            this.jTextArea1.setColumns(20);
            this.jTextArea1.setRows(5);
            this.jScrollPane1.setViewportView(this.jTextArea1);
            this.jButton1.setText("Run SPADE");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SummaryAndRun.this.jButton1ActionPerformed(evt);
                }
            });
            this.jButton1.setToolTipText("Run SPADE R package (generating new runSPADE script beforehand)");
            this.jButton2.setText("Generate runSPADE Script");
            this.jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SummaryAndRun.this.jButton2ActionPerformed(evt);
                }
            });
            this.jButton2.setToolTipText("Generate runSPADE script, but do not actually run SPADE");
            GroupLayout layout = new GroupLayout((Container)this.contentPanel);
            this.contentPanel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton2).addPreferredGap(0).add((Component)this.jButton1)).add((Component)this.jScrollPane1, -1, 568, Short.MAX_VALUE)).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 332, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton1).add((Component)this.jButton2)).addContainerGap(18, Short.MAX_VALUE)));
            return this.contentPanel;
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            try {
                this.cxt.authorRunSpade("runSPADE.R");
                this.ctl = new SpadeController(this.cxt.getPath(), "runSPADE.R");
                this.ctl.exec();
            }
            catch (IOException ex) {
                CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
            }
        }

        private void jButton2ActionPerformed(ActionEvent evt) {
            try {
                this.cxt.authorRunSpade("runSPADE.R");
                JOptionPane.showMessageDialog(null, "runSPADE.R script file successfully written");
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error writing runSPADE.R file: " + ex.getMessage());
            }
        }
    }

    public static class PanelCreator
    extends WorkflowWizard.PanelDescriptor {
        public static final String IDENTIFIER = "PANEL_CREATOR_PANEL";
        private SpadeContext cxt;
        private JPanel contentPanel;
        private JButton jButton1;
        private JButton jButton2;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JLabel jLabel5;
        private JList jList2;
        private JList jList3;
        private JList jList4;
        private JList jList5;
        private JList jList6;
        private JScrollPane jScrollPane2;
        private JScrollPane jScrollPane3;
        private JScrollPane jScrollPane4;
        private JScrollPane jScrollPane5;
        private JScrollPane jScrollPane6;
        private JScrollPane jScrollPane7;
        private JTextArea jTextArea1;
        private JTextField jTextField1;

        public PanelCreator(SpadeContext cxt) {
            super(IDENTIFIER);
            this.cxt = cxt;
            this.setPanelComponent(this.createPanel());
        }

        public Object getBackPanelDescriptor() {
            return "CLUSTER_MARKER_SELECT_PANEL";
        }

        public Object getNextPanelDescriptor() {
            return "SUMMARY_AND_RUN_PANEL";
        }

        public void aboutToDisplayPanel() {
            this.getWizard().setTitle("Create Median and Fold Change Calculation Panels");
            this.jList6.setListData(this.cxt.getAnalysisPanelsNames());
            ListCellRenderer fileRenderer = new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jlist, Object o, int idx, boolean isSelected, boolean bln1) {
                    JLabel label = new JLabel(((File)o).getName());
                    label.setBackground(isSelected ? jlist.getSelectionBackground() : jlist.getBackground());
                    label.setForeground(isSelected ? jlist.getSelectionForeground() : jlist.getForeground());
                    label.setEnabled(jlist.isEnabled());
                    label.setFont(jlist.getFont());
                    label.setOpaque(true);
                    return label;
                }
            };
            this.jList3.setModel(new AbstractListModel(){
                File[] files;
                {
                    this.files = PanelCreator.this.cxt.getFCSFilesNotInPanel();
                }

                public int getSize() {
                    return this.files.length;
                }

                public Object getElementAt(int i) {
                    return this.files[i];
                }
            });
            this.jList3.setCellRenderer(fileRenderer);
            this.jList2.setCellRenderer(fileRenderer);
        }

        public void nextButtonPressed() {
            this.cxt.addAnalysisPanel("catchall", new SpadeContext.AnalysisPanel(this.cxt.getFCSFilesNotInPanel()));
        }

        private JPanel createPanel() {
            this.contentPanel = new JPanel();
            this.jScrollPane5 = new JScrollPane();
            this.jTextArea1 = new JTextArea();
            this.jScrollPane6 = new JScrollPane();
            this.jList5 = new JList();
            this.jScrollPane2 = new JScrollPane();
            this.jList2 = new JList();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jScrollPane3 = new JScrollPane();
            this.jList3 = new JList();
            this.jScrollPane4 = new JScrollPane();
            this.jList4 = new JList();
            this.jScrollPane7 = new JScrollPane();
            this.jList6 = new JList();
            this.jLabel5 = new JLabel();
            this.jTextField1 = new JTextField();
            this.jButton1 = new JButton();
            this.jLabel1 = new JLabel();
            this.jButton2 = new JButton();
            this.jTextArea1.setColumns(20);
            this.jTextArea1.setRows(5);
            this.jScrollPane5.setViewportView(this.jTextArea1);
            this.jList5.setModel(new AbstractListModel(){
                String[] strings = new String[0];

                public int getSize() {
                    return this.strings.length;
                }

                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            this.jScrollPane6.setViewportView(this.jList5);
            this.jLabel2.setText("1. Files in Panel");
            this.jScrollPane3.setViewportView(this.jList3);
            this.jList3.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    PanelCreator.this.jList3ValueChanged(evt);
                }
            });
            this.jList3.setToolTipText("Select files with common staining panel for computing medians and optionally fold change");
            this.jLabel3.setText("2. Reference Files (Optional)");
            this.jScrollPane2.setViewportView(this.jList2);
            this.jList2.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    PanelCreator.this.jList2ValueChanged(evt);
                }
            });
            this.jList2.setToolTipText("Select reference (basal) files for use in fold change analysis. Panel must have multiple files to enable fold change analysis.");
            this.jLabel4.setText("3. Fold-change Markers");
            this.jScrollPane4.setViewportView(this.jList4);
            this.jList4.setToolTipText("Select markers for fold changes analysis. Reference files must be specified to select fold change parameters");
            this.jLabel1.setText("Panels");
            this.jList6.setSelectionMode(0);
            this.jScrollPane7.setViewportView(this.jList6);
            this.jLabel5.setText("4. Save Panel as:");
            this.jTextField1.setText("");
            this.jButton1.setText("Save");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PanelCreator.this.jButton1ActionPerformed(evt);
                }
            });
            this.jButton2.setText("Delete");
            this.jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PanelCreator.this.jButton2ActionPerformed(evt);
                }
            });
            GroupLayout layout = new GroupLayout((Container)this.contentPanel);
            this.contentPanel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jScrollPane3, -2, 225, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -2, 225, -2).add((Component)this.jLabel3)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane4, -2, 225, -2).add((Component)this.jLabel4)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane7, -2, 225, -2).add((Component)this.jLabel5).add((Component)this.jTextField1, -2, 225, -2).add((Component)this.jLabel1).add((Component)this.jButton1).add((Component)this.jButton2)).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextField1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButton1).add(35, 35, 35).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane7, -2, 265, -2).add(18, 18, 18).add((Component)this.jButton2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 435, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 435, Short.MAX_VALUE).add((Component)this.jScrollPane4, -1, 435, Short.MAX_VALUE)))).addContainerGap()));
            return this.contentPanel;
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            if (this.jTextField1.getText() == null || this.jTextField1.getText().equals("")) {
                JOptionPane.showMessageDialog(this.contentPanel, "Please enter a name for the panel.");
                return;
            }
            if (this.cxt.getAnalysisPanel(this.jTextField1.getText()) != null) {
                JOptionPane.showMessageDialog(this.contentPanel, "Panel with that name already exists. Please use a different name.");
                return;
            }
            this.cxt.addAnalysisPanel(this.jTextField1.getText(), new SpadeContext.AnalysisPanel(this.jList3.getSelectedValues(), null, this.jList2.getSelectedValues(), this.jList4.getSelectedValues()));
            this.jList6.setListData(this.cxt.getAnalysisPanelsNames());
            this.jList3.setModel(new AbstractListModel(){
                File[] files;
                {
                    this.files = PanelCreator.this.cxt.getFCSFilesNotInPanel();
                }

                public int getSize() {
                    return this.files.length;
                }

                public Object getElementAt(int i) {
                    return this.files[i];
                }
            });
        }

        private void jButton2ActionPerformed(ActionEvent evt) {
            if (this.jList6.getSelectedIndex() >= 0) {
                this.cxt.removeAnalysisPanel((String)this.jList6.getSelectedValue());
                this.jList3.setModel(new AbstractListModel(){
                    File[] files;
                    {
                        this.files = PanelCreator.this.cxt.getFCSFilesNotInPanel();
                    }

                    public int getSize() {
                        return this.files.length;
                    }

                    public Object getElementAt(int i) {
                        return this.files[i];
                    }
                });
                this.jList6.setListData(this.cxt.getAnalysisPanelsNames());
            }
        }

        private void jList3ValueChanged(ListSelectionEvent evt) {
            final Object[] selected = this.jList3.getSelectedValues();
            if (selected.length > 1) {
                this.jList2.setModel(new AbstractListModel(){
                    Object[] objs;
                    {
                        this.objs = selected;
                    }

                    public int getSize() {
                        return this.objs.length;
                    }

                    public Object getElementAt(int i) {
                        return this.objs[i];
                    }
                });
                this.jList2.setEnabled(true);
                this.jList4.setModel(new AbstractListModel(){
                    String[] strings;
                    {
                        this.strings = SpadeContext.getCommonMarkers(selected);
                    }

                    public int getSize() {
                        return this.strings.length;
                    }

                    public Object getElementAt(int i) {
                        return this.strings[i];
                    }
                });
                this.jList4.setEnabled(!this.jList2.isSelectionEmpty());
            } else {
                this.jList2.setListData(new Object[0]);
                this.jList2.setEnabled(false);
                this.jList4.setListData(new Object[0]);
                this.jList4.setEnabled(false);
            }
        }

        private void jList2ValueChanged(ListSelectionEvent evt) {
            this.jList4.setEnabled(!this.jList2.isSelectionEmpty());
        }
    }

    public static class ClusterMarkerSelect
    extends WorkflowWizard.PanelDescriptor {
        public static final String IDENTIFIER = "CLUSTER_MARKER_SELECT_PANEL";
        private SpadeContext cxt;
        private JPanel contentPanel;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JList jList1;
        private JScrollPane jScrollPane1;
        private JSpinner jSpinner1;
        private JSpinner jSpinner2;
        private JSpinner jSpinner3;
        private JSpinner jSpinner4;
        private ButtonGroup buttonGroup1;
        private JRadioButton jRadioButton1;
        private JRadioButton jRadioButton2;

        public ClusterMarkerSelect(SpadeContext cxt) {
            super(IDENTIFIER);
            this.cxt = cxt;
            this.setPanelComponent(this.createPanel());
        }

        public Object getBackPanelDescriptor() {
            return "INTRODUCTION_PANEL";
        }

        public Object getNextPanelDescriptor() {
            return "PANEL_CREATOR_PANEL";
        }

        public void aboutToDisplayPanel() {
            this.getWizard().setTitle("Set Clustering Parameters");
            this.jList1.setModel(new AbstractListModel(){
                String[] strings;
                {
                    this.strings = ClusterMarkerSelect.this.cxt.getPotentialClusteringMarkers();
                }

                public int getSize() {
                    return this.strings.length;
                }

                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            String[] markers = this.cxt.getSelectedClusteringMarkers();
            List<String> possible_markers = Arrays.asList(this.cxt.getPotentialClusteringMarkers());
            int[] idxs = new int[markers.length];
            for (int i = 0; i < markers.length; ++i) {
                idxs[i] = possible_markers.indexOf(markers[i]);
            }
            this.jList1.setSelectedIndices(idxs);
        }

        public void displayingPanel() {
            this.getWizard().setNextButtonEnabled(this.jList1.getSelectedIndex() != -1);
        }

        public void aboutToHidePanel() {
            Object[] selected = this.jList1.getSelectedValues();
            String[] markers = new String[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                markers[i] = selected[i].toString();
            }
            this.cxt.setSelectedClusteringMarkers(markers);
            this.cxt.setArcsinh((Integer)this.jSpinner1.getValue());
            this.cxt.setTargetClusters((Integer)this.jSpinner2.getValue());
            if (this.jRadioButton1.isSelected()) {
                this.cxt.setDownsampleKind(SpadeContext.DownsampleKind.EVENTS);
            } else if (this.jRadioButton2.isSelected()) {
                this.cxt.setDownsampleKind(SpadeContext.DownsampleKind.PERCENTILE);
            } else {
                this.cxt.setDownsampleKind(SpadeContext.DownsampleKind.EVENTS);
            }
            this.cxt.setTargetDownsampleEvents((Integer)this.jSpinner3.getValue());
            this.cxt.setTargetDownsamplePctile((Integer)this.jSpinner4.getValue());
        }

        private JPanel createPanel() {
            this.contentPanel = new JPanel();
            this.jScrollPane1 = new JScrollPane();
            this.jList1 = new JList();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jSpinner1 = new JSpinner();
            this.jLabel3 = new JLabel();
            this.jSpinner2 = new JSpinner();
            this.jLabel4 = new JLabel();
            this.jSpinner3 = new JSpinner();
            this.jSpinner4 = new JSpinner();
            this.buttonGroup1 = new ButtonGroup();
            this.jRadioButton1 = new JRadioButton();
            this.jRadioButton2 = new JRadioButton();
            this.jList1.setModel(new AbstractListModel(){
                String[] strings = new String[0];

                public int getSize() {
                    return this.strings.length;
                }

                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            this.jList1.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    ClusterMarkerSelect.this.jList1ValueChanged(evt);
                }
            });
            this.jList1.setToolTipText("Select markers are used to calculate 'distance' between cells from those common to all files");
            this.jScrollPane1.setViewportView(this.jList1);
            this.jLabel1.setText("Select Clustering Markers");
            this.jLabel2.setText("Arcsinh Cofactor (CyToF=5, Optical=150)");
            this.jSpinner1.setModel(new SpinnerNumberModel((Number)this.cxt.getArcsinh(), Integer.valueOf(0), null, (Number)1));
            this.jSpinner1.setToolTipText("Set cofactor used in Arcsinh transformation: arcsinh(data/<COFACTOR>)");
            this.jLabel3.setText("Target Number of Clusters");
            this.jSpinner2.setModel(new SpinnerNumberModel((Number)this.cxt.getTargetClusters(), Integer.valueOf(0), null, (Number)1));
            this.jSpinner2.setToolTipText("SPADE will automatically stop clustering when number of clusters is within 50% of this target");
            this.jLabel4.setText("Downsample to Percentile or Target Number of Events");
            this.jRadioButton1.setText("Events");
            this.jRadioButton1.setSelected(true);
            this.buttonGroup1.add(this.jRadioButton1);
            this.jRadioButton2.setText("Percentile");
            this.buttonGroup1.add(this.jRadioButton2);
            this.jSpinner3.setModel(new SpinnerNumberModel((Number)this.cxt.getTargetDownsampleEvents(), Integer.valueOf(0), null, (Number)100));
            this.jSpinner3.setToolTipText("Each input file will be downsampled to retain the smaller of this number of events, or total events in file");
            this.jSpinner4.setModel(new SpinnerNumberModel((Number)this.cxt.getTargetDownsamplePctile(), Integer.valueOf(0), Integer.valueOf(100), (Number)1));
            this.jSpinner4.setToolTipText("Each input file will be downsampled to retain events with density below this percentile");
            GroupLayout layout = new GroupLayout((Container)this.contentPanel);
            this.contentPanel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(4).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(36, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 225, -2).add((Component)this.jLabel1)).add(40, 40, 40).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jSpinner1, -2, 108, -2).add((Component)this.jLabel3).add((Component)this.jSpinner2, -2, 108, -2).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButton1, -2, 108, -2).add((Component)this.jSpinner3, -2, 108, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButton2, -2, 108, -2).add((Component)this.jSpinner4, -2, 108, -2))).addContainerGap(36, Short.MAX_VALUE)));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2, -2, 16, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(1).add((Component)this.jScrollPane1, -1, 211, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jSpinner1, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel3, -2, 16, -2).addPreferredGap(0).add((Component)this.jSpinner2, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel4, -2, 16, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButton1).add((Component)this.jSpinner3, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButton2).add((Component)this.jSpinner4, -2, -1, -2)))).addContainerGap()));
            return this.contentPanel;
        }

        private void jList1ValueChanged(ListSelectionEvent evt) {
            this.getWizard().setNextButtonEnabled(this.jList1.getSelectedIndex() != -1);
        }
    }

    public static class Intro
    extends WorkflowWizard.PanelDescriptor {
        public static final String IDENTIFIER = "INTRODUCTION_PANEL";
        private SpadeContext cxt;
        private Object nextID;
        private JPanel contentPanel;
        private JButton jButton1;
        private JTextField jTextField1;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JScrollPane jScrollPane1;
        private JTextArea jTextArea1;

        public Intro(SpadeContext cxt) {
            super(IDENTIFIER);
            this.cxt = cxt;
            this.nextID = null;
            this.setPanelComponent(this.createPanel());
        }

        public Object getNextPanelDescriptor() {
            return this.nextID;
        }

        public void aboutToDisplayPanel() {
            this.getWizard().setTitle("Select Working Directory");
            this.getWizard().setNextButtonEnabled(false);
        }

        public void displayingPanel() {
            this.getWizard().setNextButtonEnabled(this.cxt.getPath() != null && this.cxt.getWorkflowKind() != null);
        }

        private JPanel createPanel() {
            this.contentPanel = new JPanel();
            this.jScrollPane1 = new JScrollPane();
            this.jTextArea1 = new JTextArea();
            this.jLabel1 = new JLabel();
            this.jTextField1 = new JTextField();
            this.jLabel2 = new JLabel();
            this.jButton1 = new JButton();
            this.jTextArea1.setColumns(20);
            this.jTextArea1.setLineWrap(true);
            this.jTextArea1.setWrapStyleWord(true);
            this.jTextArea1.setEditable(false);
            this.jTextArea1.setRows(5);
            this.jTextArea1.setText("The SPADE Cytoscape plugin has two modes:\n1) Processing FCS files to create SPADE trees\n2) Analysis of SPADE trees\nTo setup up processing, select the directory containing the FCS files of interest. To begin analysis, select previously generated SPADE output directory.");
            this.jScrollPane1.setViewportView(this.jTextArea1);
            this.jLabel1.setHorizontalAlignment(0);
            this.jLabel1.setText("Welcome to SPADE");
            this.jTextField1.setText("");
            this.jTextField1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Intro.this.jTextField1ActionPerformed(evt);
                }
            });
            this.jLabel2.setText("Directory");
            this.jButton1.setText("Browse");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Intro.this.jButton1ActionPerformed(evt);
                }
            });
            GroupLayout layout = new GroupLayout((Container)this.contentPanel);
            this.contentPanel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.jScrollPane1, -2, 445, -2).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(30, Short.MAX_VALUE).add((Component)this.jLabel2).add(16, 16, 16).add((Component)this.jTextField1, -2, 272, -2).add(16, 16, 16).add((Component)this.jButton1).addContainerGap(30, Short.MAX_VALUE)));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(30, 30, 30).add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.jScrollPane1, -2, 146, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.jTextField1, -2, -1, -2).add((Component)this.jButton1).add((Component)this.jLabel2)).addContainerGap(30, Short.MAX_VALUE)));
            return this.contentPanel;
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            int returnValue = jFileChooser.showOpenDialog(jFileChooser);
            if (returnValue == 0) {
                try {
                    this.cxt.setPath(jFileChooser.getSelectedFile());
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(null, "Invalid directory: " + ex.getMessage());
                    return;
                }
                this.jTextField1.setText(this.cxt.getPath().getPath());
                SpadeContext.WorkflowKind wk = this.cxt.getWorkflowKind();
                if (wk == SpadeContext.WorkflowKind.ANALYSIS) {
                    this.getWizard().close(0);
                }
            } else {
                if (returnValue == 1) {
                    return;
                }
                JOptionPane.showMessageDialog(null, "File selection error");
                return;
            }
            this.updateNextPanel();
        }

        private void jTextField1ActionPerformed(ActionEvent evt) {
            try {
                this.cxt.setPath(new File(this.jTextField1.getText()));
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(null, "Invalid directory: " + ex.getMessage());
            }
            this.updateNextPanel();
        }

        private void updateNextPanel() {
            SpadeContext.WorkflowKind wk = this.cxt.getWorkflowKind();
            if (wk == SpadeContext.WorkflowKind.ANALYSIS) {
                this.nextID = FINISH;
                this.getWizard().setNextButtonEnabled(true);
            } else if (wk == SpadeContext.WorkflowKind.PROCESSING) {
                this.nextID = "CLUSTER_MARKER_SELECT_PANEL";
                this.getWizard().setNextButtonEnabled(true);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
}

