/*
 * Decompiled with CFR 0.152.
 */
package cytospade.ui;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.actions.LoadNetworkTask;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytospade.CytoSpade;
import cytospade.FCSOperations;
import cytospade.MergeOrderOperations;
import cytospade.SpadeContext;
import cytospade.SpadeController;
import cytospade.VisualMapping;
import cytospade.WorkflowWizard;
import cytospade.WorkflowWizardPanels;
import cytospade.ui.NodeContextMenu;
import cytospade.ui.NodeContextMenuItems;
import cytospade.ui.ScatterPlotPanel;
import ding.view.NodeContextMenuListener;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class SpadeAnalysisPanel
extends JPanel {
    private SpadeContext spadeCxt;
    private VisualMapping visualMapping;
    private FCSOperations fcsOperations;
    private ScatterPlotPanel scatterPlot;
    private ReentrantLock panelLock;
    private MergeOrderOperations mergeOrderOps;
    DefaultTableModel TValTableModel = new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Parameter", "T value"});
    private JButton CloseButton;
    private JComboBox ColoringSelect1;
    private JLabel FilenameLabel1;
    private JComboBox FilenameSelect1;
    private JLabel NumberEventsLabel;
    private JButton PDFButton;
    private JTable PValTable;
    private JScrollPane PValTableContainer;
    private JScrollPane PlotContainer;
    private JComboBox RangeSelect1;
    private JButton TableButton;
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckShowNestedIcon;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton mergeOrderDetails;
    private JSlider mergeOrderSlider;
    private JRadioButton radioAsymmetric1;
    private JRadioButton radioSymmetric1;

    public SpadeAnalysisPanel(SpadeContext spadeCxt) {
        this.spadeCxt = spadeCxt;
        File[] boundaryFiles = spadeCxt.getPath().listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return name.matches("global_boundaries.table");
            }
        });
        if (boundaryFiles.length == 1) {
            this.visualMapping = new VisualMapping(boundaryFiles[0]);
        } else if (boundaryFiles.length == 0) {
            this.visualMapping = new VisualMapping();
        } else {
            JOptionPane.showMessageDialog(null, "Error: Found more than one global_boundaries.table file.");
            return;
        }
        this.panelLock = new ReentrantLock();
        this.initComponents();
    }

    private DefaultComboBoxModel RangeSelectModel() {
        SpadeContext.NormalizationKind[] normalizationKindArray;
        if (this.visualMapping.globalRangeAvailable()) {
            SpadeContext.NormalizationKind[] normalizationKindArray2 = new SpadeContext.NormalizationKind[2];
            normalizationKindArray2[0] = SpadeContext.NormalizationKind.GLOBAL;
            normalizationKindArray = normalizationKindArray2;
            normalizationKindArray2[1] = SpadeContext.NormalizationKind.LOCAL;
        } else {
            SpadeContext.NormalizationKind[] normalizationKindArray3 = new SpadeContext.NormalizationKind[1];
            normalizationKindArray = normalizationKindArray3;
            normalizationKindArray3[0] = SpadeContext.NormalizationKind.LOCAL;
        }
        return new DefaultComboBoxModel<SpadeContext.NormalizationKind>(normalizationKindArray);
    }

    public void onExit() {
    }

    private void updateFCSConsumers() {
        new SwingWorker<Integer, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer doInBackground() throws Exception {
                SpadeAnalysisPanel.this.fcsOperations.updateSelectedNodes();
                SpadeAnalysisPanel.this.scatterPlot.updatePlot();
                if (SpadeAnalysisPanel.this.fcsOperations.getSelectedNodesCount() == 0) {
                    SpadeAnalysisPanel.this.panelLock.lock();
                    try {
                        SpadeAnalysisPanel.this.NumberEventsLabel.setText("Displaying all " + SpadeAnalysisPanel.this.fcsOperations.getEventCount() + " events.");
                        SpadeAnalysisPanel.this.TValTableModel.setRowCount(0);
                        SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{"Select nodes...", ""});
                    }
                    finally {
                        SpadeAnalysisPanel.this.panelLock.unlock();
                    }
                }
                if (SpadeAnalysisPanel.this.fcsOperations.getSelectedEventCount() >= 2) {
                    List<FCSOperations.AttributeValuePair> stats = SpadeAnalysisPanel.this.fcsOperations.computeTStat();
                    SpadeAnalysisPanel.this.TValTableModel.setRowCount(0);
                    for (int i = 0; i < stats.size(); ++i) {
                        SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{stats.get((int)i).attribute, (double)Math.round(stats.get((int)i).value * 10.0) / 10.0});
                    }
                } else {
                    SpadeAnalysisPanel.this.TValTableModel.addRow(new Object[]{"Too few events.", ""});
                }
                SpadeAnalysisPanel.this.panelLock.lock();
                try {
                    SpadeAnalysisPanel.this.NumberEventsLabel.setText("Displaying " + SpadeAnalysisPanel.this.fcsOperations.getSelectedEventCount() + " of " + SpadeAnalysisPanel.this.fcsOperations.getEventCount() + " events.");
                }
                finally {
                    SpadeAnalysisPanel.this.panelLock.unlock();
                }
                return 0;
            }
        }.execute();
    }

    private void updateNodeSizeAndColors() {
        if (this.FilenameSelect1.getSelectedIndex() < 0 || this.ColoringSelect1.getSelectedIndex() < 0) {
            return;
        }
        try {
            this.visualMapping.setCurrentMarkersAndRangeKind("percenttotal", this.ColoringSelect1.getSelectedItem().toString(), this.spadeCxt.getNormalizationKind(), this.spadeCxt.getSymmetry());
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, "Invalid choice of mapping parameters: " + e);
            return;
        }
        VisualMappingManager cyVMM = Cytoscape.getVisualMappingManager();
        try {
            VisualStyle spadeVS = cyVMM.getCalculatorCatalog().getVisualStyle("SPADEVisualStyle");
            if (spadeVS != null) {
                cyVMM.getCalculatorCatalog().removeVisualStyle("SPADEVisualStyle");
            }
            spadeVS = new VisualStyle("SPADEVisualStyle");
            GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator();
            globalAppCalc.setDefaultNodeSelectionColor(Color.MAGENTA);
            globalAppCalc.setDefaultEdgeSelectionColor(Color.MAGENTA);
            globalAppCalc.setDefaultBackgroundColor(Color.BLACK);
            spadeVS.setGlobalAppearanceCalculator(globalAppCalc);
            NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator(spadeVS.getDependency());
            nodeAppCalc.setCalculator(this.visualMapping.createColorCalculator());
            nodeAppCalc.setCalculator(this.visualMapping.createSizeCalculator());
            spadeVS.setNodeAppearanceCalculator(nodeAppCalc);
            VisualPropertyType.NODE_SHAPE.setDefault(spadeVS, (Object)NodeShape.ELLIPSE);
            VisualPropertyType.NODE_FILL_COLOR.setDefault(spadeVS, (Object)Color.LIGHT_GRAY);
            spadeVS.getDependency().set(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED, true);
            VisualPropertyType.NODE_BORDER_COLOR.setDefault(spadeVS, (Object)Color.WHITE);
            VisualPropertyType.NODE_LINE_WIDTH.setDefault(spadeVS, (Object)4);
            VisualPropertyType.EDGE_COLOR.setDefault(spadeVS, (Object)Color.WHITE);
            VisualPropertyType.EDGE_LINE_WIDTH.setDefault(spadeVS, (Object)2);
            cyVMM.getCalculatorCatalog().addVisualStyle(spadeVS);
            cyVMM.setVisualStyle(spadeVS);
            Cytoscape.getCurrentNetworkView().setVisualStyle(spadeVS.getName());
        }
        catch (RuntimeException ex) {
            CyLogger.getLogger().error("Error Visual Mapping", (Throwable)ex);
        }
    }

    private void saveMetadata(Boolean closeNetwork) {
        int id;
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        CyNetworkView currentNetworkView = Cytoscape.getCurrentNetworkView();
        try {
            FileWriter nstream = new FileWriter(new File(this.spadeCxt.getPath(), "nested.txt").getAbsolutePath());
            BufferedWriter nout = new BufferedWriter(nstream);
            for (CyNode node : currentNetwork.nodesList()) {
                GraphPerspective nestedNetwork = node.getNestedNetwork();
                if (nestedNetwork == null) continue;
                for (CyNode nn : nestedNetwork.nodesList()) {
                    if (!NodeContextMenuItems.MakeNestedNetwork.isNested(nn)) continue;
                    id = Integer.parseInt(nn.getIdentifier());
                    nout.write(id + 1 + " ");
                }
                nout.write("\n");
                NodeContextMenuItems.UndoNestedNetwork.undoNestedNode(node);
            }
            nout.close();
        }
        catch (IOException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        try {
            FileWriter lstream = new FileWriter(new File(this.spadeCxt.getPath(), "layout.table").getAbsolutePath());
            BufferedWriter lout = new BufferedWriter(lstream);
            int nodeCount = currentNetwork.getNodeCount();
            double[][] pos = new double[nodeCount][2];
            for (CyNode node : currentNetwork.nodesList()) {
                NodeView nodeView = currentNetworkView.getNodeView((Node)node);
                try {
                    id = Integer.parseInt(node.getIdentifier());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (id > nodeCount || nodeView == null) continue;
                pos[id][0] = nodeView.getXPosition();
                pos[id][1] = -1.0 * nodeView.getYPosition();
            }
            for (int i = 0; i < nodeCount; ++i) {
                lout.write(pos[i][0] + " " + pos[i][1] + "\n");
            }
            lout.close();
        }
        catch (IOException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        if (closeNetwork.booleanValue()) {
            Cytoscape.destroyNetwork((CyNetwork)currentNetwork);
            Cytoscape.createNewSession();
        }
    }

    private void loadMetadata(File layoutFile) {
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        CyNetworkView currentNetworkView = Cytoscape.getCurrentNetworkView();
        try {
            int nodeCount = currentNetwork.getNodeCount();
            double[][] pos = new double[currentNetwork.getNodeCount()][2];
            Scanner scanner = new Scanner(layoutFile);
            for (int curNode = 0; scanner.hasNextLine() && curNode < nodeCount; ++curNode) {
                pos[curNode][0] = scanner.nextDouble();
                pos[curNode][1] = -1.0 * scanner.nextDouble();
            }
            for (CyNode node : currentNetwork.nodesList()) {
                int id;
                try {
                    id = Integer.parseInt(node.getIdentifier());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (id > nodeCount) continue;
                NodeView nodeView = currentNetworkView.getNodeView((Node)node);
                nodeView.setXPosition(pos[id][0]);
                nodeView.setYPosition(pos[id][1]);
            }
        }
        catch (FileNotFoundException ex) {
            CyLogger.getLogger().error("Error read layout.table", (Throwable)ex);
            return;
        }
        try {
            Scanner scanner = new Scanner(new File(this.spadeCxt.getPath(), "nested.txt"));
            while (scanner.hasNextLine()) {
                HashSet<CyNode> nodes = new HashSet<CyNode>();
                for (String id : scanner.nextLine().split(" ")) {
                    try {
                        nodes.add(Cytoscape.getCyNode((String)Integer.toString(Integer.parseInt(id) - 1)));
                    }
                    catch (NumberFormatException ex) {
                        CyLogger.getLogger().error("Invalid entry in nested.txt", (Throwable)ex);
                    }
                }
                NodeContextMenuItems.MakeNestedNetwork.makeNestedNode(nodes);
            }
        }
        catch (FileNotFoundException ex) {
            CyLogger.getLogger().debug("Error reading nested.txt", (Throwable)ex);
            return;
        }
    }

    private String getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return "windows";
        }
        if (os.indexOf("mac") >= 0) {
            return "macintosh";
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return "unix";
        }
        JOptionPane.showMessageDialog(null, "Invalid OS detection");
        return "error";
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        FileItem[] files = new FileItem[this.spadeCxt.getFCSFiles().length];
        int i = 0;
        for (File fi : this.spadeCxt.getFCSFiles()) {
            files[i] = new FileItem(fi);
            ++i;
        }
        this.FilenameSelect1 = new JComboBox<FileItem>(files);
        this.FilenameLabel1 = new JLabel();
        this.ColoringSelect1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.RangeSelect1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.PDFButton = new JButton();
        this.TableButton = new JButton();
        this.CloseButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.NumberEventsLabel = new JLabel();
        this.PlotContainer = new JScrollPane();
        this.PValTableContainer = new JScrollPane();
        this.PValTable = new JTable();
        this.radioSymmetric1 = new JRadioButton();
        this.radioAsymmetric1 = new JRadioButton();
        this.mergeOrderSlider = new JSlider();
        this.jLabel5 = new JLabel();
        this.mergeOrderDetails = new JButton();
        this.jCheckShowNestedIcon = new JCheckBox();
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setPreferredSize(new Dimension(429, 754));
        this.jPanel1.setPreferredSize(new Dimension(396, 780));
        this.FilenameSelect1.setMaximumRowCount(20);
        this.FilenameSelect1.setSelectedIndex(-1);
        this.FilenameSelect1.setMinimumSize(null);
        this.FilenameSelect1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.FilenameSelect1ActionPerformed(evt);
            }
        });
        this.FilenameLabel1.setText("File");
        this.ColoringSelect1.setMaximumRowCount(20);
        this.ColoringSelect1.setToolTipText("Select attribute for coloring nodes");
        this.ColoringSelect1.setMinimumSize(null);
        this.ColoringSelect1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.ColoringSelect1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Coloring Attribute");
        this.RangeSelect1.setMaximumRowCount(20);
        this.RangeSelect1.setModel(this.RangeSelectModel());
        this.RangeSelect1.setToolTipText("Global sets colorscale using min/max across all files, local uses min/max of selected file");
        this.RangeSelect1.setMinimumSize(null);
        this.RangeSelect1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.RangeSelect1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Coloring Range");
        this.PDFButton.setText("Produce PDFs");
        this.PDFButton.setToolTipText("Generate PDF tree plots using current Cytoscape layout");
        this.PDFButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.PDFButtonActionPerformed(evt);
            }
        });
        this.TableButton.setText("Produce Tables");
        this.TableButton.setToolTipText("Generate CSV tables for each attributes with columns for all files");
        this.TableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.TableButtonActionPerformed(evt);
            }
        });
        this.CloseButton.setText("Close SPADE");
        this.CloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.CloseButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setForeground(new Color(0, 0, 0));
        this.jSeparator2.setForeground(new Color(0, 0, 0));
        this.NumberEventsLabel.setText("Select a file to display network and bi-axial plot");
        this.PlotContainer.setMaximumSize(new Dimension(Short.MAX_VALUE, 400));
        this.PlotContainer.setMinimumSize(new Dimension(370, 430));
        this.PValTableContainer.setPreferredSize(new Dimension(365, 402));
        this.PValTable.setAutoCreateRowSorter(true);
        this.PValTable.setModel(this.TValTableModel);
        this.PValTable.setCellSelectionEnabled(true);
        this.PValTableContainer.setViewportView(this.PValTable);
        this.buttonGroup1.add(this.radioSymmetric1);
        this.radioSymmetric1.setText("Symmetric");
        this.radioSymmetric1.setToolTipText("Center coloring range about 0");
        this.radioSymmetric1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.radioSymmetric1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioAsymmetric1);
        this.radioAsymmetric1.setSelected(true);
        this.radioAsymmetric1.setText("Asymmetric");
        this.radioAsymmetric1.setToolTipText("Center coloring range about mean of attribute range");
        this.radioAsymmetric1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.radioAsymmetric1ActionPerformed(evt);
            }
        });
        this.mergeOrderSlider.setMajorTickSpacing(20);
        this.mergeOrderSlider.setPaintTicks(true);
        this.mergeOrderSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpadeAnalysisPanel.this.mergeOrderSliderStateChanged(evt);
            }
        });
        this.jLabel5.setText("Merge Order");
        this.jLabel5.setCursor(new Cursor(0));
        this.jLabel5.setName("mergeOrderLabel");
        this.mergeOrderDetails.setLabel("See Merge Details");
        this.mergeOrderDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeAnalysisPanel.this.mergeOrderDetailsActionPerformed(evt);
            }
        });
        this.jCheckShowNestedIcon.setText("Show Merging Details Dynamically [slow]");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.NumberEventsLabel, -1, -1, Short.MAX_VALUE).addGap(24, 24, 24)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSeparator2, -2, 344, -2)).addComponent(this.PValTableContainer, -1, 370, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColoringSelect1, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.FilenameLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FilenameSelect1, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(16, 16, 16).addComponent(this.RangeSelect1, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioSymmetric1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioAsymmetric1)).addComponent(this.PlotContainer, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addComponent(this.jSeparator1, -2, -1, -2)).addContainerGap(25, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mergeOrderSlider, -2, 270, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckShowNestedIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mergeOrderDetails, -2, 149, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.TableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PDFButton, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CloseButton, -2, 105, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.FilenameLabel1).addComponent(this.FilenameSelect1, -2, -1, -2)).addGap(3, 3, 3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.ColoringSelect1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RangeSelect1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.radioAsymmetric1).addComponent(this.radioSymmetric1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 2, -2).addGap(8, 8, 8).addComponent(this.NumberEventsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PlotContainer, -2, 418, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PValTableContainer, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mergeOrderSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckShowNestedIcon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.TableButton).addComponent(this.PDFButton).addComponent(this.CloseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addGap(122, 122, 122)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.mergeOrderDetails).addContainerGap()))));
        this.mergeOrderDetails.getAccessibleContext().setAccessibleName("mergeOrderDetails");
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 407, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 790, Short.MAX_VALUE));
    }

    private void FilenameSelect1ActionPerformed(ActionEvent evt) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        if (!network.nodesList().isEmpty()) {
            this.saveMetadata(true);
        }
        if (this.FilenameSelect1.getSelectedIndex() >= 0) {
            LoadNetworkTask.loadFile((File)this.spadeCxt.getGMLFiles()[this.FilenameSelect1.getSelectedIndex()], (boolean)true);
            File[] layoutFiles = this.spadeCxt.getPath().listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.matches("layout.table");
                }
            });
            if (layoutFiles.length == 1) {
                this.loadMetadata(layoutFiles[0]);
            } else if (layoutFiles.length > 1) {
                JOptionPane.showMessageDialog(null, "Error: Found more than one layout.table file");
                return;
            }
            Cytoscape.getCurrentNetworkView().addNodeContextMenuListener((NodeContextMenuListener)new NodeContextMenu());
            Cytoscape.getCurrentNetworkView().fitContent();
            VisualMapping.populateNumericAttributeComboBox(this.ColoringSelect1);
            this.ColoringSelect1.setSelectedIndex(0);
            this.RangeSelect1.setSelectedIndex(0);
            this.spadeCxt.setNormalizationKind((SpadeContext.NormalizationKind)((Object)this.RangeSelect1.getSelectedItem()));
            this.spadeCxt.setSymmetry(this.radioSymmetric1.isSelected() ? SpadeContext.SymmetryType.SYMMETRIC : SpadeContext.SymmetryType.ASYMMETRIC);
            this.updateNodeSizeAndColors();
            this.NumberEventsLabel.setText("Select a file to display network and bi-axial plot");
            this.TValTableModel.setRowCount(0);
            this.TValTableModel.addRow(new Object[]{"Select nodes...", ""});
            this.PlotContainer.setViewportView(null);
            this.scatterPlot = null;
            this.fcsOperations = null;
            File[] mergeOrderFile = this.spadeCxt.getPath().listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.matches("merge_order.txt");
                }
            });
            try {
                if (mergeOrderFile.length == 1) {
                    this.mergeOrderOps = new MergeOrderOperations(mergeOrderFile[0]);
                    this.mergeOrderSlider.setMaximum(this.mergeOrderOps.getMaxMergeOrder());
                } else if (mergeOrderFile.length == 0) {
                    this.jLabel5.setText("merge_order.txt not found");
                    this.mergeOrderSlider.setEnabled(false);
                    this.jCheckShowNestedIcon.setEnabled(false);
                    this.mergeOrderDetails.setEnabled(false);
                } else {
                    JOptionPane.showMessageDialog(null, "Error: Found more than one merge_order.txt file.");
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error reading Merge Order file: " + ex.getMessage());
            }
            try {
                this.fcsOperations = new FCSOperations(((FileItem)this.FilenameSelect1.getSelectedItem()).getFCSFile());
                this.scatterPlot = new ScatterPlotPanel(this.fcsOperations);
                this.PlotContainer.setViewportView(this.scatterPlot);
                Cytoscape.getCurrentNetwork().addSelectEventListener((SelectEventListener)new HandleSelect());
                this.updateFCSConsumers();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "FCS file not found: " + ((FileItem)this.FilenameSelect1.getSelectedItem()).getFCSpath());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading FCS file: " + this.FilenameSelect1.getSelectedItem());
            }
        }
    }

    private void ColoringSelect1ActionPerformed(ActionEvent evt) {
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void RangeSelect1ActionPerformed(ActionEvent evt) {
        this.spadeCxt.setNormalizationKind((SpadeContext.NormalizationKind)((Object)this.RangeSelect1.getSelectedItem()));
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void radioSymmetric1ActionPerformed(ActionEvent evt) {
        this.spadeCxt.setSymmetry(SpadeContext.SymmetryType.SYMMETRIC);
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void radioAsymmetric1ActionPerformed(ActionEvent evt) {
        this.spadeCxt.setSymmetry(SpadeContext.SymmetryType.ASYMMETRIC);
        this.updateNodeSizeAndColors();
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }

    private void PDFButtonActionPerformed(ActionEvent evt) {
        this.saveMetadata(false);
        WorkflowWizard wf = new WorkflowWizard((Frame)Cytoscape.getDesktop());
        WorkflowWizardPanels.GeneratePDFs genPDFs = new WorkflowWizardPanels.GeneratePDFs(this.spadeCxt);
        wf.registerWizardPanel("GENERATE_PDFS_PANEL", genPDFs);
        wf.setCurrentPanel("GENERATE_PDFS_PANEL");
        int showModalDialog = wf.showModalDialog();
        if (showModalDialog == 1) {
            return;
        }
        if (showModalDialog != 0) {
            JOptionPane.showMessageDialog(null, "Error occured in workflow wizard.");
        }
    }

    private void TableButtonActionPerformed(ActionEvent evt) {
        try {
            this.spadeCxt.authorMakePivot("pivotSPADE.R");
            SpadeController ctl = new SpadeController(this.spadeCxt.getPath(), "pivotSPADE.R");
            ctl.exec();
        }
        catch (IOException ex) {
            CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
        }
    }

    private void CloseButtonActionPerformed(ActionEvent evt) {
        Object[] options = new String[]{"Save and Close", "Close", "Cancel"};
        int returnvalue = JOptionPane.showOptionDialog(null, "Save network layout before closing?", "Close SPADE", 1, 3, null, options, options[0]);
        if (returnvalue != 2) {
            if (returnvalue == 0) {
                this.saveMetadata(true);
            }
            Cytoscape.getDesktop().getCytoPanel(7).remove(Cytoscape.getDesktop().getCytoPanel(7).getCytoPanelComponentCount() - 1);
        }
    }

    private void mergeOrderSliderStateChanged(ChangeEvent evt) {
        int mergeOrder = this.mergeOrderSlider.getValue();
        if (this.mergeOrderOps != null) {
            try {
                mergeOrder = this.mergeOrderOps.createNestedGraphIncremental(mergeOrder, this.jCheckShowNestedIcon.isSelected());
                this.jLabel5.setText("Merge order: " + String.valueOf(mergeOrder) + " of " + this.mergeOrderOps.getMaxMergeOrder());
            }
            catch (Exception ex) {
                CyLogger.getLogger().debug("Exception processing merge order: " + mergeOrder, (Throwable)ex);
            }
            this.mergeOrderSlider.requestFocusInWindow();
        }
    }

    private void mergeOrderDetailsActionPerformed(ActionEvent evt) {
        try {
            if (this.mergeOrderOps != null) {
                if ("See Merge Details".equals(this.mergeOrderDetails.getText())) {
                    this.mergeOrderDetails.setText("Clear Merge Details");
                    this.mergeOrderSlider.setEnabled(false);
                    this.mergeOrderOps.showNestedNetworkDetails();
                } else {
                    this.mergeOrderOps.destroyNestedNetworkDetails();
                    this.mergeOrderDetails.setText("See Merge Details");
                    this.mergeOrderSlider.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            CyLogger.getLogger().debug("", (Throwable)ex);
            this.mergeOrderSlider.setEnabled(true);
        }
    }

    public class HandleSelect
    implements SelectEventListener {
        public void onSelectEvent(SelectEvent e) {
            SpadeAnalysisPanel.this.updateFCSConsumers();
        }
    }

    public class FileItem {
        private File f;

        public FileItem(File file) {
            this.f = file;
        }

        public String toString() {
            return this.f.getName().substring(0, this.f.getName().indexOf(".fcs"));
        }

        public String getFCSpath() {
            return this.f.getName();
        }

        public File getFCSFile() {
            return this.f;
        }
    }
}

