/*
 * Decompiled with CFR 0.152.
 */
package cytospade.ui;

import cytoscape.logger.CyLogger;
import cytospade.FCSOperations;
import cytospade.SpadeContext;
import cytospade.ui.SpadeAnalysisPanel;
import facs.CanvasSettings;
import facs.Plot2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import org.jdesktop.layout.GroupLayout;

public class ScatterPlotPanel
extends JPanel {
    private FCSOperations fcsOps;
    private int xAxisType;
    private int yAxisType;
    private String xAxisParam;
    private String yAxisParam;
    private JLabel Plot;
    private JLayeredPane PlotArea;
    private JComboBox StyleSelect;
    private JLabel jLabel2;
    private JLabel xAxisClickable;
    private JPopupMenu xAxisPopup;
    private JLabel yAxisClickable;
    private JPopupMenu yAxisPopup;

    public ScatterPlotPanel(FCSOperations fcsOps) {
        int i;
        this.fcsOps = fcsOps;
        this.initComponents();
        this.xAxisType = this.yAxisType = this.getAxisType("Log");
        this.xAxisParam = this.yAxisParam = fcsOps.getChannelShortName(0);
        for (String scales : new String[]{"Linear", "Log", "Arcsinh: CyToF", "Arcsinh: Fluor"}) {
            JMenuItem menuItem = new JMenuItem(scales);
            menuItem.addActionListener(new xScaleChanged());
            this.xAxisPopup.add(menuItem);
            menuItem = new JMenuItem(scales);
            menuItem.addActionListener(new yScaleChanged());
            this.yAxisPopup.add(menuItem);
        }
        this.xAxisPopup.addSeparator();
        this.yAxisPopup.addSeparator();
        Object[] names = new String[fcsOps.getChannelCount()];
        for (i = 0; i < fcsOps.getChannelCount(); ++i) {
            names[i] = SpadeContext.getFCSChannelFormattedName(fcsOps.getFCSFile(), i);
        }
        Arrays.sort(names);
        for (i = 0; i < fcsOps.getChannelCount(); ++i) {
            JMenuItem menuItem = new JMenuItem((String)names[i]);
            menuItem.addActionListener(new xParamChanged());
            this.xAxisPopup.add(menuItem);
            menuItem = new JMenuItem((String)names[i]);
            menuItem.addActionListener(new yParamChanged());
            this.yAxisPopup.add(menuItem);
        }
    }

    public void updatePlot() {
        new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                int plot_type = ScatterPlotPanel.this.getPlotType((String)ScatterPlotPanel.this.StyleSelect.getSelectedItem());
                int event_count = ScatterPlotPanel.this.fcsOps.getSelectedNodesCount() == 0 ? ScatterPlotPanel.this.fcsOps.getEventCount() : ScatterPlotPanel.this.fcsOps.getSelectedEventCount();
                int dot_size = 1;
                if (event_count > 5000) {
                    dot_size = 1;
                } else if (event_count > 1000) {
                    dot_size = 2;
                } else if (event_count > 10) {
                    dot_size = 3;
                } else {
                    plot_type = 11;
                    dot_size = 3;
                }
                CanvasSettings cs = CanvasSettings.getCanvasSettings(1, 1, 0, 1, 2, plot_type, 1, false, true, true, true, true, false, 300, 1.0, 1.0, 10.0, 10.0, -1, event_count, dot_size);
                try {
                    BufferedImage image = Plot2D.drawPlot(cs, ScatterPlotPanel.this.fcsOps.getSelectedNodesCount() == 0 ? ScatterPlotPanel.this.fcsOps.getEvents(ScatterPlotPanel.this.xAxisParam) : ScatterPlotPanel.this.fcsOps.getSelectedEvents(ScatterPlotPanel.this.xAxisParam), ScatterPlotPanel.this.fcsOps.getSelectedNodesCount() == 0 ? ScatterPlotPanel.this.fcsOps.getEvents(ScatterPlotPanel.this.yAxisParam) : ScatterPlotPanel.this.fcsOps.getSelectedEvents(ScatterPlotPanel.this.yAxisParam), ScatterPlotPanel.this.fcsOps.getSelectedNodesCount() == 0 ? null : ScatterPlotPanel.this.fcsOps.getEvents(ScatterPlotPanel.this.xAxisParam), ScatterPlotPanel.this.fcsOps.getSelectedNodesCount() == 0 ? null : ScatterPlotPanel.this.fcsOps.getEvents(ScatterPlotPanel.this.yAxisParam), ScatterPlotPanel.this.xAxisParam, ScatterPlotPanel.this.yAxisParam, ScatterPlotPanel.this.fcsOps.getEventMax(ScatterPlotPanel.this.xAxisParam), ScatterPlotPanel.this.fcsOps.getEventMax(ScatterPlotPanel.this.yAxisParam), ScatterPlotPanel.this.xAxisType, ScatterPlotPanel.this.yAxisType);
                    ScatterPlotPanel.this.Plot.setIcon(new ImageIcon(image));
                }
                catch (IOException ex) {
                    ScatterPlotPanel.this.Plot.setIcon(null);
                    CyLogger.getLogger((String)SpadeAnalysisPanel.class.getName()).error(null, (Throwable)ex);
                }
                return 0;
            }
        }.execute();
    }

    private int getPlotType(String type) {
        if (type.matches("Shaded Contour")) {
            return 15;
        }
        if (type.matches("Dot")) {
            return 11;
        }
        if (type.matches("Density Dot")) {
            return 12;
        }
        if (type.matches("Shadow")) {
            return 13;
        }
        if (type.matches("Contour")) {
            return 14;
        }
        if (type.matches("Density")) {
            return 16;
        }
        return 11;
    }

    private int getAxisType(String axis) {
        if (axis.matches("Linear")) {
            return 0;
        }
        if (axis.matches("Log")) {
            return 1;
        }
        if (axis.matches("Arcsinh: CyToF")) {
            return 3;
        }
        if (axis.matches("Arcsinh: Fluor")) {
            return 2;
        }
        return 1;
    }

    private void initComponents() {
        this.xAxisPopup = new JPopupMenu();
        this.yAxisPopup = new JPopupMenu();
        this.StyleSelect = new JComboBox();
        this.jLabel2 = new JLabel();
        this.PlotArea = new JLayeredPane();
        this.Plot = new JLabel();
        this.xAxisClickable = new JLabel();
        this.yAxisClickable = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(360, 400));
        this.setSize(new Dimension(360, 400));
        this.StyleSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Shaded Contour", "Dot", "Density Dot", "Shadow", "Contour", "Density"}));
        this.StyleSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScatterPlotPanel.this.StyleSelectActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.StyleSelect);
        this.jLabel2.setText("Plot Style");
        this.Plot.setHorizontalAlignment(0);
        this.Plot.setBounds(0, 0, 360, 360);
        this.PlotArea.add((Component)this.Plot, JLayeredPane.DEFAULT_LAYER);
        this.xAxisClickable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScatterPlotPanel.this.xAxisClickableMouseClicked(evt);
            }
        });
        this.xAxisClickable.setBounds(48, 311, 308, 46);
        this.PlotArea.add((Component)this.xAxisClickable, JLayeredPane.DEFAULT_LAYER);
        this.yAxisClickable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScatterPlotPanel.this.yAxisClickableMouseClicked(evt);
            }
        });
        this.yAxisClickable.setBounds(0, 0, 46, 308);
        this.PlotArea.add((Component)this.yAxisClickable, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.StyleSelect, -2, 260, -2)).add((Component)this.PlotArea, -2, 360, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.StyleSelect, -2, -1, -2)).addPreferredGap(1).add((Component)this.PlotArea, -2, 360, -2).addContainerGap()));
    }

    private void StyleSelectActionPerformed(ActionEvent evt) {
        this.updatePlot();
    }

    private void xAxisClickableMouseClicked(MouseEvent evt) {
        this.xAxisPopup.show(this.xAxisClickable, 154, 23);
    }

    private void yAxisClickableMouseClicked(MouseEvent evt) {
        this.yAxisPopup.show(this.yAxisClickable, 23, 154);
    }

    private class yScaleChanged
    implements ActionListener {
        private yScaleChanged() {
        }

        public void actionPerformed(ActionEvent e) {
            ScatterPlotPanel.this.yAxisType = ScatterPlotPanel.this.getAxisType(e.getActionCommand());
            ScatterPlotPanel.this.updatePlot();
        }
    }

    private class xScaleChanged
    implements ActionListener {
        private xScaleChanged() {
        }

        public void actionPerformed(ActionEvent e) {
            ScatterPlotPanel.this.xAxisType = ScatterPlotPanel.this.getAxisType(e.getActionCommand());
            ScatterPlotPanel.this.updatePlot();
        }
    }

    private class yParamChanged
    implements ActionListener {
        private yParamChanged() {
        }

        public void actionPerformed(ActionEvent e) {
            ScatterPlotPanel.this.yAxisParam = SpadeContext.getShortNameFromFormattedName(e.getActionCommand());
            ScatterPlotPanel.this.updatePlot();
        }
    }

    private class xParamChanged
    implements ActionListener {
        private xParamChanged() {
        }

        public void actionPerformed(ActionEvent e) {
            ScatterPlotPanel.this.xAxisParam = SpadeContext.getShortNameFromFormattedName(e.getActionCommand());
            ScatterPlotPanel.this.updatePlot();
        }
    }
}

