/*
 * Decompiled with CFR 0.152.
 */
package facs.scale;

import facs.scale.ArcsinhScaleArgument;
import facs.scale.Scale;
import facs.scale.ScaleArgument;

public final class ArcsinhScale
implements Scale {
    ArcsinhScale() {
    }

    public double getValue(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public double undoValue(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    public double getValue(double x, ScaleArgument arg) {
        if (arg == null) {
            return this.getValue(x);
        }
        if (arg instanceof ArcsinhScaleArgument) {
            int compressionWidth = ((ArcsinhScaleArgument)arg).getCompressionWidth();
            if (compressionWidth == 0 || compressionWidth == 1) {
                return this.getValue(x);
            }
            return this.getValue(x / (double)compressionWidth);
        }
        return this.getValue(x);
    }

    public double unbin(int binIndex, int numBins, double scaleMin, double scaleMax, ScaleArgument arg) {
        double unbinnedValue = 0.0;
        double fractionOfScale = (double)binIndex / (double)numBins;
        int compressionWidth = ((ArcsinhScaleArgument)arg).getCompressionWidth();
        double scaleRange = this.getValue(scaleMax / (double)compressionWidth) - this.getValue(scaleMin / (double)compressionWidth);
        double valueExponent = this.getValue(scaleMin / (double)compressionWidth) + fractionOfScale * scaleRange;
        unbinnedValue = this.undoValue(valueExponent) * (double)compressionWidth;
        return unbinnedValue;
    }

    public String cacheKey() {
        return "ArcsinhScale";
    }
}

