### R code from vignette source 'xpsClasses.Rnw'

###################################################
### code chunk number 1: xpsClasses.Rnw:173-174
###################################################
library(xps)


###################################################
### code chunk number 2: R
###################################################
getClassDef("TreeSet")


###################################################
### code chunk number 3: R
###################################################
getClassDef("SchemeTreeSet")


###################################################
### code chunk number 4: xpsClasses.Rnw:226-228
###################################################
scheme.test3 <- root.scheme(paste(path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
str(scheme.test3)


###################################################
### code chunk number 5: xpsClasses.Rnw:239-241
###################################################
idx <- export(scheme.test3, treetype="idx", outfile="Test3_idx.txt", as.dataframe=TRUE, verbose=FALSE)
idx[10:16,]


###################################################
### code chunk number 6: xpsClasses.Rnw:247-249
###################################################
scm <- export(scheme.test3, treetype="scm", outfile="Test3_scm.txt", as.dataframe=TRUE, verbose=FALSE)
scm[1843:1848,]


###################################################
### code chunk number 7: xpsClasses.Rnw:260-264
###################################################
scheme.test3 <- attachMask(scheme.test3)
msk <- chipMask(scheme.test3)
scheme.test3 <- removeMask(scheme.test3)
msk[1843:1848,]


###################################################
### code chunk number 8: xpsClasses.Rnw:270-272
###################################################
prb <- export(scheme.test3, treetype="prb", outfile="Test3_prb.txt",as.dataframe=TRUE, verbose=FALSE)
prb[1843:1848,]


###################################################
### code chunk number 9: xpsClasses.Rnw:278-280
###################################################
ann <- export(scheme.test3, treetype="ann", outfile="Test3_ann.txt",as.dataframe=TRUE, verbose=FALSE)
head(ann)


###################################################
### code chunk number 10: R
###################################################
getClassDef("ProcesSet")


###################################################
### code chunk number 11: R
###################################################
getClassDef("DataTreeSet")


###################################################
### code chunk number 12: xpsClasses.Rnw:349-351
###################################################
data.test3 <- root.data(scheme.test3, paste(path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))
str(data.test3)


###################################################
### code chunk number 13: R
###################################################
getClassDef("ExprTreeSet")


###################################################
### code chunk number 14: R
###################################################
getClassDef("CallTreeSet")


###################################################
### code chunk number 15: R
###################################################
getClassDef("QualTreeSet")


###################################################
### code chunk number 16: R
###################################################
getClassDef("ProjectInfo")


###################################################
### code chunk number 17: xpsClasses.Rnw:454-470
###################################################
project <- ProjectInfo(submitter="Christian", laboratory="home",contact="email")
projectInfo(project)    <- c("TestProject","20060106","Project Type","use Test3 data for testing","my comment")
authorInfo(project)     <- c("Stratowa","Christian","Project Leader","Company","Dept","cstrato.at.aon.at","++43-1-1234","my comment")
datasetInfo(project)    <- c("Test3Set","MC","Tissue","Stratowa","20060106","description","my comment")
sourceInfo(project)     <- c("Unknown","source type","Homo sapiens","caucasian","description","my comment")
primcellInfo(project)   <- c("Mel31","primary cell",20071123,"extracted from patient","male","my pheno","my genotype","RNA extraction",TRUE,"NMRI","female",7.0,"months", "my comment")
arrayInfo(project)      <- c("Test3","GeneChip","description","my comment")
hybridizInfo(project)   <- c(c("TestA1","hyb type","TestA1.CEL",20071117,"my prep1","standard protocol","A1",1,"my comment"),
                             c("TestA2","hyb type","TestA2.CEL",20071117,"my prep2","standard protocol","A2",1,"my comment"),
                             c("TestB1","hyb type","TestB1.CEL",20071117,"my prep1","standard protocol","B1",2,"my comment"),
                             c("TestB2","hyb type","TestB2.CEL",20071117,"my prep2","standard protocol","B2",2,"my comment"))
treatmentInfo(project)  <- c(c("TestA1","DMSO",4.3,"mM",1.0,"hours","intravenous","my comment"),
                             c("TestA2","DMSO",4.3,"mM",8.0,"hours","intravenous","my comment"),
                             c("TestB1","DrugA2",4.3,"mM",1.0,"hours","intravenous","my comment"),
                             c("TestB2","DrugA2",4.3,"mM",8.0,"hours","intravenous","my comment"))
show(project)


###################################################
### code chunk number 18: R
###################################################
getClassDef("Filter")


###################################################
### code chunk number 19: R
###################################################
getClassDef("PreFilter")


###################################################
### code chunk number 20: xpsClasses.Rnw:515-527
###################################################
prefltr <- PreFilter()
madFilter(prefltr) <- c(0.5,0.01)
cvFilter(prefltr) <- c(0.3,0.0,0.01)
varFilter(prefltr) <- c(0.6,0.02,0.01)
diffFilter(prefltr) <- c(2.2,0.0,0.01)
ratioFilter(prefltr) <- c(1.5)
gapFilter(prefltr) <- c(0.3,0.05,0.0,0.01)
lowFilter(prefltr) <- c(4.0,3,"samples")
highFilter(prefltr) <- c(14.5,75.0,"percent")
quantileFilter(prefltr) <- c(3.0, 0.05, 0.95)
callFilter(prefltr) <- c(0.02,80.0,"percent")
str(prefltr)


###################################################
### code chunk number 21: R
###################################################
getClassDef("UniFilter")


###################################################
### code chunk number 22: xpsClasses.Rnw:552-558
###################################################
unifltr <- UniFilter()
fcFilter(unifltr) <- c(1.5,"both")
callFilter(unifltr) <- c(0.02,80.0,"percent")
unitestFilter(unifltr) <- c(0.01,"pval")
uniTest(unifltr) <- c("t.test","two.sided","wy",5000,0.0,FALSE,0.98,TRUE)
str(unifltr)


###################################################
### code chunk number 23: R
###################################################
getClassDef("FilterTreeSet")


###################################################
### code chunk number 24: R
###################################################
getClassDef("AnalysisTreeSet")


