### R code from vignette source 'xpsPreprocess.Rnw'

###################################################
### code chunk number 1: xpsPreprocess.Rnw:73-75 (eval = FALSE)
###################################################
## scheme.u133p2 <- root.scheme(file.path(scmdir, "Scheme_HGU133p2_na28.root"))
## data.u133p2   <- root.data(scheme.u133p2, file.path(datdir, "HuTissuesU133P2_cel.root"))


###################################################
### code chunk number 2: xpsPreprocess.Rnw:79-80 (eval = FALSE)
###################################################
## data.rma <- rma(data.u133p2, "MixU133P2RMA", filedir=outdir)


###################################################
### code chunk number 3: xpsPreprocess.Rnw:89-95 (eval = FALSE)
###################################################
## expr.rma <- express(data.u133p2, "U133P2Exprs", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384), normalize.method="quantile", normalize.select="pmonly", 
##             normalize.option="transcript:together:none", normalize.logbase="0", 
##             normalize.params=c(0.0), summarize.method="medianpolish", summarize.select="pmonly", 
##             summarize.option="transcript", summarize.logbase="log2", summarize.params=c(10, 0.01, 1.0))


###################################################
### code chunk number 4: xpsPreprocess.Rnw:99-100 (eval = FALSE)
###################################################
## expr  <- validExpr(expr.rma)


###################################################
### code chunk number 5: xpsPreprocess.Rnw:122-125 (eval = FALSE)
###################################################
## bgrd.rma <- express(data.u133p2, "BgrdRMA", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384))


###################################################
### code chunk number 6: xpsPreprocess.Rnw:135-139 (eval = FALSE)
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.rma))
## datanames <- colnames(validData(bgrd.rma))
## image(bgrd.rma, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## image(bgrd.rma, transfo=log2, col=heat.colors(12), names=datanames[4])


###################################################
### code chunk number 7: xpsPreprocess.Rnw:154-156 (eval = FALSE)
###################################################
## hist(data.u133p2, which="pm")
## hist(bgrd.rma, which="pm")


###################################################
### code chunk number 8: xpsPreprocess.Rnw:169-171 (eval = FALSE)
###################################################
## boxplot(data.u133p2, which="pm")
## boxplot(bgrd.rma, which="pm")


###################################################
### code chunk number 9: xpsPreprocess.Rnw:185-189 (eval = FALSE)
###################################################
## bgrd <- validBgrd(bgrd.rma, which="pm")
## data <- validData(bgrd.rma, which="pm")
## boxplot(log2(bgrd), las=2)
## boxplot(log2(data), las=2)


###################################################
### code chunk number 10: xpsPreprocess.Rnw:209-213 (eval = FALSE)
###################################################
## norm.qu <- express(bgrd.rma, "NormQuan", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="quantile", normalize.select="pmonly", 
##            normalize.option="transcript:together:none", normalize.logbase="0",
##            normalize.params=c(0.0))


###################################################
### code chunk number 11: xpsPreprocess.Rnw:220-222 (eval = FALSE)
###################################################
## hist(norm.qu, which="pm")
## boxplot(norm.qu, which="pm")


###################################################
### code chunk number 12: xpsPreprocess.Rnw:237-240 (eval = FALSE)
###################################################
## data <- validData(norm.qu, which="pm")
## plot(log2(data[,1]), log2(data[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(data[,1]), log2(data[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### code chunk number 13: xpsPreprocess.Rnw:259-263 (eval = FALSE)
###################################################
## expr.mp <- express(norm.qu, "ExprMedpol", filedir=outdir, tmpdir="", update=FALSE, 
##            summarize.method="medianpolish", summarize.select="pmonly", 
##            summarize.option="transcript", summarize.logbase="log2", 
##            summarize.params=c(10, 0.01, 1.0), bufsize=32000)


###################################################
### code chunk number 14: xpsPreprocess.Rnw:277-279 (eval = FALSE)
###################################################
## hist(expr.mp)
## boxplot(expr.mp) 


###################################################
### code chunk number 15: xpsPreprocess.Rnw:294-297 (eval = FALSE)
###################################################
## expr  <- validData(expr.mp)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### code chunk number 16: xpsPreprocess.Rnw:362-365 (eval = FALSE)
###################################################
## bgrd.rma <- express(data.u133p2, "BgrdRMA", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384))


###################################################
### code chunk number 17: xpsPreprocess.Rnw:412-415 (eval = FALSE)
###################################################
## bgrd.mas4 <- express(data.u133p2, "BgrdMAS4", filedir=outdir, tmpdir="", update=FALSE, 
##              bgcorrect.method="sector", bgcorrect.select="all", bgcorrect.option="subtractbg",
##              bgcorrect.params=c(0.02, 4, 4, 0))


###################################################
### code chunk number 18: xpsPreprocess.Rnw:429-432 (eval = FALSE)
###################################################
## bgrd.mas <- express(data.u133p2, "BgrdMAS8x8", filedir=outdir, tmpdir="", update=FALSE, 
##             bgcorrect.method="sector", bgcorrect.select="both", bgcorrect.option="correctbg",
##             bgcorrect.params=c(0.02, 8, 8, 3, 0.5))


###################################################
### code chunk number 19: xpsPreprocess.Rnw:439-443 (eval = FALSE)
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.mas4))
## image(bgrd.mas4, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## bgrdnames <- colnames(validBgrd(bgrd.mas))
## image(bgrd.mas, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### code chunk number 20: xpsPreprocess.Rnw:515-518 (eval = FALSE)
###################################################
## bgrd.mas5 <- express(data.u133p2, "BgrdMAS5", filedir=outdir, tmpdir="", update=FALSE, 
##              bgcorrect.method="weightedsector", bgcorrect.select="both", bgcorrect.option="correctbg",
##              bgcorrect.params=c(0.02, 4, 4, 0, 100, 0.5))


###################################################
### code chunk number 21: xpsPreprocess.Rnw:523-526 (eval = FALSE)
###################################################
## hist(bgrd.mas5, which="both")
## bgrd <- validBgrd(bgrd.mas5)
## boxplot(log2(bgrd), las=2)


###################################################
### code chunk number 22: xpsPreprocess.Rnw:545-548 (eval = FALSE)
###################################################
## bgrd.mas <- express(data.u133p2, "BgrdMAS5_8x8", filedir=outdir, tmpdir="", update=FALSE, 
##             bgcorrect.method="weightedsector", bgcorrect.select="both", bgcorrect.option="correctbg",
##             bgcorrect.params=c(0.02, 8, 8, 3, 100, 0.5))


###################################################
### code chunk number 23: xpsPreprocess.Rnw:552-556 (eval = FALSE)
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.mas5))
## image(bgrd.mas5, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## bgrdnames <- colnames(validBgrd(bgrd.mas4))
## image(bgrd.mas, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### code chunk number 24: xpsPreprocess.Rnw:619-622 (eval = FALSE)
###################################################
## bgrd.gc <- express(data.u133p2, "BgrdGC", filedir=outdir, tmpdir="", update=FALSE, 
##            bgcorrect.method="gccontent", bgcorrect.select="none", bgcorrect.option="attenuatebg",
##            bgcorrect.params=c(0.4, 0.005, -1.0))


###################################################
### code chunk number 25: xpsPreprocess.Rnw:627-630 (eval = FALSE)
###################################################
## hist(bgrd.gc, which="pm")
## bgrd <- validBgrd(bgrd.gc, which="pm")
## boxplot(log2(bgrd), las=2)


###################################################
### code chunk number 26: xpsPreprocess.Rnw:643-645 (eval = FALSE)
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.gc))
## image(bgrd.gc, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### code chunk number 27: xpsPreprocess.Rnw:721-725 (eval = FALSE)
###################################################
## norm.qu <- express(bgrd.mas, "NormQuan", filedir=outdir, update=FALSE, 
##            normalize.method="quantile", normalize.select="all", 
##            normalize.option="transcript:together:none",
##            normalize.logbase="0", normalize.params=c(0.0, 1.0))


###################################################
### code chunk number 28: xpsPreprocess.Rnw:772-775 (eval = FALSE)
###################################################
## norm.mn <- express(bgrd.mas, "NormMean", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="mean", normalize.select="both", normalize.option="transcript:all",
##            normalize.logbase="0", normalize.params=c(0.0, -1))


###################################################
### code chunk number 29: xpsPreprocess.Rnw:780-783 (eval = FALSE)
###################################################
## norm.md <- express(bgrd.mas, "NormMedian", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="median", normalize.select="pmonly", normalize.option="transcript:all",
##            normalize.logbase="log2", normalize.params=c(500), reference.index=1)


###################################################
### code chunk number 30: xpsPreprocess.Rnw:833-836 (eval = FALSE)
###################################################
## norm.low <- express(bgrd.mas, "NormLowess", filedir=outdir, tmpdir="", update=FALSE, 
##             normalize.method="lowess", normalize.select="pmonly", normalize.option="transcript:all",
##             normalize.logbase="log2", normalize.params=c(0.67, 3.0, 0.0, 0.0))


###################################################
### code chunk number 31: xpsPreprocess.Rnw:881-884 (eval = FALSE)
###################################################
## norm.sup <- express(bgrd.mas, "NormSupsmuR2", filedir=outdir, tmpdir="", update=FALSE, 
##             normalize.method="supsmu", normalize.select="pmonly", normalize.option="transcript:all",
##             normalize.logbase="log2", normalize.params=c(0.0, 0.0, 2.0, 0.0))


###################################################
### code chunk number 32: xpsPreprocess.Rnw:888-890 (eval = FALSE)
###################################################
## hist(norm.sup, which="pm")
## boxplot(norm.sup, which="pm")


###################################################
### code chunk number 33: xpsPreprocess.Rnw:963-966 (eval = FALSE)
###################################################
## expr.mp <- express(norm.qu, "ExprMedpol", filedir=outdir, update=FALSE, 
##            summarize.method="medianpolish", summarize.select="pmonly", summarize.option="transcript",
##            summarize.logbase="log2", summarize.params=c(10, 0.01, 1.0))


###################################################
### code chunk number 34: xpsPreprocess.Rnw:1004-1007 (eval = FALSE)
###################################################
## expr.adf <- express(bgrd.mas, "ExprAvgDif", filedir=outdir, update=FALSE, 
##             summarize.method="avgdiff", summarize.select="none", summarize.option="transcript",
##             summarize.logbase="0", summarize.params=c(3.0))


###################################################
### code chunk number 35: xpsPreprocess.Rnw:1046-1049 (eval = FALSE)
###################################################
## expr.tbw <- express(bgrd.mas, "ExprTukey", filedir=outdir, update=FALSE, 
##             summarize.method="tukeybiweight", summarize.select="none", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(0.03, 10.0, 2.0e-20, 5.0, 0.0001, 1.0, 0.5))


###################################################
### code chunk number 36: xpsPreprocess.Rnw:1055-1057 (eval = FALSE)
###################################################
## hist(expr.tbw)
## boxplot(expr.tbw) 


###################################################
### code chunk number 37: xpsPreprocess.Rnw:1073-1076 (eval = FALSE)
###################################################
## expr  <- validData(expr.tbw)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### code chunk number 38: xpsPreprocess.Rnw:1124-1127 (eval = FALSE)
###################################################
## expr.dfw <- express(norm.qu, "ExprDFW", filedir=outdir, update=FALSE, 
##             summarize.method="dfw", summarize.select="pmonly", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(3.0, 1.0, 0.01))


###################################################
### code chunk number 39: xpsPreprocess.Rnw:1131-1133 (eval = FALSE)
###################################################
## hist(expr.dfw)
## boxplot(expr.dfw) 


###################################################
### code chunk number 40: xpsPreprocess.Rnw:1146-1149 (eval = FALSE)
###################################################
## expr  <- validData(expr.dfw)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### code chunk number 41: xpsPreprocess.Rnw:1200-1203 (eval = FALSE)
###################################################
## expr.frm <- express(norm.qu, "ExprFARMS", filedir=outdir, update=FALSE, 
##             summarize.method="farms", summarize.select="pmonly", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(131, 0.5, 0.0, 1.0, 0.00001, 100, 1))


###################################################
### code chunk number 42: xpsPreprocess.Rnw:1209-1211 (eval = FALSE)
###################################################
## hist(expr.frm)
## boxplot(expr.frm) 


###################################################
### code chunk number 43: xpsPreprocess.Rnw:1224-1227 (eval = FALSE)
###################################################
## expr  <- validData(expr.frm)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### code chunk number 44: xpsPreprocess.Rnw:1298-1301 (eval = FALSE)
###################################################
## nrxp.mn <- normalize(expr.tbw,  "NrmExpMean", filedir=outdir, update=FALSE, 
##            select="separate", method="mean", option="transcript:all", logbase="0", 
##            refindex=1, refmethod="mean", params=c(0.02, 500))


###################################################
### code chunk number 45: xpsPreprocess.Rnw:1309-1311 (eval = FALSE)
###################################################
## hist(nrxp.mn)
## boxplot(nrxp.mn) 


###################################################
### code chunk number 46: xpsPreprocess.Rnw:1372-1375 (eval = FALSE)
###################################################
## nrxp.low <- normalize(expr.tbw,  "tmp_NrmExpLow", filedir=outdir, update=FALSE, 
##             select="separate", method="lowess", option="transcript:all", logbase="log2", 
##             refindex=0, refmethod="mean", params=c(0.67, 3, 0.0, 0.0))


###################################################
### code chunk number 47: xpsPreprocess.Rnw:1419-1422 (eval = FALSE)
###################################################
## nrxp.sup <- normalize(expr.tbw,  "tmp_NrmExpSupR2", filedir=outdir, update=FALSE, 
##             select="separate", method="supsmu", option="transcript:all", logbase="log2", 
##             refindex=0, refmethod="mean", params=c(0.0, 0.0, 2, 0.0))


