## ---- eval = FALSE------------------------------------------------------------
#  # install.packages("BiocManager")
#  BiocManager::install("BRGenomics")

## ---- eval = FALSE------------------------------------------------------------
#  # install.packages("remotes")
#  remotes::install_github("mdeber/BRGenomics@R3")

## ---- message=FALSE-----------------------------------------------------------
library(BRGenomics)

## -----------------------------------------------------------------------------
data("PROseq")
PROseq

## -----------------------------------------------------------------------------
data("txs_dm6_chr4")
txs_dm6_chr4

## -----------------------------------------------------------------------------
length(txs_dm6_chr4) 

## -----------------------------------------------------------------------------
txs_dm6_chr4[2]

## -----------------------------------------------------------------------------
tx4 <- txs_dm6_chr4[c(1, 10, 200, 300)]
tx4

## -----------------------------------------------------------------------------
width(tx4)

## -----------------------------------------------------------------------------
mcols(tx4)

## -----------------------------------------------------------------------------
mcols(tx4)[, 2]
mcols(tx4)[, "gene_id"]
tx4$gene_id
tx4_names <- tx4$tx_name
tx4_names

## -----------------------------------------------------------------------------
tx4$gene_id[1]

## -----------------------------------------------------------------------------
mcols(tx4) <- mcols(tx4)[, -1]
tx4

## -----------------------------------------------------------------------------
names(mcols(tx4)) <- "gene_id"
tx4

## -----------------------------------------------------------------------------
tx4$tx_name <- tx4_names
tx4

## -----------------------------------------------------------------------------
tx4$gene_id[1] <- "gene1"
tx4$tx_name <- 1:4
tx4

## -----------------------------------------------------------------------------
start(tx4)

## -----------------------------------------------------------------------------
tx4_tss <- resize(tx4, width = 1, fix = "start")
tx4_tss
start(tx4_tss)

## -----------------------------------------------------------------------------
mcols(tx4) <- NULL
tx4

