/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bridgedb.AttributeMapper;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.Driver;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.XrefIterator;
import org.bridgedb.impl.InternalUtils;
import org.bridgedb.rdb.SimpleGdbFactory;

public abstract class IDMapperRdb
implements IDMapper,
AttributeMapper,
XrefIterator {
    public abstract String getDbName();

    public String toString() {
        return this.getDbName();
    }

    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        return InternalUtils.mapMultiFromSingle((IDMapper)this, srcXrefs, (DataSource[])tgtDataSources);
    }

    static {
        BridgeDb.register((String)"idmapper-pgdb", (Driver)new DriverPgdb());
        BridgeDb.register((String)"idmapper-derbyclient", (Driver)new DriverClient());
        BridgeDb.register((String)"idmapper-jdbc", (Driver)new DriverJdbc());
    }

    private static final class DriverClient
    implements Driver {
        private DriverClient() {
        }

        public IDMapper connect(String location) throws IDMapperException {
            try {
                Map args = InternalUtils.parseLocation((String)location, (String[])new String[]{"host", "port"});
                if (!args.containsKey("BASE")) {
                    throw new IllegalArgumentException("Expected species name in connection string: " + location);
                }
                String host = args.containsKey("host") ? (String)args.get("host") : "wikipathways.org";
                String port = args.containsKey("port") ? (String)args.get("port") : "1527";
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                Properties sysprop = System.getProperties();
                sysprop.setProperty("derby.storage.tempDirectory", System.getProperty("java.io.tmpdir"));
                sysprop.setProperty("derby.stream.error.file", File.createTempFile("derby", ".log").toString());
                String url = "jdbc:derby://" + host + ":" + port + "/" + (String)args.get("BASE");
                return SimpleGdbFactory.createInstance(location, url);
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new IDMapperException((Throwable)e);
            }
        }
    }

    private static final class DriverJdbc
    implements Driver {
        private DriverJdbc() {
        }

        public IDMapper connect(String location) throws IDMapperException {
            String url = "jdbc:" + location;
            return SimpleGdbFactory.createInstance(location, url);
        }
    }

    private static final class DriverPgdb
    implements Driver {
        private DriverPgdb() {
        }

        public IDMapper connect(String location) throws IDMapperException {
            String url = "jdbc:derby:jar:(" + location + ")database";
            return SimpleGdbFactory.createInstance(location, url);
        }
    }
}

