## ----setup, include=FALSE, cache=FALSE, echo=FALSE----------------------------
Sys.setenv(TEXINPUTS=getwd(),
           BIBINPUTS=getwd(),
           BSTINPUTS=getwd())

## ----setup2, include=TRUE, message=FALSE, warning=FALSE-----------------------
#if (!requireNamespace("BiocManager", quietly=TRUE))
    #install.packages("BiocManager")
#BiocManager::install("CINdex")
library(CINdex)

## -----------------------------------------------------------------------------
data("grl.data")

## -----------------------------------------------------------------------------
# loading the example file
data("cnvgr.18.auto")
data("snpgr.18.auto")

## -----------------------------------------------------------------------------
# loading the example file
data("hg18.ucsctrack")

## -----------------------------------------------------------------------------
data("clin.crc")

## ----chrcin, eval=FALSE, warning=FALSE----------------------------------------
#  run.cin.chr(grl.seg = grl.data)

## ----eval = FALSE-------------------------------------------------------------
#      dataMatrix_2.5_1.5_normalized_sum.RData
#      #gain threshold=2.5, loss threshold=1.5,normalized, showing sum (gains and losses)
#  
#      dataMatrix_2.5_1.5_unnormalized_sum.RData
#      #gain threshold=2.5, loss threshold=1.5, unnormalized,showing sum (gains and losses)
#  
#      dataMatrix_2.5_1.5_normalized_amp.RData
#      #gain threshold=2.5, loss threshold=1.5, normalized, showing amplifications
#  
#      dataMatrix_2.5_1.5_unnormalized_amp.RData
#      #gain threshold=2.5, loss threshold=1.5, unnormalized, showing amplifications
#  
#      dataMatrix_2.5_1.5_normalized_del.RData
#      #gain threshold=2.5, loss threshold=1.5, normalized, showing deletions
#  
#      dataMatrix_2.5_1.5_unnormalized_del.RData
#      # gain threshold=2.5, loss threshold=1.5, unnormalized,showing deletions
#  
#      dataMatrix_2.25_1.75_normalized_sum.RData
#      dataMatrix_2.25_1.75_unnormalized_sum.RData
#      dataMatrix_2.25_1.75_normalized_amp.RData
#      dataMatrix_2.25_1.75_unnormalized_amp.RData
#      dataMatrix_2.25_1.75_normalized_del.RData
#      dataMatrix_2.25_1.75_unnormalized_del.RData
#      dataMatrix_2.1_1.9_normalized_sum.RData
#      dataMatrix_2.1_1.9_unnormalized_sum.RData
#      dataMatrix_2.1_1.9_normalized_amp.RData
#      dataMatrix_2.1_1.9_unnormalized_amp.RData
#      dataMatrix_2.1_1.9_normalized_del.RData
#      dataMatrix_2.1_1.9_unnormalized_del.RData

## ----chrcinoneset, message = FALSE,warning=FALSE------------------------------
run.cin.chr(grl.seg =  grl.data, thr.gain=2.25, thr.loss=1.75, V.def=3, V.mode="sum")

## ----cytobandcin, eval=FALSE, message = FALSE, warning=FALSE------------------
#  run.cin.cyto(grl.seg = grl.data, cnvgr=cnvgr.18.auto, snpgr=snpgr.18.auto,
#               genome.ucsc = hg18.ucsctrack)

## ----cytoCinOneSet, warning=FALSE, results='hide'-----------------------------
run.cin.cyto(grl.seg = grl.data, cnvgr=cnvgr.18.auto, snpgr=snpgr.18.auto,
             genome.ucsc = hg18.ucsctrack,thr.gain = 2.25,thr.loss = 1.75,
             V.def = 3, V.mode="sum")

## ----chrheatmap, eval=FALSE, warning=FALSE, message = FALSE-------------------
#  comp.heatmap(R_or_C="Regular", clinical.inf=clin.crc, genome.ucsc=hg18.ucsctrack,
#               in.folder.name="output_chr_cin", out.folder.name="output_chr_plots")

## ----chrheatmapOneSet, warning=FALSE, message = FALSE-------------------------
comp.heatmap(R_or_C="Regular", clinical.inf=clin.crc, genome.ucsc=hg18.ucsctrack,
             thr.gain = 2.25, thr.loss = 1.75,V.def = 3,V.mode = "sum")

## ----cytoheatmap, eval=FALSE, warning=FALSE, message = FALSE,results="hide"----
#  comp.heatmap(R_or_C="Cytobands", clinical.inf=clin.crc, genome.ucsc=hg18.ucsctrack,
#               in.folder.name="output_cyto_cin", out.folder.name="output_cyto_plots")

## ----cytoHeatmapOneSet, warning=FALSE, message=FALSE, results='hide'----------
comp.heatmap(R_or_C="Cytobands", clinical.inf=clin.crc, genome.ucsc=hg18.ucsctrack,
             in.folder.name="output_cyto_cin", out.folder.name="output_cyto_plots",
             thr.gain=2.25, thr.loss=1.75,V.def=3,V.mode='sum')

## ----echo=FALSE, message=FALSE, results='hide'--------------------------------
file.copy(from ="output_cyto_plots/2.25_1.75_unnormalized_sum/chr_20_dataMatrix_2.25_1.75_unnormalized_sum.png",to = "output_cyto_plots/chr20.png")

## ----eval=FALSE---------------------------------------------------------------
#  load('output_cyto_cin/cytobands.cin_2.25_1.75_unnormalized_sum.RData')

## ----label=loadcytocin, echo=FALSE, warning=FALSE, message=FALSE--------------
#temp1 <- system.file("extdata", "cytobands.cin_2.25_1.75_unnormalized_sum.RData",
                     #package = "CINdex")
#load(file=temp1)
data("cytobands.cin")

## ----ttest, message=FALSE, warning=FALSE,results='hide'-----------------------
ttest.cyto.cin.heatmap(cytobands.cin.obj = cytobands.cin,
                       clinical.inf = clin.crc, genome.ucsc = hg18.ucsctrack,
                       file.ext='unnormalized')

## -----------------------------------------------------------------------------
#Loading the data into the workspace
data("geneAnno")

## ----eval=FALSE---------------------------------------------------------------
#  #Loading the heatmap object into the workspace
#  load('output_ttest/cyto.cin4heatmap.unnormalized.RData')
#  #object loaded is called "cyto.cin4heatmap"

## ----label=loadcyto4heatmap, echo=FALSE, warning=FALSE------------------------
data("cyto.cin4heatmap")

## ----extractgeneincyto--------------------------------------------------------
extract.genes.in.cyto.regions(cyto.cin4heatmapObj = cyto.cin4heatmap,
                              genome.ucsc=hg18.ucsctrack, gene.annotations = geneAnno)

## -----------------------------------------------------------------------------
load("output_genename/cytoband_genes.Rdata")

## -----------------------------------------------------------------------------
inputGenes <- unique(cytoband_genes[,"geneNames"])


## ----message=FALSE, eval=FALSE------------------------------------------------
#  #Loading the package
#  #if (!requireNamespace("BiocManager", quietly=TRUE))
#      #install.packages("BiocManager")
#  #BiocManager::install("org.Hs.eg.db")
#  library(org.Hs.eg.db)
#  ######
#  entrez <- mapIds(x = org.Hs.eg.db,keys = inputGenes, keytype = "SYMBOL",
#                   column = "ENTREZID")
#  entrez <- na.omit(entrez)

## ----message=FALSE, eval=FALSE, y=TRUE----------------------------------------
#  #Loading the package
#  #BiocManager::install("ReactomePA")
#  library(ReactomePA)
#  
#  #Calling function to perform enrichment
#  enrich <- enrichPathway(gene = entrez, pvalueCutoff = 0.05, readable = TRUE)
#  #Examining and saving the results
#  head(enrich@result,5)
#  #viewing top pathway names
#  head(enrich@result$Description,15)
#  #viewing top pathway names and its p-value
#  head(cbind(enrich@result$Description,enrich@result$pvalue),15)
#  #results not displayed in this document due to its large size

## ----eval=FALSE---------------------------------------------------------------
#  #saving results into a file for easy viewing
#  write.csv(enrich@result, "enrichment.csv",row.names = FALSE)

## ----barplots,fig.height=4, fig.width=12,eval=FALSE---------------------------
#  #View results as a bar plot
#  barplot(enrich, showCategory=8)

