## ---- echo = FALSE, results = "asis"--------------------------------------------------------------------------------------------
options(width = 130)

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("ClassifyRprocedure.png"), 
               style = 'margin-left: auto;margin-right: auto')

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("providedSelection.png"), 
               style = 'margin-left: auto;margin-right: auto')

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("providedClassifiers.png"), 
               style = 'margin-left: auto;margin-right: auto')

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("networkFunctions.png"), 
               style = 'margin-left: auto;margin-right: auto')

## ---- message = FALSE-----------------------------------------------------------------------------------------------------------
library(ClassifyR)
data(asthma)
measurements[1:5, 1:5]
head(classes)

## ---- tidy = FALSE--------------------------------------------------------------------------------------------------------------
DMresults <- runTests(measurements, classes, datasetName = "Asthma",
                      classificationName = "Different Means", permutations = 20, folds = 5,
                      seed = 2018, verbose = 1)
DMresults

## ---- fig.height = 8, fig.width = 8, results = "hold", message = FALSE----------------------------------------------------------
selectionPercentages <- distribution(DMresults, plot = FALSE)
sortedPercentages <- sort(selectionPercentages, decreasing = TRUE)
head(sortedPercentages)
mostChosen <- names(sortedPercentages)[1]
bestGenePlot <- plotFeatureClasses(measurements, classes, mostChosen, dotBinWidth = 0.1,
                                   xAxisLabel = "Normalised Expression")

## -------------------------------------------------------------------------------------------------------------------------------
DMresults <- calcCVperformance(DMresults, "balanced error")
DMresults
performance(DMresults)

## ---- tidy = FALSE--------------------------------------------------------------------------------------------------------------
selectParams <- SelectParams(KullbackLeiblerSelection, resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(naiveBayesKernel)
predictParams <- PredictParams(predictor = NULL, weighted = "weighted",
                               weight = "height difference", returnType = "both")
paramsList <- list(selectParams, trainParams, predictParams)
DDresults <- runTests(measurements, classes, datasetName = "Asthma",
                      classificationName = "Differential Distribution",
                      permutations = 20, folds = 5, seed = 2018,
                      params = paramsList, verbose = 1)
DDresults

## ---- fig.width = 10, fig.height = 7--------------------------------------------------------------------------------------------
library(grid)
DMresults <- calcCVperformance(DMresults, "sample error")
DDresults <- calcCVperformance(DDresults, "sample error")
resultsList <- list(Abundance = DMresults, Distribution = DDresults)
errorPlot <- samplesMetricMap(resultsList, metric = "error", xAxisLabel = "Sample",
                              showXtickLabels = FALSE, plot = FALSE)
grid.draw(errorPlot)

## -------------------------------------------------------------------------------------------------------------------------------
rankOverlaps <- rankingPlot(list(DDresults), topRanked = 1:100,
                            xLabelPositions = c(1, seq(10, 100, 10)),
                            lineColourVariable = "None", pointTypeVariable = "None",
                            columnVariable = "None", plot = FALSE)
rankOverlaps

## ---- fig.height = 5, fig.width = 6---------------------------------------------------------------------------------------------
ROCcurves <- ROCplot(list(DDresults), fontSizes = c(24, 12, 12, 12, 12))

## -------------------------------------------------------------------------------------------------------------------------------
selectParams <- SelectParams(differentMeansSelection, resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(SVMtrainInterface, kernel = "linear",
                           tuneParams = list(cost = c(0.01, 0.1, 1, 10)),
                           tuneOptimise = c(metric = "balanced error", better = "lower"))
predictParams <- PredictParams(SVMpredictInterface)
SVMresults <- runTests(measurements, classes, datasetName = "Asthma",
                       classificationName = "Tuned SVM", permutations = 20, folds = 5, seed = 2018,
                       params = list(selectParams, trainParams, predictParams)
                       )

## -------------------------------------------------------------------------------------------------------------------------------
length(tunedParameters(SVMresults))
tunedParameters(SVMresults)[[1]]

## -------------------------------------------------------------------------------------------------------------------------------
selectParams <- SelectParams(edgeRselection, resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(classifyInterface)
predictParams <- PredictParams(NULL)
params = list(selectParams, trainParams, predictParams)

## -------------------------------------------------------------------------------------------------------------------------------
transformParams <- TransformParams(subtractFromLocation, intermediate = "training",
                                   location = "median")
selectParams <- SelectParams(bartlettSelection,
                             resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(fisherDiscriminant)
predictParams <- PredictParams(NULL)
params = list(transformParams, selectParams, trainParams, predictParams)

## -------------------------------------------------------------------------------------------------------------------------------
selectParams <- SelectParams(KullbackLeiblerSelection,
                             resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(naiveBayesKernel)
predictParams <- PredictParams(NULL)
params = list(selectParams, trainParams, predictParams)

## -------------------------------------------------------------------------------------------------------------------------------
trainParams <- TrainParams(NSCtrainInterface)
selectParams <- SelectParams(NSCselectionInterface, intermediate = "trained")
predictParams <- PredictParams(NSCpredictInterface)
params = list(trainParams, selectParams, predictParams)

## -------------------------------------------------------------------------------------------------------------------------------
trainParams <- TrainParams(randomForestTrainInterface, ntree = 100, getFeatures = forestFeatures)
predictParams <- PredictParams(randomForestPredictInterface)
params = list(trainParams, predictParams)

## -------------------------------------------------------------------------------------------------------------------------------
selectParams <- SelectParams(differentMeansSelection, resubstituteParams = ResubstituteParams())
trainParams <- TrainParams(SVMtrainInterface, kernel = "linear")
predictParams <- PredictParams(SVMpredictInterface)
params = list(selectParams, trainParams, predictParams)

## ---- eval = FALSE--------------------------------------------------------------------------------------------------------------
#  resubstituteParams <- ResubstituteParams(nFeatures = 1:10, # The top 1 to 10 sub-networks.
#                        performanceType = "balanced error", better = "lower")
#  selectParams <- SelectParams(networkCorrelationsSelection, resubstituteParams = resubstituteParams)
#  trainParams <- TrainParams(naiveBayesKernel)
#  predictParams <- PredictParams(NULL)
#  params <- list(selectParams, trainParams, predictParams)
#  metaFeatures <- interactorDiffsTable # Creation by interactorDifferences function is suggested.
#  featureSets <- networkSets # An object of class FeatureSetCollection.

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("functionRules.png"), 
               style = 'margin-left: auto;margin-right: auto')

