## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  # fig.align = "center",
  comment = ">"
)

## ---- eval = FALSE------------------------------------------------------------
#  # install.packages("BiocManager")
#  BiocManager::install("POMA")

## ---- warning = FALSE, message = FALSE, comment = FALSE-----------------------
library(POMA)
library(MSnbase)
library(ggplot2)
library(patchwork)

## ---- warning = FALSE---------------------------------------------------------
# load example data
data("st000336")

# imputation using the default method KNN
example_data <- st000336 %>% PomaImpute()
example_data

## ---- warning = FALSE---------------------------------------------------------
none <- PomaNorm(example_data, method = "none")
auto_scaling <- PomaNorm(example_data, method = "auto_scaling")
level_scaling <- PomaNorm(example_data, method = "level_scaling")
log_scaling <- PomaNorm(example_data, method = "log_scaling")
log_transformation <- PomaNorm(example_data, method = "log_transformation")
vast_scaling <- PomaNorm(example_data, method = "vast_scaling")
log_pareto <- PomaNorm(example_data, method = "log_pareto")

## ---- warning = FALSE---------------------------------------------------------
dim(MSnbase::exprs(none))
dim(MSnbase::exprs(auto_scaling))
dim(MSnbase::exprs(level_scaling))
dim(MSnbase::exprs(log_scaling))
dim(MSnbase::exprs(log_transformation))
dim(MSnbase::exprs(vast_scaling))
dim(MSnbase::exprs(log_pareto))

## ---- message = FALSE, comment = FALSE, warning = FALSE-----------------------
a <- PomaBoxplots(none, group = "samples", jitter = FALSE) +
  ggtitle("Not Normalized")

b <- PomaBoxplots(auto_scaling, group = "samples", jitter = FALSE) +
  ggtitle("Auto Scaling") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

c <- PomaBoxplots(level_scaling, group = "samples", jitter = FALSE) +
  ggtitle("Level Scaling") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

d <- PomaBoxplots(log_scaling, group = "samples", jitter = FALSE) +
  ggtitle("Log Scaling") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

e <- PomaBoxplots(log_transformation, group = "samples", jitter = FALSE) +
  ggtitle("Log Transformation") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

f <- PomaBoxplots(vast_scaling, group = "samples", jitter = FALSE) +
  ggtitle("Vast Scaling") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

g <- PomaBoxplots(log_pareto, group = "samples", jitter = FALSE) +
  ggtitle("Log Pareto") +
  theme(axis.text.x = element_blank(),
        legend.position = "none")

a  
(b + c + d) / (e + f + g)

## ---- message = FALSE, comment = FALSE, warning = FALSE-----------------------
h <- PomaDensity(none, group = "features") +
  ggtitle("Not Normalized")

i <- PomaDensity(auto_scaling, group = "features") +
  ggtitle("Auto Scaling") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

j <- PomaDensity(level_scaling, group = "features") +
  ggtitle("Level Scaling") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

k <- PomaDensity(log_scaling, group = "features") +
  ggtitle("Log Scaling") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

l <- PomaDensity(log_transformation, group = "features") +
  ggtitle("Log Transformation") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

m <- PomaDensity(vast_scaling, group = "features") +
  ggtitle("Vast Scaling") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

n <- PomaDensity(log_pareto, group = "features") +
  ggtitle("Log Pareto") +
  theme(axis.title.x = element_blank(),
        axis.title.y = element_blank())

h  
(i + j + k) / (l + m + n)

## -----------------------------------------------------------------------------
sessionInfo()

