/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import java.io.FileInputStream;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.AsciiLineReader;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    protected final File file;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this.file = file;
        File dictionary = AbstractFastaSequenceFile.findSequenceDictionary(file);
        if (dictionary != null) {
            IoUtil.assertFileIsReadable(dictionary);
            try {
                SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                SAMFileHeader header = codec.decode(new AsciiLineReader(new FileInputStream(dictionary)), dictionary.toString());
                if (header.getSequenceDictionary() != null && header.getSequenceDictionary().size() > 0) {
                    this.sequenceDictionary = header.getSequenceDictionary();
                }
            }
            catch (Exception e) {
                throw new PicardException("Could not open sequence dictionary file: " + dictionary, e);
            }
        }
    }

    protected static File findSequenceDictionary(File file) {
        String dictionaryName = file.getAbsolutePath();
        boolean fileTypeSupported = false;
        for (String extension : ReferenceSequenceFileFactory.FASTA_EXTENSIONS) {
            if (!dictionaryName.endsWith(extension)) continue;
            dictionaryName = dictionaryName.substring(0, dictionaryName.lastIndexOf(extension));
            dictionaryName = dictionaryName + ".dict";
            fileTypeSupported = true;
            break;
        }
        if (!fileTypeSupported) {
            throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
        }
        File dictionary = new File(dictionaryName);
        if (dictionary.exists()) {
            return dictionary;
        }
        return null;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        throw new UnsupportedOperationException();
    }
}

