/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class mxEdgeHandler
extends mxCellHandler {
    protected boolean cloneEnabled = true;
    protected Point[] p;
    protected transient String error;
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected mxCellMarker marker = new mxCellMarker(this.graphComponent){
        private static final long serialVersionUID = 8826073441093831764L;

        protected Object getCell(MouseEvent mouseEvent) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
            Object object = super.getCell(mouseEvent);
            if (object == mxEdgeHandler.this.state.getCell() || !mxGraph2.isConnectableEdges() && mxIGraphModel2.isEdge(object)) {
                object = null;
            }
            return object;
        }

        protected boolean isValidState(mxCellState mxCellState2) {
            mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
            Object object = mxEdgeHandler.this.state.getCell();
            boolean bl = mxEdgeHandler.this.isSource(mxEdgeHandler.this.index);
            Object object2 = mxIGraphModel2.getTerminal(object, !bl);
            Object object3 = bl ? mxCellState2.getCell() : object2;
            Object object4 = bl ? object2 : mxCellState2.getCell();
            mxEdgeHandler.this.error = mxEdgeHandler.this.validateConnection(object3, object4);
            return mxEdgeHandler.this.error == null;
        }
    };

    public mxEdgeHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        super(mxGraphComponent2, mxCellState2);
    }

    public void setCloneEnabled(boolean bl) {
        this.cloneEnabled = bl;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    protected boolean isIgnoredEvent(MouseEvent mouseEvent) {
        return !this.isFlipEvent(mouseEvent) && super.isIgnoredEvent(mouseEvent);
    }

    protected boolean isFlipEvent(MouseEvent mouseEvent) {
        return false;
    }

    public String validateConnection(Object object, Object object2) {
        return this.graphComponent.getGraph().getEdgeValidationError(this.state.getCell(), object, object2);
    }

    public boolean isSource(int n) {
        return n == 0;
    }

    public boolean isTarget(int n) {
        return n == this.getHandleCount() - 2;
    }

    protected boolean isHandleVisible(int n) {
        return super.isHandleVisible(n) && (n != 1 || this.isCellBendable());
    }

    protected boolean isCellBendable() {
        return this.graphComponent.getGraph().isCellBendable(this.state.getCell());
    }

    protected Rectangle[] createHandles() {
        this.p = this.createPoints(this.state);
        Rectangle[] rectangleArray = new Rectangle[this.p.length + 1];
        for (int i = 0; i < rectangleArray.length - 1; ++i) {
            rectangleArray[i] = this.createHandle(this.p[i]);
        }
        rectangleArray[this.p.length] = this.createHandle(this.state.getAbsoluteOffset().getPoint(), mxConstants.LABEL_HANDLE_SIZE);
        return rectangleArray;
    }

    protected Color getHandleFillColor(int n) {
        mxGraph mxGraph2;
        Object object;
        boolean bl = this.isSource(n);
        if ((bl || this.isTarget(n)) && (object = (mxGraph2 = this.graphComponent.getGraph()).getModel().getTerminal(this.state.getCell(), bl)) != null) {
            return this.graphComponent.getGraph().isCellDisconnectable(this.state.getCell(), object, bl) ? mxConstants.CONNECT_HANDLE_FILLCOLOR : mxConstants.LOCKED_HANDLE_FILLCOLOR;
        }
        return super.getHandleFillColor(n);
    }

    public int getIndexAt(int n, int n2) {
        int n3 = super.getIndexAt(n, n2);
        if (n3 < 0 && this.handles != null && this.handlesVisible && this.isLabelMovable() && this.state.getLabelBounds().getRectangle().contains(n, n2)) {
            n3 = this.handles.length - 1;
        }
        return n3;
    }

    protected Rectangle createHandle(Point point) {
        return this.createHandle(point, mxConstants.HANDLE_SIZE);
    }

    protected Rectangle createHandle(Point point, int n) {
        return new Rectangle(point.x - n / 2, point.y - n / 2, n, n);
    }

    protected Point[] createPoints(mxCellState mxCellState2) {
        Point[] pointArray = new Point[mxCellState2.getAbsolutePointCount()];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = mxCellState2.getAbsolutePoint(i).getPoint();
        }
        return pointArray;
    }

    protected JComponent createPreview() {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -894546588972313020L;

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!mxEdgeHandler.this.isLabel(mxEdgeHandler.this.index) && mxEdgeHandler.this.p != null) {
                    ((Graphics2D)graphics).setStroke(mxConstants.PREVIEW_STROKE);
                    if (mxEdgeHandler.this.isSource(mxEdgeHandler.this.index) || mxEdgeHandler.this.isTarget(mxEdgeHandler.this.index)) {
                        if (mxEdgeHandler.this.marker.hasValidState() || mxEdgeHandler.this.graphComponent.getGraph().isAllowDanglingEdges()) {
                            graphics.setColor(mxConstants.DEFAULT_VALID_COLOR);
                        } else {
                            graphics.setColor(mxConstants.DEFAULT_INVALID_COLOR);
                        }
                    } else {
                        graphics.setColor(Color.BLACK);
                    }
                    Point point = this.getLocation();
                    Point point2 = mxEdgeHandler.this.p[0];
                    for (int i = 1; i < mxEdgeHandler.this.p.length; ++i) {
                        graphics.drawLine(point2.x - point.x, point2.y - point.y, mxEdgeHandler.this.p[i].x - point.x, mxEdgeHandler.this.p[i].y - point.y);
                        point2 = mxEdgeHandler.this.p[i];
                    }
                }
            }
        };
        if (this.isLabel(this.index)) {
            jPanel.setBorder(mxConstants.PREVIEW_BORDER);
        }
        jPanel.setOpaque(false);
        jPanel.setVisible(false);
        return jPanel;
    }

    protected mxPoint convertPoint(mxPoint mxPoint2, boolean bl) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        double d = mxGraph2.getView().getScale();
        mxPoint mxPoint3 = mxGraph2.getView().getTranslate();
        double d2 = mxPoint2.getX() / d - mxPoint3.getX();
        double d3 = mxPoint2.getY() / d - mxPoint3.getY();
        if (bl) {
            d2 = mxGraph2.snap(d2);
            d3 = mxGraph2.snap(d3);
        }
        mxPoint2.setX(d2 - this.state.getOrigin().getX());
        mxPoint2.setY(d3 - this.state.getOrigin().getY());
        return mxPoint2;
    }

    protected Rectangle getPreviewBounds() {
        Rectangle rectangle = null;
        if (this.isLabel(this.index)) {
            rectangle = this.state.getLabelBounds().getRectangle();
        } else {
            rectangle = new Rectangle(this.p[0]);
            for (int i = 0; i < this.p.length; ++i) {
                rectangle.add(this.p[i]);
            }
            ++rectangle.height;
            ++rectangle.width;
        }
        return rectangle;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.isSource(this.index) || this.isTarget(this.index)) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
            Object object = mxIGraphModel2.getTerminal(this.state.getCell(), this.isSource(this.index));
            if (!mxGraph2.isCellDisconnectable(this.state.getCell(), object, this.isSource(this.index))) {
                this.first = null;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.first != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            boolean bl = this.isSource(this.index);
            Object object = null;
            Object object2 = null;
            if (this.isLabel(this.index)) {
                mxPoint mxPoint2 = this.state.getAbsoluteOffset();
                double d = mxPoint2.getX() - (double)this.first.x;
                double d2 = mxPoint2.getY() - (double)this.first.y;
                mxPoint mxPoint3 = new mxPoint(mouseEvent.getPoint());
                if (this.gridEnabledEvent) {
                    mxPoint3 = this.graphComponent.snapScaledPoint(mxPoint3, d, d2);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                        mxPoint3.setY(mxPoint2.getY());
                    } else {
                        mxPoint3.setX(mxPoint2.getX());
                    }
                }
                Rectangle rectangle = this.getPreviewBounds();
                rectangle.translate((int)Math.round(mxPoint3.getX() - (double)this.first.x), (int)Math.round(mxPoint3.getY() - (double)this.first.y));
                this.preview.setBounds(rectangle);
            } else {
                mxGeometry mxGeometry2 = this.graphComponent.getGraph().getCellGeometry(this.state.getCell());
                mxCellState mxCellState2 = (mxCellState)this.state.clone();
                List<mxPoint> list = mxGeometry2.getPoints();
                if (bl || this.isTarget(this.index)) {
                    Object object3;
                    this.marker.process(mouseEvent);
                    mxCellState mxCellState3 = this.marker.getValidState();
                    object2 = mxCellState2.getView().getVisibleTerminal(this.state.getCell(), !bl);
                    if (mxCellState3 != null) {
                        object = mxCellState3.getCell();
                    } else {
                        object3 = new mxPoint(mouseEvent.getPoint());
                        if (this.gridEnabledEvent) {
                            object3 = this.graphComponent.snapScaledPoint((mxPoint)object3);
                        }
                        mxCellState2.setAbsoluteTerminalPoint((mxPoint)object3, bl);
                    }
                    if (!bl) {
                        object3 = object;
                        object = object2;
                        object2 = object3;
                    }
                } else {
                    mxPoint mxPoint4 = this.convertPoint(new mxPoint(mouseEvent.getPoint()), this.gridEnabledEvent);
                    if (list == null) {
                        list = Arrays.asList(mxPoint4);
                    } else if (this.index - 1 < list.size()) {
                        list = new ArrayList<mxPoint>(list);
                        list.set(this.index - 1, mxPoint4);
                    }
                    object = mxCellState2.getView().getVisibleTerminal(this.state.getCell(), true);
                    object2 = mxCellState2.getView().getVisibleTerminal(this.state.getCell(), false);
                }
                mxCellState2.getView().updatePoints(mxCellState2, list, object, object2);
                mxCellState2.getView().updateTerminalPoints(mxCellState2, object, object2);
                this.p = this.createPoints(mxCellState2);
                this.preview.setBounds(this.getPreviewBounds());
            }
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(mouseEvent.getX() - this.first.x, mouseEvent.getY() - this.first.y)) {
                this.preview.setVisible(true);
            } else if (this.preview.isVisible()) {
                this.preview.repaint();
            }
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        double d;
        double d2;
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        if (!mouseEvent.isConsumed() && this.first != null && this.graphComponent.isSignificant(d2 = (double)(mouseEvent.getX() - this.first.x), d = (double)(mouseEvent.getY() - this.first.y))) {
            if (this.error != null) {
                if (this.error.length() > 0) {
                    JOptionPane.showMessageDialog(this.graphComponent, this.error);
                }
            } else if (this.isLabel(this.index)) {
                mxPoint mxPoint2 = this.state.getAbsoluteOffset();
                d2 = mxPoint2.getX() - (double)this.first.x;
                d = mxPoint2.getY() - (double)this.first.y;
                mxPoint mxPoint3 = new mxPoint(mouseEvent.getPoint());
                if (this.gridEnabledEvent) {
                    mxPoint3 = this.graphComponent.snapScaledPoint(mxPoint3, d2, d);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                        mxPoint3.setY(mxPoint2.getY());
                    } else {
                        mxPoint3.setX(mxPoint2.getX());
                    }
                }
                this.moveLabelTo(this.state, mxPoint3.getX() + d2, mxPoint3.getY() + d);
            } else if (this.marker.hasValidState() && (this.isSource(this.index) || this.isTarget(this.index))) {
                this.connect(this.state.getCell(), this.marker.getValidState().getCell(), this.isSource(this.index), mouseEvent.isControlDown() && this.isCloneEnabled());
            } else if (!this.isSource(this.index) && !this.isTarget(this.index) || this.graphComponent.getGraph().isAllowDanglingEdges()) {
                this.movePoint(this.state.getCell(), this.index, this.convertPoint(new mxPoint(mouseEvent.getPoint()), this.gridEnabledEvent));
            }
            mouseEvent.consume();
        }
        if (!mouseEvent.isConsumed() && this.isFlipEvent(mouseEvent)) {
            mxGraph2.flipEdge(this.state.getCell());
            mouseEvent.consume();
        }
        this.marker.reset();
        this.error = null;
        super.mouseReleased(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void movePoint(Object object, int n, mxPoint mxPoint2) {
        mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            mxIGraphModel2.beginUpdate();
            try {
                mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                if (this.isSource(this.index) || this.isTarget(this.index)) {
                    this.connect(object, null, this.isSource(this.index), false);
                    mxGeometry2.setTerminalPoint(mxPoint2, this.isSource(this.index));
                } else {
                    List<mxPoint> list = mxGeometry2.getPoints();
                    if (list == null) {
                        list = new ArrayList<mxPoint>();
                        mxGeometry2.setPoints(list);
                    }
                    if (list != null) {
                        if (n <= list.size()) {
                            list.set(n - 1, mxPoint2);
                        } else if (n - 1 <= list.size()) {
                            list.add(n - 1, mxPoint2);
                        }
                    }
                }
                mxIGraphModel2.setGeometry(object, mxGeometry2);
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxIGraphModel2.beginUpdate();
        try {
            if (bl2) {
                Object object3 = mxGraph2.cloneCells(new Object[]{object})[0];
                Object object4 = mxIGraphModel2.getParent(object);
                mxGraph2.addCells(new Object[]{object3}, object4);
                Object object5 = mxIGraphModel2.getTerminal(object, !bl);
                mxGraph2.connectCell(object3, object5, !bl);
                mxGraph2.setSelectionCell(object3);
                object = object3;
            }
            mxGraph2.connectCell(object, object2, bl);
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
    }

    protected void moveLabelTo(mxCellState mxCellState2, double d, double d2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(this.state.getCell());
        if (mxGeometry2 != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxPoint mxPoint2 = mxGraph2.getView().getRelativePoint(mxCellState2, d, d2);
            mxGeometry2.setX(mxPoint2.getX());
            mxGeometry2.setY(mxPoint2.getY());
            double d3 = mxGraph2.getView().getScale();
            mxGeometry2.setOffset(new mxPoint(0.0, 0.0));
            mxPoint2 = mxGraph2.getView().getPoint(mxCellState2, mxGeometry2);
            mxGeometry2.setOffset(new mxPoint(Math.round((d - mxPoint2.getX()) / d3), Math.round((d2 - mxPoint2.getY()) / d3)));
            mxIGraphModel2.setGeometry(mxCellState2.getCell(), mxGeometry2);
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent, int n) {
        Cursor cursor = null;
        cursor = this.isSource(n) || this.isTarget(n) ? mxConnectionHandler.DEFAULT_CURSOR : (this.isLabel(n) ? new Cursor(13) : new Cursor(12));
        return cursor;
    }

    protected Color getSelectionColor() {
        return mxConstants.EDGE_SELECTION_COLOR;
    }

    protected Stroke getSelectionStroke() {
        return mxConstants.EDGE_SELECTION_STROKE;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.getSelectionStroke());
        graphics.setColor(this.getSelectionColor());
        Point point = this.state.getAbsolutePoint(0).getPoint();
        for (int i = 1; i < this.state.getAbsolutePointCount(); ++i) {
            Point point2 = this.state.getAbsolutePoint(i).getPoint();
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
        }
        graphics2D.setStroke(stroke);
        super.paint(graphics);
    }
}

