/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reder.application.MainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.NodeBank;

public class RedHandler {
    public int updateGraph() {
        MainFrame.updateGraph();
        return 1;
    }

    public int deSelectGraph() {
        this.deSelectNodes();
        this.deSelectEdges();
        return 1;
    }

    public int deSelectNodes() {
        MainFrame.methods.deSelectNodes();
        return 1;
    }

    public int deSelectEdges() {
        MainFrame.methods.deSelectEdges();
        return 1;
    }

    public int selectAllEdges() {
        MainFrame.methods.selectAllEdges();
        return 1;
    }

    public int selectAllNodes() {
        MainFrame.methods.selectAllNodes();
        return 1;
    }

    public int selectGraph() {
        MainFrame.methods.selectGraph();
        return 1;
    }

    public int selectEdges(String nodeA, String nodeB) {
        MainFrame.methods.selectEdge(nodeA, nodeB);
        return 1;
    }

    public int selectNodeString(String nodeA, String anchor, String nt) {
        if (nt.equals("")) {
            nt = null;
        }
        MainFrame.methods.zoomNodeFilter(nodeA, nt);
        return 1;
    }

    public int selectNodeVector(Vector<String> nodes, String anchor, String nt) {
        if (nt.equals("")) {
            nt = null;
        }
        int cont = 0;
        int sz = nodes.size();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = nodes.get(i);
            int test = MainFrame.methods.selectNode(strNodeID, nt, anchor.equals("true"));
            if (test != 1) continue;
            ++cont;
        }
        MainFrame.methods.taskHighlight();
        return cont;
    }

    public int speedTest(Vector<String> nono) {
        return 1;
    }

    public int addNodes(Vector<String> nodes) {
        int cont = 0;
        int sz = nodes.size();
        this.lockInteract();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = nodes.get(i);
            boolean flag = false;
            for (NodeBank a : MainFrame.NodeList) {
                if (!a.getNodeID().equals(strNodeID)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            int intNodeID = MainFrame.NodeList.size();
            MainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
            MainFrame.keyNodeHash.put(strNodeID, intNodeID);
            MainFrame.keyNodeArray.add(strNodeID);
            ++cont;
            Pattern pt = Pattern.compile("(.)*(\\<\\$\\$\\>)(.)*");
            Matcher mt = pt.matcher(strNodeID);
            if (!mt.matches()) continue;
            MainFrame.NodeList.get(MainFrame.NodeList.size() - 1).setAsMock();
        }
        this.unLockInteract();
        return cont;
    }

    public int addNodesNumeric(Vector<Double> nodes) {
        int cont = 0;
        int sz = nodes.size();
        this.lockInteract();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = Double.toString(nodes.get(i));
            boolean flag = false;
            for (NodeBank a : MainFrame.NodeList) {
                if (!a.getNodeID().equals(strNodeID)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            int intNodeID = MainFrame.NodeList.size();
            MainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
            MainFrame.keyNodeHash.put(strNodeID, intNodeID);
            MainFrame.keyNodeArray.add(strNodeID);
            ++cont;
        }
        this.unLockInteract();
        return cont;
    }

    public int addNodes(String node) {
        String strNodeID = node;
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(strNodeID)) continue;
            return 0;
        }
        int intNodeID = MainFrame.NodeList.size();
        MainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
        MainFrame.keyNodeHash.put(strNodeID, intNodeID);
        MainFrame.keyNodeArray.add(strNodeID);
        return 1;
    }

    public int addNodesNumeric(double node) {
        String strNodeID = Double.toString(node);
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(strNodeID)) continue;
            return 0;
        }
        int intNodeID = MainFrame.NodeList.size();
        MainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
        MainFrame.keyNodeHash.put(strNodeID, intNodeID);
        MainFrame.keyNodeArray.add(strNodeID);
        return 1;
    }

    public int assignTree() {
        MainFrame.methods.assignTreePermanently();
        return 1;
    }

    public String nestpackexpress(Vector<String> nodes, Vector<String> status, Vector<String> charAtt, Vector<Double> numAtt, Vector<Double> nestmap) {
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int v4 = 0;
        for (int i = 0; i < nestmap.size(); ++i) {
            int j;
            Vector<String> unpacknodes = new Vector<String>();
            Vector<String> unpackstatus = new Vector<String>();
            Vector<String> unpackcharAtt = new Vector<String>();
            Vector<Double> unpacknumAtt = new Vector<Double>();
            unpacknodes.clear();
            unpackstatus.clear();
            unpackcharAtt.clear();
            unpacknumAtt.clear();
            double nn = nestmap.get(i);
            for (j = 0; j < (int)nn; ++j) {
                unpacknodes.add(nodes.get(v1));
                ++v1;
            }
            for (j = 0; j < 3; ++j) {
                unpackstatus.add(status.get(v2));
                ++v2;
            }
            for (j = 0; j < 6; ++j) {
                unpackcharAtt.add(charAtt.get(v3));
                ++v3;
            }
            for (j = 0; j < 8; ++j) {
                unpacknumAtt.add(numAtt.get(v4));
                ++v4;
            }
            this.nestexpress(unpacknodes, unpackstatus, unpackcharAtt, unpacknumAtt);
        }
        return "Done!";
    }

    public String nestexpress(Vector<String> nodes, Vector<String> status, Vector<String> charAtt, Vector<Double> numAtt) {
        String status1 = status.get(0);
        String status2 = status.get(1);
        String status3 = status.get(2);
        String retorno = this.nestNodes(nodes, status1, status2, status3, charAtt, numAtt);
        return retorno;
    }

    public String nestNodes(Vector<String> nodes, String status1, String status2, String status3, Vector<String> charAtt, Vector<Double> numAtt) {
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        MainFrame.methods.stopDynamics();
        block6: for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = MainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                listaMarcados.add(j);
                continue block6;
            }
        }
        String retorno = "Done!";
        if (listaMarcados.size() > 0) {
            boolean setHide = false;
            boolean setTransparency = false;
            boolean setAnchor = false;
            boolean setAssigned = false;
            if (status1 != null) {
                if (status1.equals("hide")) {
                    setHide = true;
                    setAnchor = true;
                } else if (status1.equals("transparent")) {
                    setTransparency = true;
                } else if (status1.equals("plain")) {
                    setHide = false;
                    setTransparency = false;
                }
            }
            if (status2 != null && status2.equals("anchor")) {
                setAnchor = true;
            }
            if (status3 != null && status3.equals("assign")) {
                setAssigned = true;
            }
            if (!(retorno = MainFrame.methods.aninhar(listaMarcados, new Color(204, 204, 255), setHide, setTransparency, setAnchor, setAssigned)).contains("inconsistent")) {
                int cId = (Integer)MainFrame.keyNodeHash.get(retorno);
                NodeBank cAccount = MainFrame.NodeList.get(cId);
                for (int i = 0; i < charAtt.size(); ++i) {
                    Color attc2;
                    String att = charAtt.get(i);
                    if (att.contains("<$$>") || att == null) continue;
                    if (i == 0) {
                        cAccount.setAliases(att);
                    }
                    if (i == 1) {
                        cAccount.setNodeShape(att);
                    }
                    if (i == 2) {
                        cAccount.setNodeLineType(att);
                    }
                    if (i == 3) {
                        try {
                            attc2 = Color.decode(att);
                            cAccount.setNodeColor(attc2);
                        }
                        catch (NumberFormatException attc2) {
                            // empty catch block
                        }
                    }
                    if (i == 4) {
                        try {
                            attc2 = Color.decode(att);
                            cAccount.setNodeLineColor(attc2);
                        }
                        catch (NumberFormatException attc3) {
                            // empty catch block
                        }
                    }
                    if (i != 5) continue;
                    try {
                        attc2 = Color.decode(att);
                        cAccount.setFontColor(attc2);
                        continue;
                    }
                    catch (NumberFormatException attc4) {
                        // empty catch block
                    }
                }
                double xtree = 909192.0;
                double ytree = 909192.0;
                for (int i = 0; i < numAtt.size(); ++i) {
                    int rt;
                    double natt = numAtt.get(i);
                    if (i == 0) {
                        cAccount.setFontX((float)natt);
                    }
                    if (i == 1) {
                        cAccount.setFontY((float)natt);
                    }
                    if (i == 2 && natt >= 0.0) {
                        cAccount.setFontSize((int)natt);
                    }
                    if (i == 3 && natt >= 0.0) {
                        cAccount.setNodeLineWidth((float)natt);
                    }
                    if (i == 4 && natt > 0.0) {
                        cAccount.setNodeSize((float)natt / 20.0f);
                        cAccount.updateContent();
                    } else if (i == 5 && natt > 0.0) {
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            float rtsz = MainFrame.NodeList.get(rt).getNodeSize();
                            natt = natt / 100.0 * (double)rtsz;
                            cAccount.setNodeSize((float)natt);
                        } else {
                            double zz = MainFrame.getZoom();
                            double hh = MainFrame.getSmallViewArea().getHeight();
                            double ww = MainFrame.getSmallViewArea().getWidth();
                            float rtsz = (float)(Math.min(hh, ww) / 20.0 / zz);
                            natt = natt / 100.0 * (double)rtsz;
                            cAccount.setNodeSize((float)natt);
                        }
                        cAccount.updateContent();
                    }
                    if (i == 6 && natt != 909192.0) {
                        double nw;
                        double nx;
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            nx = MainFrame.NodeList.get(rt).getX();
                            nw = (double)MainFrame.NodeList.get(rt).getW() * MainFrame.getZoom();
                            xtree = nx - nw / 2.0 + natt / 100.0 * nw;
                        } else {
                            nx = MainFrame.getCentroX();
                            nw = MainFrame.drawpanel.getWidth();
                            xtree = nx - nw / 2.0 + natt / 100.0 * nw;
                        }
                    } else if (i == 7 && natt != 909192.0) {
                        double nh;
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            double ny = MainFrame.NodeList.get(rt).getY();
                            nh = (double)MainFrame.NodeList.get(rt).getH() * MainFrame.getZoom();
                            ytree = ny - nh / 2.0 + natt / 100.0 * nh;
                        } else {
                            double ny = MainFrame.getCentroY();
                            nh = MainFrame.drawpanel.getHeight();
                            ytree = ny - nh / 2.0 + natt / 100.0 * nh;
                        }
                    }
                    if (xtree == 909192.0 || ytree == 909192.0) continue;
                    cAccount.moveTree((float)xtree, (float)ytree);
                }
            }
        } else {
            retorno = "Your request is inconsistent with the hierarchy (or null)!";
        }
        return retorno;
    }

    public int updateContainerSize() {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            boolean c2;
            NodeBank nodeAccount = MainFrame.NodeList.get(i);
            boolean c1 = nodeAccount.isContainer();
            boolean bl = c2 = nodeAccount.getContainerComponents().size() > 0;
            if (!(c1 & c2)) continue;
            nodeAccount.updateContainer();
        }
        return 1;
    }

    public int mergeContainerOutEdges(Vector<String> containers, String rescale) {
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        block0: for (int i = 0; i < containers.size(); ++i) {
            for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
                NodeBank containerAccount = MainFrame.NodeList.get(j);
                if (!containerAccount.isContainer() || !containerAccount.getNodeID().equals(containers.get(i))) continue;
                listaMarcados.add(j);
                continue block0;
            }
        }
        if (listaMarcados.size() > 0) {
            MainFrame.methods.mergeContainerOutEdges(listaMarcados);
            if (rescale.equals("true")) {
                MainFrame.methods.correctOutEdgeWidth(0.75);
            }
            return 1;
        }
        return 0;
    }

    public int mergeContainerOutEdges(String rescale, Double customBotSz, Double customTopSz) {
        boolean isCustomBT;
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = MainFrame.NodeList.get(i);
            if (!nodeAccount.isContainer()) continue;
            listaMarcados.add(i);
        }
        boolean bl = isCustomBT = customBotSz >= 0.0 && customBotSz < customTopSz;
        if (listaMarcados.size() > 0) {
            MainFrame.methods.mergeContainerOutEdges(listaMarcados);
            if (rescale.equals("true") && !isCustomBT) {
                MainFrame.methods.correctOutEdgeWidth(0.75);
            } else if (isCustomBT) {
                MainFrame.methods.correctOutEdgeWidth(customBotSz, customTopSz);
            }
            this.updateGraph();
            return 1;
        }
        return 0;
    }

    public ArrayList<String> getContainerComponets(String ref) {
        ArrayList<String> array = new ArrayList<String>();
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(ref)) continue;
            for (Integer b : a.getContainerComponents()) {
                array.add(MainFrame.NodeList.get(b).getNodeID());
            }
            return array;
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public String mergeNodes(Vector<String> nodes) {
        for (NodeBank a : MainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        boolean flag = false;
        String aviso = "Done!";
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = MainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                if (!flag && (nodeAccount.isNodeNested() || nodeAccount.isContainer())) {
                    flag = true;
                    aviso = "Groups can no be created with nested objects!";
                    break;
                }
                listaMarcados.add(j);
                nodeAccount.setDestaque(true);
                break;
            }
            if (flag) break;
        }
        if (listaMarcados.size() > 1 && !flag) {
            MainFrame.methods.combinar(listaMarcados, new Color(255, 102, 102));
        }
        listaMarcados.clear();
        return aviso;
    }

    public int deleteNodes(Vector<String> nodes) {
        for (NodeBank a : MainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList listaMarcados = new ArrayList();
        listaMarcados.clear();
        int cont = 0;
        block1: for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = MainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                nodeAccount.setDestaque(true);
                ++cont;
                continue block1;
            }
        }
        MainFrame.methods.globalActionDeleteNode();
        return cont;
    }

    public int deleteNodes(String node) {
        for (NodeBank a : MainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList listaMarcados = new ArrayList();
        listaMarcados.clear();
        int cont = 0;
        for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
            NodeBank nodeAccount = MainFrame.NodeList.get(j);
            if (!nodeAccount.getNodeID().equals(node)) continue;
            nodeAccount.setDestaque(true);
            ++cont;
            break;
        }
        MainFrame.methods.globalActionDeleteNode();
        return cont;
    }

    public int deleteSelectedNodes() {
        MainFrame.methods.globalActionDeleteNode();
        return 1;
    }

    public double getPanelScale() {
        double hh = MainFrame.getSmallViewArea().getHeight();
        double ww = MainFrame.getSmallViewArea().getWidth();
        double scale = Math.min(hh, ww) / MainFrame.getZoom();
        return scale;
    }

    public double getZoom() {
        double scale = MainFrame.getZoom() * 100.0;
        return scale;
    }

    public ArrayList<String> getNodes(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeID());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getNodeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFinalID());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getNodeStackPosition(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = MainFrame.NodeList.get(i);
            if (!type.equals("node") ? type.equals("container") && !nodeAccount.isContainer() : nodeAccount.isContainer()) continue;
            if (status.equals("selected") ? !nodeAccount.getDestaque() : status.equals("nonselected") && nodeAccount.getDestaque()) continue;
            array.add(i);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<String> getNodeAliases(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getAliases());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeAlias(double id, String att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setAliases(att);
            return 1;
        }
        return 0;
    }

    public int setNodeAlias(String id, String att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setAliases(att);
            return 1;
        }
        return 0;
    }

    public int setNodeAlias(Vector<String> node, Vector<String> att) {
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeAlias(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeX(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        MainFrame.methods.zeraZoom();
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getXtoSave()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeY(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        MainFrame.methods.zeraZoom();
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getYtoSave()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeXY(String id, double x, double y) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNode((float)x, (float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeXY(double id, double x, double y) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNode((float)x, (float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeXY(Vector<String> node, Vector<Double> x, Vector<Double> y) {
        boolean c3;
        boolean c1 = node.size() != x.size();
        boolean c2 = node.size() != y.size();
        boolean bl = c3 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2 || c3) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeXY(node.get(i), (double)x.get(i), (double)y.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeW(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getW()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeH(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getH()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeBend(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeBend()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeBend(double id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeBend((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeBend(String id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeBend((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeBend(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeBend(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeSize(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeSize() * 20.0f));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeSize(double id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeSize((float)att / 20.0f);
            return 1;
        }
        return 0;
    }

    public int setNodeSize(String id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeSize((float)att / 20.0f);
            return 1;
        }
        return 0;
    }

    public int setNodeSize(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeSize(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeShape(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeShape());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeShape(double id, String att) {
        boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeShape(att);
            return 1;
        }
        return 0;
    }

    public int setNodeShape(String id, String att) {
        boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeShape(att);
            return 1;
        }
        return 0;
    }

    public int setNodeShape(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeShape(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeLineType(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeLineType());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineType(double id, String att) {
        boolean b = Pattern.matches("SOLID|DOTTED_SHORT|LONG_DASH|DOTTED", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineType(att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineType(String id, String att) {
        boolean b = Pattern.matches("SOLID|DOTTED_SHORT|LONG_DASH|DOTTED", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineType(att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineType(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeLineType(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getNodeColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeColor(double id, String att) {
        Color attc = new Color(255, 102, 102);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeColor(String id, String att) {
        Color attc = new Color(255, 102, 102);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeColor(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeLineWidth(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeLineWidth()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineWidth(double id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineWidth(String id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineWidth(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            if (att.get(i) < 0.0) continue;
            this.setNodeLineWidth(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeLineColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getNodeLineColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineColor(double id, String att) {
        Color attc = new Color(255, 0, 0);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeLineColor(String id, String att) {
        Color attc = new Color(255, 0, 0);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeLineColor(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeLineColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeFontName(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getFontName());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontName(double id, String att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            Font font = new Font(att, a.getFont().getStyle(), a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontName(String id, String att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            Font font = new Font(att, a.getFont().getStyle(), a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontName(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontName(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Integer> getNodeFontStyle(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getStyle());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontStyle(double id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            Font font = new Font(a.getFont().getName(), (int)att, a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontStyle(String id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            Font font = new Font(a.getFont().getName(), (int)att, a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontStyle(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontStyle(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<Integer> getNodeFontSize(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getSize());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontSize(double id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setFontSize((int)att);
            return 1;
        }
        return 0;
    }

    public int setNodeFontSize(String id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontSize((int)att);
            return 1;
        }
        return 0;
    }

    public int setNodeFontSize(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            if (att.get(i) < 0.0) continue;
            this.setNodeFontSize(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeFontColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getNodeFontColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontColor(double id, String att) {
        Color attc = new Color(51, 51, 51);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setFontColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeFontColor(String id, String att) {
        Color attc = new Color(51, 51, 51);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeFontColor(Vector<String> node, Vector<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeFontX(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getFontX()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeFontY(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getFontY()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontXY(int id, double x, double y) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != id) continue;
            a.setFontX((float)x);
            a.setFontY((float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeFontXY(String id, double x, double y) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontX((float)x);
            a.setFontY((float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeFontXY(Vector<String> node, Vector<Double> x, Vector<Double> y) {
        boolean c3;
        boolean c1 = node.size() != x.size();
        boolean c2 = node.size() != y.size();
        boolean bl = c3 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2 || c3) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontXY(node.get(i), (double)x.get(i), (double)y.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeWeight(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : MainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeWeight());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeWeight(int id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (a.getFinalID() != id) continue;
            a.setNodeWeight(att);
            return 1;
        }
        return 0;
    }

    public int setNodeWeight(String id, double att) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeWeight(att);
            return 1;
        }
        return 0;
    }

    public int setNodeWeight(Vector<String> node, Vector<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > MainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeWeight(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public int addEdgesFastload(Vector<String> nodesA, Vector<String> nodesB) {
        boolean c = nodesA.size() == nodesB.size();
        this.lockInteract();
        if (c) {
            int size = nodesA.size();
            ArrayList<EdgeBank> localList = new ArrayList<EdgeBank>();
            int cont = 0;
            for (int i = 0; i < size; ++i) {
                int numeroB;
                String nodeA = nodesA.get(i);
                String nodeB = nodesB.get(i);
                int numeroA = (Integer)MainFrame.keyNodeHash.get(nodeA);
                if (numeroA == (numeroB = ((Integer)MainFrame.keyNodeHash.get(nodeB)).intValue())) continue;
                boolean flagFound = false;
                for (EdgeBank a : MainFrame.EdgeList) {
                    if ((a.getA() != numeroA || a.getB() != numeroB) && (a.getA() != numeroB || a.getB() != numeroA)) continue;
                    flagFound = true;
                    break;
                }
                if (flagFound) continue;
                int ordId = MainFrame.EdgeList.size() + localList.size();
                localList.add(new EdgeBank(numeroA, numeroB, ordId));
                ++cont;
            }
            if (cont > 0) {
                MainFrame.EdgeList.addAll(localList);
                MainFrame.methods.updateBanks();
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdgesFastload(Vector<String> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            ArrayList<EdgeBank> localList = new ArrayList<EdgeBank>();
            int cont = 0;
            for (int i = 0; i < edges.size(); i += 2) {
                int numeroB;
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                int numeroA = (Integer)MainFrame.keyNodeHash.get(nodeA);
                if (numeroA == (numeroB = ((Integer)MainFrame.keyNodeHash.get(nodeB)).intValue())) continue;
                boolean flagFound = false;
                for (EdgeBank a : MainFrame.EdgeList) {
                    if ((a.getA() != numeroA || a.getB() != numeroB) && (a.getA() != numeroB || a.getB() != numeroA)) continue;
                    flagFound = true;
                    break;
                }
                if (flagFound) continue;
                int ordId = MainFrame.EdgeList.size() + localList.size();
                localList.add(new EdgeBank(numeroA, numeroB, ordId));
                ++cont;
            }
            if (cont > 0) {
                MainFrame.EdgeList.addAll(localList);
                MainFrame.methods.updateBanks();
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdges(Vector<String> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                MainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdges(String nodeA, String nodeB) {
        MainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
        return 1;
    }

    public int addEdgesNumeric(double nodeA, double nodeB) {
        String na = Double.toString(nodeA);
        String nb = Double.toString(nodeB);
        MainFrame.methods.addEdgesAndNodes(na, nb, true);
        return 1;
    }

    public int addEdgesNumeric(Vector<Double> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = Double.toString(edges.get(i));
                String nodeB = Double.toString(edges.get(i + 1));
                MainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdgeBetweenContainers(String containerA, String containerB) {
        boolean c1 = MainFrame.keyNodeHash.containsKey(containerA);
        boolean c2 = MainFrame.keyNodeHash.containsKey(containerB);
        if (c1 && c2) {
            MainFrame.methods.addEdgesAndNodes(containerA, containerB, false);
            return 1;
        }
        return 0;
    }

    public int deleteEdges(String nodeA, String nodeB) {
        MainFrame.methods.deSelectEdges();
        MainFrame.methods.selectEdge(nodeA, nodeB);
        this.deleteSelectedEdges();
        return 1;
    }

    public int deleteEdges(Vector<String> edges) {
        MainFrame.methods.deSelectEdges();
        float t1 = edges.size();
        float t2 = Math.round(t1 / 2.0f);
        boolean c = t1 == t2 * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                MainFrame.methods.selectEdge(nodeA, nodeB);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.deleteSelectedEdges();
        this.unLockInteract();
        return 1;
    }

    public int deleteSelectedEdges() {
        MainFrame.methods.deleteSelectedEdges();
        return 1;
    }

    public ArrayList<String> getEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                boolean bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                boolean bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeA = MainFrame.NodeList.get(a.getA()).getNodeID();
            String nodeB = MainFrame.NodeList.get(a.getB()).getNodeID();
            array.add(nodeA);
            array.add(nodeB);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getA());
            array.add(a.getB());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<String> getSourceEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeA = MainFrame.NodeList.get(a.getA()).getNodeID();
            array.add(nodeA);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getSourceEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getA());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<String> getTargetEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeB = MainFrame.NodeList.get(a.getB()).getNodeID();
            array.add(nodeB);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getTargetEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getB());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getArrowDirection(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getArrowDirection());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setArrowDirection(String nodeA, String nodeB, double att) {
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setArrowDirection((int)att);
            return 1;
        }
        return 0;
    }

    public int setArrowDirection(Vector<String> nodeA, Vector<String> nodeB, Vector<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setArrowDirection(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getEdgeWidth(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(Double.valueOf(a.getWidth()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeWidth(String nodeA, String nodeB, double att) {
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setEdgeWidth(Vector<String> nodeA, Vector<String> nodeB, Vector<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeWidth(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getEdgeColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String s = String.format("#%06X", 0xFFFFFF & a.getEdgeColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeColor(String nodeA, String nodeB, String att) {
        Color attc = new Color(153, 153, 255);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setColor(attc);
            return 1;
        }
        return 0;
    }

    public int setEdgeColor(Vector<String> nodeA, Vector<String> nodeB, Vector<String> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeColor(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getEdgeType(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getType());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeType(String nodeA, String nodeB, String att) {
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setLine(att);
            return 1;
        }
        return 0;
    }

    public int setEdgeType(Vector<String> nodeA, Vector<String> nodeB, Vector<String> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeType(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getEdgeWeight(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = MainFrame.NodeList.get(a.getA()).getDestaque();
                bb = MainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getMeanWeight());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeWeight(String nodeA, String nodeB, double att) {
        for (EdgeBank a : MainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setEdgeWeight(att);
            return 1;
        }
        return 0;
    }

    public int setEdgeWeight(Vector<String> nodeA, Vector<String> nodeB, Vector<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeWeight(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public int setDynamics(double edgeTarget, double stiffness, double repelFactor, double perimeterEffect, double nodeSpeedLimit, double outedgeTarget, double outRepelFactor, double repulserad, double coolingFactor, double ps) {
        if (ps == 1.0) {
            MainFrame.methods.setPanelSettingsOn(true);
        } else {
            MainFrame.methods.setPanelSettingsOn(false);
        }
        MainFrame.methods.setRelaxArgs(edgeTarget, stiffness, repelFactor, perimeterEffect, nodeSpeedLimit, outedgeTarget, outRepelFactor, repulserad, coolingFactor);
        MainFrame.methods.resetCooling();
        MainFrame.methods.deSelectEdges();
        MainFrame.methods.startDynamics();
        return 1;
    }

    public int stopPaint() {
        MainFrame.methods.stopPaint();
        return 1;
    }

    public int startPaint() {
        MainFrame.methods.startPaint();
        return 1;
    }

    public int isDynamicsActive() {
        if (MainFrame.methods.isRelaxActive()) {
            return 1;
        }
        return 0;
    }

    public int stopDynamics() {
        MainFrame.methods.stopDynamics();
        return 1;
    }

    public int ping() {
        return 1;
    }

    public String version() {
        return "RedeR_Java_Interface_V2.4";
    }

    public String updateGraphMap(Vector<String> nodesA, Vector<String> nodesB, Vector<Double> arrowDirection, Vector<Double> edgeWeight, Vector<Double> edgeWidth, Vector<String> edgeColor, Vector<String> edgeType, Vector<Double> arrowLength, Vector<Double> arrowAngle, Vector<String> linkType, Vector<String> nodes, Vector<Double> x, Vector<Double> y, Vector<Double> nodeBend, Vector<Double> nodeSize, Vector<String> nodeShape, Vector<String> nodeColor, Vector<Double> nodeWeight, Vector<Double> nodeLineWidth, Vector<String> nodeLineColor, Vector<Double> nodeFontSize, Vector<String> nodeFontColor, Vector<String> nodeAlias, Vector<Double> numSupplements, Vector<String> charSupplements, Vector<String> np1, Vector<String> np2, Vector<String> np3, Vector<Double> np4, String isnp, String parentname, String ntransform) {
        String dotransform = "no";
        if (ntransform.equals("true")) {
            dotransform = "yes";
        }
        this.updateNodeMap(nodes, x, y, nodeBend, nodeSize, nodeShape, nodeColor, nodeWeight, nodeLineWidth, nodeLineColor, nodeFontSize, nodeFontColor, nodeAlias, numSupplements, charSupplements, np1, np2, np3, np4, "no", ".$null", dotransform);
        this.updateEdgeMap(nodesA, nodesB, arrowDirection, edgeWeight, edgeWidth, edgeColor, edgeType, arrowLength, arrowAngle, linkType, charSupplements, dotransform);
        if (dotransform.equals("yes")) {
            this.doTransform(np2);
        }
        if (!parentname.equals(".$null")) {
            MainFrame.methods.reAssigments(parentname, nodes, true);
        }
        String retorno = "1";
        if (isnp.equals("true")) {
            retorno = this.nestexpress(np1, np2, np3, np4);
        }
        return retorno;
    }

    public void doTransform(Vector<String> status) {
        String status1 = status.get(0);
        String status2 = status.get(1);
        String status3 = status.get(2);
        boolean setHide = false;
        boolean setTransparency = false;
        boolean setAnchor = false;
        boolean setAssigned = false;
        if (status1 != null) {
            if (status1.equals("hide")) {
                setHide = true;
                setAnchor = true;
            } else if (status1.equals("transparent")) {
                setTransparency = true;
            } else if (status1.equals("plain")) {
                setHide = false;
                setTransparency = false;
            }
        }
        if (status2 != null && status2.equals("anchor")) {
            setAnchor = true;
        }
        if (status3 != null && status3.equals("assign")) {
            setAssigned = true;
        }
        MainFrame.methods.updateNodeTransform(setHide, setTransparency, setAnchor, setAssigned);
    }

    public String updateNodeMap(Vector<String> nodes, Vector<Double> x, Vector<Double> y, Vector<Double> nodeBend, Vector<Double> nodeSize, Vector<String> nodeShape, Vector<String> nodeColor, Vector<Double> nodeWeight, Vector<Double> nodeLineWidth, Vector<String> nodeLineColor, Vector<Double> nodeFontSize, Vector<String> nodeFontColor, Vector<String> nodeAlias, Vector<Double> numSupplements, Vector<String> charSupplements, Vector<String> np1, Vector<String> np2, Vector<String> np3, Vector<Double> np4, String isnp, String parentname, String ntransform) {
        int i;
        double gX = 0.0;
        double gY = 0.0;
        try {
            gX = numSupplements.get(0);
            gY = numSupplements.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String isCoordUpdate = "default";
        boolean isBrandNew = false;
        try {
            isCoordUpdate = charSupplements.get(0);
            if (charSupplements.get(1).equals("true")) {
                isBrandNew = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<Integer> nodeMap = new Vector<Integer>();
        nodeMap.clear();
        boolean isExhaustive = MainFrame.NodeList.size() > 0 && !isBrandNew;
        int sz = nodes.size();
        for (int i2 = 0; i2 < sz; ++i2) {
            String nd = nodes.get(i2);
            int nId = this.nodeMap(nd, isExhaustive);
            nodeMap.add(nId);
        }
        if (nodeMap.size() != sz || nodeMap.size() > MainFrame.NodeList.size()) {
            return "0";
        }
        this.lockInteract();
        MainFrame.methods.stopDynamics();
        boolean flagcoord = false;
        Point2D[] pontos = new Point2D[sz];
        if (x != null && y != null && isCoordUpdate.equals("default") && x.size() == sz && y.size() == sz) {
            for (i = 0; i < nodeMap.size(); ++i) {
                pontos[i] = new Point2D.Double(x.get(i), y.get(i));
            }
            pontos = MainFrame.methods.redoZoomScaleFromR(pontos);
            pontos = MainFrame.methods.setCenterFromR(pontos, gX, gY);
            this.deSelectGraph();
            flagcoord = true;
        }
        for (i = 0; i < nodeMap.size(); ++i) {
            boolean flag;
            int id;
            if (ntransform.equals("true") || ntransform.equals("yes")) {
                id = (Integer)nodeMap.get(i);
                MainFrame.NodeList.get(id).setTransformed(true);
            }
            if (flagcoord) {
                float xin = (float)pontos[i].getX();
                float yin = (float)pontos[i].getY();
                int id2 = (Integer)nodeMap.get(i);
                MainFrame.NodeList.get(id2).setNode(xin, yin);
                MainFrame.NodeList.get(id2).setDestaque(true);
            }
            if (nodeBend != null && nodeBend.size() == sz) {
                id = (Integer)nodeMap.get(i);
                double attin = nodeBend.get(i);
                if (attin >= 0.0 && attin <= 100.0) {
                    MainFrame.NodeList.get(id).setNodeBend((float)attin);
                }
            }
            if (nodeSize != null && nodeSize.size() == sz) {
                id = (Integer)nodeMap.get(i);
                double attin = nodeSize.get(i);
                if (attin >= 0.0) {
                    MainFrame.NodeList.get(id).setNodeSize((float)attin / 20.0f);
                }
            }
            if (nodeShape != null && nodeShape.size() == sz) {
                id = (Integer)nodeMap.get(i);
                String attin = nodeShape.get(i);
                boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", attin);
                if (b) {
                    MainFrame.NodeList.get(id).setNodeShape(attin);
                }
            }
            if (nodeColor != null && nodeColor.size() == sz) {
                id = (Integer)nodeMap.get(i);
                String attin = nodeColor.get(i);
                Color attc = new Color(255, 102, 102);
                flag = true;
                try {
                    attc = Color.decode(attin);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    MainFrame.NodeList.get(id).setNodeColor(attc);
                }
            }
            if (nodeWeight != null && nodeWeight.size() == sz) {
                id = (Integer)nodeMap.get(i);
                double attin = nodeWeight.get(i);
                MainFrame.NodeList.get(id).setWeight(attin);
            }
            if (nodeLineWidth != null && nodeLineWidth.size() == sz) {
                id = (Integer)nodeMap.get(i);
                double attin = nodeLineWidth.get(i);
                if (attin >= 0.0) {
                    MainFrame.NodeList.get(id).setNodeLineWidth((float)attin);
                }
            }
            if (nodeLineColor != null && nodeLineColor.size() == sz) {
                id = (Integer)nodeMap.get(i);
                String attin = nodeLineColor.get(i);
                Color attc = new Color(255, 0, 0);
                flag = true;
                try {
                    attc = Color.decode(attin);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    MainFrame.NodeList.get(id).setNodeLineColor(attc);
                }
            }
            if (nodeFontSize != null && nodeFontSize.size() == sz) {
                id = (Integer)nodeMap.get(i);
                double attin = nodeFontSize.get(i);
                if (attin >= 0.0) {
                    MainFrame.NodeList.get(id).setFontSize((int)attin);
                }
            }
            if (nodeFontColor != null && nodeFontColor.size() == sz) {
                id = (Integer)nodeMap.get(i);
                String attin = nodeFontColor.get(i);
                Color attc = new Color(51, 51, 51);
                flag = true;
                try {
                    attc = Color.decode(attin);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    MainFrame.NodeList.get(id).setFontColor(attc);
                }
            }
            if (nodeAlias == null || nodeAlias.size() != sz) continue;
            id = (Integer)nodeMap.get(i);
            String attin = nodeAlias.get(i);
            MainFrame.NodeList.get(id).setAliases(attin);
        }
        this.removeMockNodes();
        if (ntransform.equals("true")) {
            this.doTransform(np2);
        }
        if (!parentname.equals(".$null")) {
            MainFrame.methods.reAssigments(parentname, nodes, true);
        }
        String retorno = "1";
        if (isnp.equals("true")) {
            retorno = this.nestexpress(np1, np2, np3, np4);
        }
        this.unLockInteract();
        return retorno;
    }

    private int nodeMap(String node, boolean isExhaustive) {
        NodeBank nd;
        if (isExhaustive) {
            int sz = MainFrame.NodeList.size();
            for (int i = 0; i < sz; ++i) {
                nd = MainFrame.NodeList.get(i);
                String nodex = nd.getNodeID();
                if (!nodex.equals(node)) continue;
                return i;
            }
        }
        int intNodeID = MainFrame.NodeList.size();
        MainFrame.NodeList.add(new NodeBank(node, intNodeID));
        MainFrame.keyNodeHash.put(node, intNodeID);
        MainFrame.keyNodeArray.add(node);
        int newnd = MainFrame.NodeList.size() - 1;
        nd = MainFrame.NodeList.get(newnd);
        Pattern pt = Pattern.compile("(.)*(\\<\\$\\$\\>)(.)*");
        Matcher mt = pt.matcher(node);
        if (mt.matches()) {
            nd.setAsMock();
        }
        return intNodeID;
    }

    private int removeMockNodes() {
        MainFrame.lockMouse = true;
        this.deSelectNodes();
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = MainFrame.NodeList.get(i);
            if (!nodeAccount.isMock() || !nodeAccount.getNodeID().startsWith("MM")) continue;
            nodeAccount.setDestaque(true);
        }
        MainFrame.methods.globalActionDeleteNode();
        MainFrame.lockMouse = false;
        return 1;
    }

    public String updateEdgeMap(Vector<String> nodesA, Vector<String> nodesB, Vector<Double> arrowDirection, Vector<Double> edgeWeight, Vector<Double> edgeWidth, Vector<String> edgeColor, Vector<String> edgeType, Vector<Double> arrowLength, Vector<Double> arrowAngle, Vector<String> linkType, Vector<String> charsuppl, String dotransform) {
        int i;
        boolean isBrandNew = false;
        try {
            if (charsuppl.get(1).equals("true")) {
                isBrandNew = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean transform = false;
        if (dotransform.equals("yes")) {
            transform = true;
        }
        Vector<Integer> edgeMap = new Vector<Integer>();
        edgeMap.clear();
        if (nodesA.size() != nodesB.size()) {
            return "0";
        }
        boolean isExhaustive = MainFrame.EdgeList.size() > 0 && !isBrandNew;
        int sz = nodesA.size();
        if (sz == 2) {
            isExhaustive = true;
        }
        if (arrowDirection != null && arrowDirection.size() == sz && MainFrame.EdgeList.size() > 0) {
            isExhaustive = true;
        }
        boolean destacar = isExhaustive && MainFrame.EdgeList.size() != sz;
        for (i = 0; i < sz; ++i) {
            String ndA = nodesA.get(i);
            String ndB = nodesB.get(i);
            int edgeId = this.edgeMap(ndA, ndB, isExhaustive);
            edgeMap.add(edgeId);
        }
        if (edgeMap.size() != sz) {
            return "0";
        }
        this.lockInteract();
        for (i = 0; i < edgeMap.size(); ++i) {
            double attin;
            double attin2;
            int id = (Integer)edgeMap.get(i);
            EdgeBank edgeAccount = MainFrame.EdgeList.get(id);
            if (arrowDirection != null && arrowDirection.size() == sz) {
                double attin3 = arrowDirection.get(i);
                edgeAccount.setArrowDirection((int)attin3);
            }
            if (edgeWeight != null && edgeWeight.size() == sz) {
                double attin4 = edgeWeight.get(i);
                edgeAccount.setEdgeWeight(attin4);
            }
            if (destacar) {
                edgeAccount.setDestaque(true);
            }
            if (edgeWidth != null && edgeWidth.size() == sz && (attin2 = edgeWidth.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setLineWidth((float)attin2);
            }
            if (edgeColor != null && edgeColor.size() == sz) {
                String attin5 = edgeColor.get(i);
                Color attc = new Color(153, 153, 255);
                boolean flag = true;
                try {
                    attc = Color.decode(attin5);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    edgeAccount.setColor(attc);
                }
            }
            if (edgeType != null && edgeType.size() == sz) {
                String attin6 = edgeType.get(i);
                edgeAccount.setLine(attin6);
            }
            if (arrowLength != null && arrowLength.size() == sz && (attin = arrowLength.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setArrowLength((float)attin);
            }
            if (arrowAngle != null && arrowAngle.size() == sz && (attin = arrowAngle.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setArrowAngle((float)attin);
            }
            if (linkType != null && linkType.size() == sz && !transform) {
                String attin7 = linkType.get(i);
                if (attin7.equals("nested")) {
                    edgeAccount.setDefaultContainerEdge(true);
                } else if (attin7.equals("notnested")) {
                    edgeAccount.setDefaultContainerEdge(false);
                }
            }
            if (!transform) continue;
            edgeAccount.setDefaultContainerEdge(false);
        }
        MainFrame.methods.updateBanks();
        this.unLockInteract();
        return "1";
    }

    private int edgeMap(String nodeA, String nodeB, boolean isExhaustive) {
        if (isExhaustive) {
            int sz = MainFrame.EdgeList.size();
            for (int i = 0; i < sz; ++i) {
                boolean c2;
                EdgeBank edgeid = MainFrame.EdgeList.get(i);
                NodeBank nodeAccoutA = MainFrame.NodeList.get(edgeid.getA());
                NodeBank nodeAccoutB = MainFrame.NodeList.get(edgeid.getB());
                boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
                boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
                if (!c1 && !c2) continue;
                if (c2) {
                    if (nodeAccoutA.isContainer() || nodeAccoutB.isContainer()) {
                        if (!edgeid.isDefaultEdgeAssignmet()) {
                            int ida = edgeid.getA();
                            int idb = edgeid.getB();
                            edgeid.setA(idb);
                            edgeid.setB(ida);
                        }
                    } else {
                        int ida = edgeid.getA();
                        int idb = edgeid.getB();
                        edgeid.setA(idb);
                        edgeid.setB(ida);
                    }
                }
                return i;
            }
        }
        int nA = MainFrame.keyNodeArray.indexOf(nodeA);
        int nB = MainFrame.keyNodeArray.indexOf(nodeB);
        int intEdgeID = MainFrame.EdgeList.size();
        MainFrame.EdgeList.add(new EdgeBank(nA, nB, intEdgeID));
        return intEdgeID;
    }

    public int lockInteract() {
        MainFrame.lockMouse = true;
        return 1;
    }

    public int unLockInteract() {
        MainFrame.lockMouse = false;
        return 1;
    }

    public int lockDragAndZoom() {
        MainFrame.lockDragAndZoom = true;
        return 1;
    }

    public int unLockDragAndZoom() {
        MainFrame.lockDragAndZoom = false;
        return 1;
    }

    public String duplicateNetwork(String isToCopyEdges, String isDefaultCopy) {
        boolean b1 = true;
        boolean b2 = true;
        if (isToCopyEdges.equals("no")) {
            b1 = false;
        }
        if (isDefaultCopy.equals("no")) {
            b2 = false;
        }
        String newContainer = MainFrame.methods.duplicateNetwork(b1, b2);
        return newContainer;
    }

    public String duplicateSubNetwork(String isToCopyEdges, String isDefaultCopy, Vector<String> nodes) {
        MainFrame.lockMouse = true;
        this.deSelectNodes();
        MainFrame.lockMouse = true;
        this.selectNodeVector(nodes, "", "");
        MainFrame.lockMouse = true;
        boolean b1 = true;
        boolean b2 = true;
        if (isToCopyEdges.equals("no")) {
            b1 = false;
        }
        if (isDefaultCopy.equals("no")) {
            b2 = false;
        }
        String newContainer = MainFrame.methods.duplicateNetwork(b1, b2);
        MainFrame.lockMouse = false;
        return newContainer;
    }

    public int setBackground(String att) {
        Color attc = new Color(255, 255, 255);
        try {
            attc = Color.decode(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MainFrame.methods.setBackground(attc);
        return 1;
    }

    public int setZoom(double att) {
        MainFrame.methods.setZoom(att);
        return 1;
    }

    public int fitToWindow() {
        MainFrame.methods.fitToWindow();
        return 1;
    }

    public int exit() {
        MainFrame.methods.exitred();
        return 1;
    }

    public int reset() {
        MainFrame.lockMouse = false;
        MainFrame.lockDragAndZoom = false;
        MainFrame.NodeList.clear();
        MainFrame.EdgeList.clear();
        MainFrame.LegendList.clear();
        MainFrame.keyNodeHash.clear();
        MainFrame.keyNodeArray.clear();
        MainFrame.setZoom(1.0);
        MainFrame.drawpanel.setZoom(1.0f);
        MainFrame.methods.setBackground(new Color(255, 255, 255));
        MainFrame.updateGraph();
        return 1;
    }

    public int addLegendSize(Vector<Double> sizevec, Vector<String> labvec, String col, double interspace, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype, double edgelen) {
        if (legtype.equals("null")) {
            MainFrame.methods.clearLegend("nodesize");
            MainFrame.methods.clearLegend("edgewidth");
            MainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        Color attc = new Color(0, 0, 0);
        try {
            attc = Color.decode(col);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Vector<Float> szvec = new Vector<Float>();
        for (int i = 0; i < sizevec.size(); ++i) {
            double sz = sizevec.get(i);
            szvec.add(Float.valueOf((float)sz));
        }
        MainFrame.methods.addLegendSize(szvec, labvec, attc, (float)interspace, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype, (float)edgelen);
        MainFrame.updateGraph();
        return 1;
    }

    public int addLegendColor(Vector<String> colvec, Vector<String> labvec, double size, double bend, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype) {
        if (legtype.equals("null")) {
            MainFrame.methods.clearLegend("nodecolor");
            MainFrame.methods.clearLegend("edgecolor");
            MainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        Vector<Color> cols = new Vector<Color>();
        for (int i = 0; i < colvec.size(); ++i) {
            Color attc = new Color(0, 0, 0);
            String att = colvec.get(i);
            try {
                attc = Color.decode(att);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cols.add(attc);
        }
        MainFrame.methods.addLegendColor(cols, labvec, (float)size, (float)bend, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype);
        MainFrame.updateGraph();
        return 1;
    }

    public int addLegendShape(Vector<String> shapevec, Vector<String> labvec, String col, double size, double interspace, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype) {
        if (legtype.equals("null")) {
            MainFrame.methods.clearLegend("nodeshape");
            MainFrame.methods.clearLegend("edgeshape");
            MainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        Color attc = new Color(0, 0, 0);
        try {
            attc = Color.decode(col);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MainFrame.methods.addLegendShape(shapevec, labvec, attc, (float)size, (float)interspace, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype);
        MainFrame.updateGraph();
        return 1;
    }
}

