## ----setup, include=FALSE, results='asis', warning=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, tidy = TRUE, warning = FALSE,
message = FALSE)
options(width = 800)

## ----InstallPackage, eval=FALSE, message=FALSE, warning=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#  install.packages("BiocManager")
#  BiocManager::install("TimiRGeN")

## ----Loadlibs(TimiRGeN Mm), echo=TRUE, message=FALSE, results='hide'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(TimiRGeN)
library(org.Mm.eg.db)

## ----Load knitr kableExtra, echo=FALSE, warning=FALSE, error=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(knitr)
library(kableExtra)

## ----Load mm data-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("mm_miR")

data("mm_mRNA")

## ----Start MAE, message=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- startObject(mm_miR, mm_mRNA)

## ----retrieveID data for mm data, warning=FALSE, message=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- getIdsMir(MAE = MAE, assay(MAE, 1), orgDB = org.Mm.eg.db, miRPrefix = 'mmu')

MAE <- getIdsMrna(MAE = MAE, assay(MAE, 2), mirror = 'useast', species = 'mmusculus', orgDB = org.Mm.eg.db)

## ----combineGenes + filter, error=FALSE, warning=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- combineGenes(MAE = MAE, miR_data = assay(MAE, 1),
                    assay(MAE, 2))

MAE <- genesList(MAE = MAE, method = 'c',
                 genetic_data = assay(MAE, 9),
                 timeString = "D")

MAE <- significantVals(MAE = MAE, method = 'c',
                       geneList =metadata(MAE)[[1]],
                       maxVal = 0.05, stringVal = "adjPVal")

## ----add entrezIDs and extract, warning=FALSE, error=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- addIds(MAE = MAE, method = 'c',
              filtered_genelist = metadata(MAE)[[2]],
              miR_IDs = assay(MAE, 3),
              mRNA_IDs = assay(MAE, 7))

MAE <- eNames(MAE = MAE, method = 'c', gene_IDs = metadata(MAE)[[3]])

## ----downloadGTM show, message=FALSE, warning=FALSE, eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- MultiAssayExperiment()
#  
#  MAE2 <- dloadGmt(MAE = MAE2, species = "Mus musculus")

## ----downloadGTM working, message=FALSE, warning=FALSE, echo=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# dloadGmt failed on bioconductor vignette build so mm_gmt is added instead
load(file = "../inst/extdata/mm_gmt.rda")
MAE2 <- mm_gmt

## ----enrichwiki, warning=FALSE, message=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- enrichWiki(MAE = MAE2, method = 'c',
                  ID_list = metadata(MAE)[[4]],
                  orgDB = org.Mm.eg.db,
                  path_gene = assay(MAE2, 1),
                  path_name = assay(MAE2, 2),
                  ID = "ENTREZID",
                  universe = assay(MAE2, 1)[[2]])

## ----Quickbar, warning=FALSE, message=FALSE, eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  savePlots(largeList = metadata(MAE2)[[1]],
#            maxInt = 5,
#            fileType = "jpeg")

## ----echo=FALSE, out.width = " 350px",out.height= "300px", dpi=8--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("D1_wikipathways.png")
knitr::include_graphics("D2_wikipathways.png")

## ----echo=FALSE, out.width = "350px", out.height="300px", dpi=8---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("D3_wikipathways.png")
knitr::include_graphics("D7_wikipathways.png")

## ----echo=FALSE, out.width = "350px", out.height="300px", dpi=8---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("D14_wikipathways.png")

## ----wikilist show, eval=FALSE, message=FALSE, warning=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- wikiList(MAE2, stringSpecies = 'Mus musculus', stringSymbol = 'L')

## ----wikilist working, echo=FALSE, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# wikiList takes a large amount of time to complete, so to speed vignette
# building, w_list_mouse is used.
metadata(MAE2)[["wp_list"]] <- w_list_mouse

## ----wikiMatrix, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- wikiMatrix(MAE = MAE2, ID_list = metadata(MAE)[[4]],
                   wp_list = metadata(MAE2)[[2]])

## ----Percent, message=FALSE, warning=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- turnPercent(MAE = MAE2, wikiMatrix = assay(MAE2, 4))

## ----createClusters_slow, eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- createClusters(MAE = MAE2, method = "c",
#                         percentMatrix = assay(MAE2, 5),
#                         noClusters = 4, variance = 0.99)

## ----createClusters working, fig.align ="center",dpi=80, echo=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# The createClusters function downloads data from the internet so it cannot
# pass bioconductor vignette building. For this reason clusterdata, mfuzzdata
# and clusters is imported from extdata.

load("../inst/extdata/clusterdata.rda")

load("../inst/extdata/mfuzzdata.rda")

MAEx <- MultiAssayExperiment(list('ClusterData' = clusterdata,
                                  'MuzzData' = mfuzzdata))
MAE2 <- c(MAE2, MAEx)

load("../inst/extdata/clusters.rda")

metadata(MAE2)[['Clusters']] <- clusters

## ----clusterCheck, message=FALSE, warning=FALSE, eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  clusterCheck(Clusters = metadata(MAE2)[[3]], W = FALSE)

## ----plot fuzzy clusters, message=FALSE, eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  quickFuzz(Mfuzzdata = experiments(MAE2)[[7]], Clusters = metadata(MAE2)[[3]],
#            W = FALSE, background = "white", subcol = "black",
#            labelcol = "black", axiscol = "black", axisline = "black")

## ----FUZZ, echo=FALSE, out.width="800px", out.height="300px", dpi=8-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("Fuzz.jpeg")

## ----retrun cluster 1, warning=FALSE, message=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- returnCluster(MAE2, clusterData = assay(MAE2, 6),
                     whichCluster = 1, fitCluster = 0.4)

## ----diffExpressRes, warning=FALSE, message=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- diffExpressRes(MAE = MAE2, df = assay(MAE, 1), dataType = "Log2FC",
                genes_ID = assay(MAE, 3), name = "miR_log2fc")

MAE2 <- diffExpressRes(MAE = MAE2, df = assay(MAE, 2), dataType = "Log2FC",
                genes_ID = assay(MAE, 7), name = "mRNA_log2fc")

## ----mRNAs of interest, warning=FALSE, message=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE2 <- reduceWiki(MAE = MAE2, path_data = assay(MAE2, 3),
                   stringWiki = 'Lung fibrosis')

MAE2 <- wikiMrna(MAE2, mRNA_express = assay(MAE2, 10),
                 singleWiki = assay(MAE2, 11),
                 stringWiki = 'Lung fibrosis')

## ----Correlation matrix, warning=FALSE, message=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE3 <- MultiAssayExperiment()

MAE3 <- mirMrnaInt(MAE = MAE3,
                       miR_express = assay(MAE2, 9),
                       GenesofInterest = assay(MAE2, 12),
                       maxInt = 5)

## ----miR-mRNA interaction databases, message=FALSE, warning=FALSE, eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  options(timeout=80)
#  MAE3 <- dloadTargetscan(MAE = MAE3, species="mmu")
#  
#  MAE3 <- dloadMirdb(MAE = MAE3, species="mmu", orgDB = org.Mm.eg.db)
#  
#  MAE3 <- dloadMirtarbase(MAE = MAE3, species="mmu")

## ----Data mining show, message=FALSE, warning=FALSE, eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE3 <- dataMiningMatrix(MAE = MAE3, corrTable = assay(MAE3, 1),
#                           targetscan = assay(MAE3, 2),
#                           mirdb = assay(MAE3, 3),
#                           mirtarbase = assay(MAE3, 4))

## ----Datamining working, echo=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Because the dload functions could not be performed in vignette building, 
# Int_data is included.

load("../inst/extdata/Int_data.rda")

X <- MultiAssayExperiment(list(MiningMatrix = Int_data))

MAE3 <- c(MAE3, X)

## ----matrixFilter show, warning=FALSE, message=FALSE, eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE3 <- matrixFilter(MAE = MAE3, miningMatrix = assay(MAE3, 5),
#                       negativeOnly = TRUE,
#                       predictedOnly = FALSE,
#                       threshold = 2,
#                       maxCor = -0.5)

## ----matrixFilter working, warning=FALSE, message=FALSE, echo=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Because dload functions are not evaluated, assay(MAE3, 5) should be
# assay(MAE3, 2).

MAE3 <- matrixFilter(MAE = MAE3, miningMatrix = assay(MAE3, 2),
                     negativeOnly = TRUE,
                     predictedOnly = FALSE,
                     threshold = 2,
                     maxCor = -0.5)

## ----CreateNetwork, message=FALSE, warning=FALSE, eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE3 <- makeNet(MAE = MAE3, filt_df = assay(MAE3, 6))
#  
#  quickNet(net = metadata(MAE3)[[1]])

## ----netmake, echo=FALSE, dpi=8-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("NetPlot.jpeg")

## ----Hierarchical1, message=FALSE, warning=FALSE, eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  quickPathwayTC(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#                 mRNA_exp = assay(MAE2, 10), morethan = TRUE, threshold = 1,
#                 pathwayname = "Lung fibrosis")
#  
#  quickDendro(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#             mRNA_exp = assay(MAE2, 10), pathwayname = "Lung fibrosis")
#  
#  quickDMap(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9), mRNA_exp = assay(MAE2, 10), pathwayname = "Lung fibrosis")
#  
#  quickHClust(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#              mRNA_exp = assay(MAE2, 10), pathwayname = "Lung fibrosis", k = 3,
#              cluster = 1)
#  

## ----qpTC, echo=FALSE, out.width = "400px",out.height= "400px", dpi=8---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("pathplot.png")
knitr::include_graphics("dendro.jpeg")

## ----corranalysis, message=FALSE, warning=FALSE, eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  quickMap(filt_df = assay(MAE3, 6), numpairs = 11)
#  
#  quickTC(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#          mRNA_exp = assay(MAE2, 10), pair = 1, scale = FALSE,
#          Interpolation = TRUE, timecourse = 14)
#  
#  quickCrossCorr(filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#                 mRNA_exp = assay(MAE2, 10), pair = 1, scale = FALSE,
#                 Interpolation = FALSE)

## ----corplot, echo=FALSE, out.width = "400px",out.height= "400px", di = 8-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("corplot.png")
knitr::include_graphics("ccplot.png")

## ----reganaysis, message=FALSE, warning=FALSE, eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE3 <- multiReg(MAE = MAE3, gene_interest = "Igf1", mRNAreg = TRUE,
#                   filt_df = assay(MAE3, 6), miRNA_exp = assay(MAE2, 9),
#                   mRNA_exp = assay(MAE2, 10))
#  
#  
#  model1 <- linearRegr(mreg = assay(MAE3, 7), colpair = 3, alterpairs = c(4, 5))
#  summary(model1$regression)
#  
#  model2 <- linearRegr(mreg = assay(MAE3, 7), colpair = 5)
#  summary(model2$regression)
#  
#  quickTCPred(model = model1, reg_df = assay(MAE3, 7))
#  
#  quickReg(reg_df = assay(MAE3, 7), colselect = 3)
#  quickReg(reg_df = assay(MAE3, 7), colselect = 6)

## ----TCpred, ig.align="center", echo=FALSE, out.width = "500px",out.height= "500px", di = 8-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("predred.png")

## ----Make Output for Pathvisio show, eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE3 <- makeMapp(MAE3,
#                   filt_df = assay(MAE3, 6),
#                   miR_IDs_adj = assay(MAE, 5),
#                   dataType = 'L')
#  
#  MAE3 <- makeDynamic(MAE = MAE3,
#                      miR_expression = assay(MAE2, 9),
#                      mRNA_expression = assay(MAE2, 10),
#                      miR_IDs_adj = assay(MAE, 5),
#                      dataType = 'L')
#  
#  write.table(assay(MAE3, 8), "MAPP.txt", quote = FALSE,
#              row.names = FALSE, col.names = FALSE,
#              sep = "\t")
#  
#  write.csv(assay(MAE3, 9), "Dynamics.csv", row.names = TRUE,
#            quote = FALSE)

## ----cytoscape, message=FALSE, warning=FALSE, eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  RCy3 :: cytoscapePing()
#  
#  cytoMake(assay(MAE3, 6),
#           titleString = 'Lung Fibrosis Pathway',
#           collectionString = 'PathwaysforKidneyFibrosis')

## ----loadhuman, message=FALSE, warning=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(org.Hs.eg.db)

data("hs_miR")

rownames(hs_miR) <- gsub(rownames(hs_miR), pattern = "\\.", replacement = "-")

rownames(hs_miR) <- sub("-$", "*", rownames(hs_miR))

## ----loadmRNA, message=FALSE, warning=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("hs_mRNA")

MAE <- startObject(hs_miR, hs_mRNA)

MAE <- getIdsMir(MAE = MAE, assay(MAE, 1), orgDB = org.Hs.eg.db, miRPrefix = 'hsa')

MAE <- getIdsMrna(MAE = MAE, assay(MAE, 2), mirror = 'useast', species = 'hsapiens', orgDB = org.Hs.eg.db)

## ----addPrefix, message=FALSE, warning=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- addPrefix(MAE = MAE, gene_df = assay(MAE, 1),
                 prefixString = "miR")

MAE <- addPrefix(MAE = MAE, gene_df = assay(MAE, 2),
                 prefixString = "mRNA")

## ----siggenes, warning=FALSE, message=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- genesList(MAE = MAE, method = 's',
                 miR_data = assay(MAE, 9),
                 mRNA_data = assay(MAE, 10))

MAE <- significantVals(MAE = MAE, method = 's',
                       geneList = metadata(MAE)[[1]],
                       maxVal = 0.05, stringVal = "adjPVal")

## ----getensemblids, warning=FALSE, message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MAE <- addIds(MAE = MAE, method = 's',
              filtered_genelist = metadata(MAE)[[2]],
              miR_IDs = assay(MAE, 4),
              mRNA_IDs = assay(MAE, 8))

MAE <- eNames(MAE = MAE, method = 's', gene_ID = metadata(MAE)[[3]])

## ----hs dloadGmt show, eval=FALSE, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- MultiAssayExperiment()
#  
#  MAE2 <- dloadGmt(MAE = MAE2, species = "Homo sapiens")

## ----convert to ensembl, eval=FALSE, message=FALSE, warning=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- gmtEnsembl(MAE = MAE2, path_gene = assay(MAE2, 1),
#                      path_data = assay(MAE2, 3),
#                      orgDB = org.Hs.eg.db)

## ----hs dloadGmt working, echo=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# dloadGmt failed on bioconductor vignette build so hs_gmt is added instead
# hs_gmt contains the MAE that would have been produced by gmtEnsembl.
load(file = "../inst/extdata/hs_gmt.rda")
MAE2 <- hs_gmt

## ----message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("hs_probes")

MAE2 <- enrichWiki(MAE = MAE2, method = 's',
                   ID_list = metadata(MAE)[[4]],
                   orgDB = org.Hs.eg.db,
                   path_gene = assay(MAE2, 4),
                   path_name = assay(MAE2, 2),
                   ID = 'ENSEMBL',
                   universe = hs_probes$ensembl_gene_id)


## ----saveplots_s, eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  savePlots(largeList = metadata(MAE2)[[1]], maxInt = 6,
#            fileType = "jpeg")

## ----human wikiList show, eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- wikiList(MAE = MAE2, stringSpecies = "Homo sapiens",
#                   stringSymbol = "En")

## ----human wikiList working, echo=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# Loading w_list_human instead to speed up vignette building

load("../inst/extdata/w_list_human.rda")

metadata(MAE2)[['wikilist']] <- w_list_human

## ----create_percent_matrix, warning=FALSE, message=FALSE, eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- wikiMatrix(MAE = MAE2, ID_list = metadata(MAE)[[4]],
#                     wp_list = metadata(MAE2)[[2]])
#  
#  MAE2 <- turnPercent(MAE = MAE2, wikiMatrix = assay(MAE2, 6))

## ----ensembl human clusters show, warning=FALSE, message=FALSE, eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MAE2 <- createClusters(MAE = MAE2, method = "s",
#                         dataString = "mRNA",
#                         percentMatrix = assay(MAE2, 7),
#                         noClusters = 2,
#                         variance = 0.99)
#  
#  clusterCheck(Clusters = metadata(MAE2)[[3]], W = FALSE)
#  
#  quickFuzz(Mfuzzdata = experiments(MAE2)[[9]],
#            Clusters = metadata(MAE2)[[3]],
#            W = FALSE)
#  
#  MAE2 <- returnCluster(MAE2, clusterData = assay(MAE2, 8),
#                        whichCluster = 1,
#                        fitCluster = 0.5)
#  

## ----mRNA only, message=FALSE, warning=FALSE, eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data("mm_mRNA")
#  
#  Data <- startObject(miR = NULL, mRNA = mm_mRNA)
#  
#  Data <- getIdsMrna(MAE = Data, mRNA = assay(Data, 2), mirror = 'useast',                          species = 'mmusculus', orgDB = org.Mm.eg.db)
#  
#  Data <- genesList(Data,
#                    method = 'c',
#                    genetic_data = assay(Data, 2),
#                    timeString = 'D')
#  
#  Data <- significantVals(Data, method = 'c',
#                          geneList = metadata(Data)[[1]],
#                          maxVal = 0.05,
#                          stringVal = 'adjPVal')
#  
#  Data <- addIds(MAE = Data, method = 'c',
#                 filtered_genelist = metadata(Data)[[2]],
#                 miR_IDs = assay(Data, 3),
#                 mRNA_IDs = assay(Data, 3))
#  
#  Data <- eNames(MAE = Data, method = 'c',
#                 gene_IDs = metadata(Data)[[3]])
#  
#  Data2 <- MultiAssayExperiment()
#  
#  Data2 <- dloadGmt(MAE = Data2, species = "Mus musculus")
#  
#  Data2 <- enrichWiki(MAE = Data2, method = 'c',
#                      ID_list = metadata(Data)[[4]],
#                      orgDB = org.Mm.eg.db,
#                      path_gene = assay(Data2, 1),
#                      path_name = assay(Data2, 2),
#                      ID = "ENTREZID",
#                      universe = assay(Data2, 1)[[2]])
#  
#  quickBar(X = metadata(Data2)[[1]][[1]], Y = names(metadata(Data2)[[1]][1]))

## ----Long_analysis, eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(TimiRGeN)
#  library(org.Hs.eg.db)
#  
#  data(long_data)
#  miRNA <- long_data[c(1:105),]
#  mRNA <- long_data[-c(1:105),]
#  
#  MAE <- startObject(miRNA, mRNA)
#  
#  MAE <- getIdsMir(MAE = MAE, miR = MAE[[1]], orgDB = org.Hs.eg.db,
#                   miRPrefix = "hsa")
#  
#  MAE <- getIdsMrna(MAE = MAE, mRNA = MAE[[2]], mirror = "www",
#                    species = "hsapiens", orgDB = org.Hs.eg.db)
#  
#  MAE <- combineGenes(MAE = MAE, miR_data = MAE[[1]], mRNA_data = MAE[[2]])
#  
#  MAE <- genesList(MAE = MAE, method = "c", genetic_data = MAE[[9]],
#                   timeString = "H", miR_data = )
#  
#  MAE <- addIds(MAE = MAE, method = "c", filtered_genelist = metadata(MAE)[[1]],
#                miR_IDs = MAE[[3]], mRNA_IDs = MAE[[7]])
#  
#  MAE <- eNames(MAE = MAE, method = "c", gene_IDs = metadata(MAE)[[2]])
#  
#  MAE2 <- MultiAssayExperiment()
#  
#  MAE2 <- dloadGmt(MAE = MAE2, species = "Homo sapiens")
#  
#  MAE2 <- enrichWiki(MAE = MAE2, method = "c", ID_list = metadata(MAE)[[3]],
#                     orgDB = org.Hs.eg.db, path_gene = MAE2[[1]],
#                     path_name = MAE2[[2]], ID = "ENTREZID",
#                     universe = MAE2[[1]][[2]])
#  
#  quickBar(metadata(MAE2)[[1]][[1]], Y = "Enriched Pathways")
#  

## ----longclutsers, warning=FALSE, message=FALSE, eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(TimiRGeN)
#  library(org.Hs.eg.db)
#  
#  data(long_data)
#  miRNA <- long_data[c(1:105),]
#  mRNA <- long_data[-c(1:105),]
#  
#  MAE <- startObject(miRNA, mRNA)
#  
#  MAE <- getIdsMir(MAE = MAE, miR = MAE[[1]], orgDB = org.Hs.eg.db,
#                   miRPrefix = "hsa")
#  
#  MAE <- getIdsMrna(MAE = MAE, mRNA = MAE[[2]], mirror = "www",
#                    species = "hsapiens", orgDB = org.Hs.eg.db)
#  
#  MAE <- combineGenes(MAE = MAE, miR_data = MAE[[1]], mRNA_data = MAE[[2]])
#  
#  MAE <- createClusters2(MAE = MAE, genetic_data = assay(MAE, 9))
#  
#  quickFuzz(Mfuzzdata = MAE[[11]], Clusters = metadata(MAE)[[1]],
#            ylab="Standardised Gene Expression")
#  
#  MAE <- clusterList(MAE = MAE, clusterData = assay(MAE, 10),
#                     fitCluster = 0.5, miR_IDs = assay(MAE, 3),
#                     mRNA_IDs = assay(MAE, 7))
#  
#  MAE2 <- MultiAssayExperiment()
#  
#  MAE2 <- dloadGmt(MAE = MAE2, species = "Homo sapiens")
#  
#  MAE2 <- enrichWiki(MAE = MAE2, method = "c", ID_list = metadata(MAE)[[2]],
#                     orgDB = org.Hs.eg.db, path_gene = MAE2[[1]],
#                     path_name = MAE2[[2]], ID = "ENTREZID",
#                     universe = MAE2[[1]][[2]])
#  
#  savePlots(largeList = metadata(MAE2)[[1]], maxInt = 5, fileType = "png")

## ----loadUUO, message=FALSE, warning=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("UUO_data")
UUO_miRNA <- UUO_data[c(1:240),]
UUO_mRNA <- UUO_data[-c(1:240),]

## ----netcontrast,out.width="400px",out.height="400px",echo=FALSE,dpi=8--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("NetPlot.jpeg")
knitr::include_graphics("net2.jpeg")

## ----regcontrast,out.width="400px",out.height="400px",echo=FALSE,dpi=8--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::include_graphics("reg1.png")
knitr::include_graphics("reg2.png")

