## ---- code=readLines(system.file('vignettes_inc.R', package='biodb')), echo=FALSE----
# Disable automatic loading of extra biodb packages
Sys.setenv(BIODB_AUTOLOAD_EXTRA_PKGS="FALSE")

biodbVignettes <- data.frame()
files <- Sys.glob('*.Rmd')
for (f in files) {
	name <- sub('^(.*)\\.Rmd', '\\1', f, perl=TRUE)
	firstLines <- readLines(f, n=20)
	title <- grep("^title:", firstLines, value=TRUE)
	title <- sub('^title: *"(.*)\\.?"$', '\\1', title, perl=TRUE)
	desc <- grep("%\\\\VignetteIndexEntry", firstLines, value=TRUE)
	desc <- sub('^.*VignetteIndexEntry{(.*)}.*$', '\\1', desc, perl=TRUE)
    html <- paste0(name, '.html')
    link <- paste0('[', title, '](', html, ')')
    biodbVignettes <- rbind(biodbVignettes, data.frame(name=name, title=title,
                                                       desc=desc, html=html,
                                                       link=link))
}

make_vignette_ref <- function(name) {
	cat(biodbVignettes[biodbVignettes$name == name, 'link', drop=TRUE])
}

insert_features_table <- function() {
    featuresFile <- system.file("features.tsv",
                                package='biodb')
    featuresDf <- read.table(featuresFile, sep="\t", header=TRUE, quote="",
                             stringsAsFactors=FALSE)
    knitr::kable(featuresDf, "pipe", label="features",
                 caption="*biodb* main features. These are generic features (i.e.: present at top-level of architecture or present in at least a group of connectors), unless specified otherwise.")
}

## -----------------------------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
mybiodb$getConfig()

## -----------------------------------------------------------------------------
x <- mybiodb$getConfig()$listKeys()

## ----keysDf, echo=FALSE, results='asis'---------------------------------------
knitr::kable(x, "pipe", caption="List of keys with some of their parameters")

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getDescription('cache.directory')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$get('cache.directory')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$set('cache.directory', '~/my.biodb.cache')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$enable('offline')
mybiodb$getConfig()$disable('offline')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getDefaultValue('cache.directory')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getAssocEnvVar('cache.directory')

## -----------------------------------------------------------------------------
mybiodb$getDbsInfo()

## -----------------------------------------------------------------------------
mybiodb$getDbsInfo()$get('mass.csv.file')

## -----------------------------------------------------------------------------
mybiodb$getFactory()

## -----------------------------------------------------------------------------
chebi.tsv <- system.file("extdata", "chebi_extract.tsv", package='biodb')
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=chebi.tsv)
conn

## -----------------------------------------------------------------------------
conn$getEntry('1018')

## -----------------------------------------------------------------------------
conn$searchForEntries(list(monoisotopic.mass=list(value=136.05, delta=0.1)))

## ---- echo=FALSE, results='asis'----------------------------------------------
make_vignette_ref('entries')

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$getConn('comp.csv.file')

## -----------------------------------------------------------------------------
mybiodb$getFactory()$deleteConn(conn)

## -----------------------------------------------------------------------------
mybiodb$getEntryFields()

## -----------------------------------------------------------------------------
mybiodb$getEntryFields()$get('monoisotopic.mass')

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()

## ---- echo=FALSE, results='asis'----------------------------------------------
make_vignette_ref('new_connector')

## -----------------------------------------------------------------------------
source(system.file("extdata", "ChebiExConn.R", package='biodb'))
source(system.file("extdata", "ChebiExEntry.R", package='biodb'))
mybiodb$loadDefinitions(system.file("extdata", "chebi_ex.yml", package='biodb'))
conn <- mybiodb$getFactory()$createConn('chebi.ex')

## -----------------------------------------------------------------------------
entry <- conn$getEntry('17001')

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$fileExist(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$getFilePath(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
conn$deleteAllEntriesFromPersistentCache()

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$fileExist(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
conn$deleteAllEntriesFromVolatileCache()

## -----------------------------------------------------------------------------
conn$deleteWholePersistentCache()

## -----------------------------------------------------------------------------
biodb::getLogger()

## -----------------------------------------------------------------------------
biodb::logInfo("%d entries have been processed.", 12)

## -----------------------------------------------------------------------------
biodb::logDebug("The file %s has been written.", 'myfile.txt')

## -----------------------------------------------------------------------------
biodb::logTrace("%d bytes written.", 1284902)

## -----------------------------------------------------------------------------
biodb::getLogger()$set_threshold(300)

## -----------------------------------------------------------------------------
biodb::logInfo("hello")

## -----------------------------------------------------------------------------
biodb::getLogger()$set_threshold(400)

## -----------------------------------------------------------------------------
biodb::logInfo("hello")

## -----------------------------------------------------------------------------
mybiodb$terminate()

