## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE, message = FALSE, warning = FALSE
)
library(BiocStyle)

## ---- eval = FALSE------------------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install("spicyR")

## ----message=FALSE, warning=FALSE---------------------------------------------
# load required packages
library(spicyR)
library(lisaClust)
library(ggplot2)


## ----eval=T-------------------------------------------------------------------
set.seed(51773)
x <- round(c(runif(200),runif(200)+1,runif(200)+2,runif(200)+3,
           runif(200)+3,runif(200)+2,runif(200)+1,runif(200)),4)*100
y <- round(c(runif(200),runif(200)+1,runif(200)+2,runif(200)+3,
             runif(200),runif(200)+1,runif(200)+2,runif(200)+3),4)*100
cellType <- factor(paste('c',rep(rep(c(1:2),rep(200,2)),4),sep = ''))
imageID <- rep(c('s1', 's2'),c(800,800))

cells <- data.frame(x, y, cellType, imageID)

ggplot(cells, aes(x,y, colour = cellType)) + geom_point() + facet_wrap(~imageID)



## -----------------------------------------------------------------------------

cellExp <- SegmentedCells(cells, cellTypeString = 'cellType')



## -----------------------------------------------------------------------------

lisaCurves <- lisa(cellExp, Rs = c(20, 50, 100))


## -----------------------------------------------------------------------------

kM <- kmeans(lisaCurves,2)
region(cellExp) <- paste('region',kM$cluster,sep = '_')

## -----------------------------------------------------------------------------
hatchingPlot(cellExp, imageID = c('s1','s2'))

## -----------------------------------------------------------------------------

df <- region(cellExp, annot = TRUE)

p <- ggplot(df,aes(x = x,y = y, colour = cellType, region = region)) + 
  geom_point() + 
  facet_wrap(~imageID) +
  geom_hatching(window = "concave", 
                line.spacing = 11, 
                nbp = 50, 
                line.width = 2, 
                hatching.colour = "gray20",
                window.length = 0.1) +
  theme_minimal() + 
  scale_region_manual(values = 6:7, labels = c('ab','cd'))

p


## -----------------------------------------------------------------------------
isletFile <- system.file("extdata","isletCells.txt.gz", package = "spicyR")
cells <- read.table(isletFile, header = TRUE)
cellExp <- SegmentedCells(cells, cellProfiler = TRUE)


## -----------------------------------------------------------------------------
markers <- cellMarks(cellExp)
kM <- kmeans(markers,10)
cellType(cellExp) <- paste('cluster', kM$cluster, sep = '')

## -----------------------------------------------------------------------------

lisaCurves <- lisa(cellExp, Rs = c(10,20,50))


## -----------------------------------------------------------------------------

kM <- kmeans(lisaCurves,2)
region(cellExp) <- paste('region',kM$cluster,sep = '_')


## -----------------------------------------------------------------------------
hatchingPlot(cellExp)

## -----------------------------------------------------------------------------
sessionInfo()

