/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.Constraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.DiscreteDistribution;
import eponine.model.EnvelopedWaveDistribution;
import eponine.model.GaussianDistribution;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.SquareWaveDistribution;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import stats.glm.BasisFunction;
import stats.glm.GLMClassificationModel;
import stats.glm.UnityBasisFunction;

public class EponineXML {
    private boolean writeHistory = false;

    public void modelToXML(GLMClassificationModel gLMClassificationModel, DocumentHandler documentHandler) throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        documentHandler.startElement("model", attributeListImpl);
        Collection collection = gLMClassificationModel.getBasisFunctions();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BasisFunction basisFunction = (BasisFunction)iterator.next();
            BasisFunction basisFunction2 = ModelTools.removeHistory(basisFunction);
            String string = "unity";
            if (basisFunction2 instanceof ConstraintBasisFunction) {
                string = "constraint";
            }
            attributeListImpl.clear();
            attributeListImpl.addAttribute("weight", "CDATA", "" + gLMClassificationModel.getWeight(basisFunction));
            documentHandler.startElement(string, attributeListImpl);
            if (basisFunction2 instanceof ConstraintBasisFunction) {
                this.emitConstraint(((ConstraintBasisFunction)basisFunction2).getConstraint(), documentHandler);
            }
            if (basisFunction instanceof BasisFunctionWithHistory && this.writeHistory) {
                this.emitHistory((BasisFunctionWithHistory)basisFunction, documentHandler);
            }
            documentHandler.endElement(string);
        }
        documentHandler.endElement("model");
    }

    private void emitHistory(BasisFunctionWithHistory basisFunctionWithHistory, DocumentHandler documentHandler) throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        attributeListImpl.addAttribute("creatrix", "CDATA", ((Symbol)((Object)basisFunctionWithHistory.getCreatrix())).getName());
        attributeListImpl.addAttribute("cycle", "CDATA", "" + basisFunctionWithHistory.getCreateCycle());
        documentHandler.startElement("history", attributeListImpl);
        Iterator iterator = basisFunctionWithHistory.getParents().iterator();
        while (iterator.hasNext()) {
            BasisFunction basisFunction = (BasisFunction)iterator.next();
            if (basisFunction instanceof BasisFunctionWithHistory) {
                this.emitHistory((BasisFunctionWithHistory)basisFunction, documentHandler);
                continue;
            }
            attributeListImpl.clear();
            documentHandler.startElement("unknown", attributeListImpl);
            documentHandler.endElement("unknown");
        }
        documentHandler.endElement("history");
    }

    private void emitDistribution(DiscreteDistribution discreteDistribution, DocumentHandler documentHandler) throws SAXException {
        if (discreteDistribution instanceof GaussianDistribution) {
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("width", "CDATA", "" + ((GaussianDistribution)discreteDistribution).getWidth());
            documentHandler.startElement("gaussianDistribution", attributeListImpl);
            documentHandler.endElement("gaussianDistribution");
        } else if (discreteDistribution instanceof SquareWaveDistribution) {
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("width", "CDATA", "" + ((SquareWaveDistribution)discreteDistribution).getWidth());
            documentHandler.startElement("squareWaveDistribution", attributeListImpl);
            documentHandler.endElement("squareWaveDistribution");
        } else if (discreteDistribution instanceof EnvelopedWaveDistribution) {
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("phase", "CDATA", "" + ((EnvelopedWaveDistribution)discreteDistribution).getPhase());
            documentHandler.startElement("envelopedWaveDistribution", attributeListImpl);
            this.emitDistribution(((EnvelopedWaveDistribution)discreteDistribution).getEnvelope(), documentHandler);
            documentHandler.endElement("envelopedWaveDistribution");
        }
    }

    private void emitConstraint(Constraint constraint, DocumentHandler documentHandler) throws SAXException {
        if (constraint instanceof PositionedConstraint) {
            PositionedConstraint positionedConstraint = (PositionedConstraint)constraint;
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("pos", "CDATA", "" + positionedConstraint.getPosition());
            attributeListImpl.addAttribute("max", "NMTOKEN", "" + positionedConstraint.isMaximum());
            documentHandler.startElement("positioned", attributeListImpl);
            this.emitDistribution(positionedConstraint.getDistribution(), documentHandler);
            this.emitConstraint(positionedConstraint.getConstraint(), documentHandler);
            documentHandler.endElement("positioned");
        } else if (constraint instanceof WeightMatrixConstraint) {
            WeightMatrix weightMatrix = ((WeightMatrixConstraint)constraint).getWeightMatrix();
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("alphabet", "CDATA", weightMatrix.getAlphabet().getName());
            attributeListImpl.addAttribute("columns", "CDATA", "" + weightMatrix.columns());
            attributeListImpl.addAttribute("reverse", "CDATA", "" + ((WeightMatrixConstraint)constraint).getReversibility());
            documentHandler.startElement("weightmatrix", attributeListImpl);
            try {
                int n = 0;
                while (n < weightMatrix.columns()) {
                    attributeListImpl.clear();
                    attributeListImpl.addAttribute("pos", "CDATA", "" + n);
                    documentHandler.startElement("column", attributeListImpl);
                    Iterator iterator = ((FiniteAlphabet)weightMatrix.getAlphabet()).iterator();
                    while (iterator.hasNext()) {
                        attributeListImpl.clear();
                        Symbol symbol = (Symbol)iterator.next();
                        attributeListImpl.addAttribute("symbol", "CDATA", symbol.getName());
                        attributeListImpl.addAttribute("weight", "CDATA", "" + weightMatrix.getColumn(n).getWeight(symbol));
                        documentHandler.startElement("weight", attributeListImpl);
                        documentHandler.endElement("weight");
                    }
                    documentHandler.endElement("column");
                    ++n;
                }
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new SAXException(illegalSymbolException);
            }
            documentHandler.endElement("weightmatrix");
        } else if (constraint instanceof BundleConstraint) {
            List list = ((BundleConstraint)constraint).getConstraints();
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("op", "NMTOKEN", "multiply");
            documentHandler.startElement("bundle", attributeListImpl);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.emitConstraint((Constraint)iterator.next(), documentHandler);
            }
            documentHandler.endElement("bundle");
        } else {
            throw new SAXException("Unknown constraint type in model.");
        }
    }

    public GLMClassificationModel xmlToModel(Element element) {
        Object object;
        ArrayList<BasisFunction> arrayList = new ArrayList<BasisFunction>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                object = (Element)node;
                String string = object.getTagName();
                if (string.equals("unity")) {
                    arrayList.add(new UnityBasisFunction());
                    try {
                        arrayList2.add(new Double(Double.parseDouble(object.getAttribute("weight"))));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("constraint")) {
                    Node node2 = object.getFirstChild();
                    while (node2 != null && !(node2 instanceof Element)) {
                        node2 = node2.getNextSibling();
                    }
                    Element element2 = (Element)node2;
                    arrayList.add(new ConstraintBasisFunction(this.readConstraint(element2)));
                    try {
                        arrayList2.add(new Double(Double.parseDouble(object.getAttribute("weight"))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            node = node.getNextSibling();
        }
        object = DoubleFactory1D.dense.make(arrayList2.size());
        int n = 0;
        while (n < arrayList2.size()) {
            ((DoubleMatrix1D)object).set(n, (Double)arrayList2.get(n));
            ++n;
        }
        return new GLMClassificationModel(arrayList, (DoubleMatrix1D)object);
    }

    private DiscreteDistribution readDistribution(Element element) throws NumberFormatException {
        String string = element.getTagName();
        if (string.equals("gaussianDistribution")) {
            return new GaussianDistribution(Double.parseDouble(element.getAttribute("width")));
        }
        if (string.equals("squareWaveDistribution")) {
            return new SquareWaveDistribution(Integer.parseInt(element.getAttribute("width")));
        }
        if (string.equals("envelopedWaveDistribution")) {
            Node node = element.getFirstChild();
            while (node != null && !(node instanceof Element)) {
                node = node.getNextSibling();
            }
            Element element2 = (Element)node;
            double d = Double.parseDouble(element.getAttribute("phase"));
            return new EnvelopedWaveDistribution(this.readDistribution(element2), d);
        }
        return null;
    }

    public WeightMatrix readWeightMatrix(Element element) {
        try {
            int n = Integer.parseInt(element.getAttribute("columns"));
            AlphabetManager.instance();
            Alphabet alphabet = AlphabetManager.alphabetForName(element.getAttribute("alphabet"));
            SymbolParser symbolParser = null;
            SymbolParser symbolParser2 = null;
            try {
                symbolParser = alphabet.getParser("name");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                symbolParser2 = alphabet.getParser("token");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(alphabet, n, ModelTools.DIST_FACTORY);
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    int n2 = Integer.parseInt(element2.getAttribute("pos"));
                    Distribution distribution = simpleWeightMatrix.getColumn(n2);
                    Node node2 = element2.getFirstChild();
                    while (node2 != null) {
                        if (node2 instanceof Element) {
                            Element element3 = (Element)node2;
                            String string = element3.getAttribute("symbol");
                            Symbol symbol = null;
                            if (symbolParser != null) {
                                try {
                                    symbol = symbolParser.parseToken(string);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (symbol == null && symbolParser2 != null) {
                                try {
                                    symbol = symbolParser2.parseToken(string);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (symbol == null) {
                                throw new BioException("Couldn't parse " + string);
                            }
                            double d = Double.parseDouble(element3.getAttribute("weight"));
                            try {
                                distribution.setWeight(symbol, d);
                            }
                            catch (ChangeVetoException changeVetoException) {
                                throw new BioError(changeVetoException);
                            }
                        }
                        node2 = node2.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
            return simpleWeightMatrix;
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    private Constraint readConstraint(Element element) {
        try {
            String string = element.getTagName();
            if (string.equals("positioned")) {
                int n = Integer.parseInt(element.getAttribute("pos"));
                DiscreteDistribution discreteDistribution = null;
                Constraint constraint = null;
                String string2 = element.getAttribute("dist");
                if (string2 != null && string2.length() > 0) {
                    discreteDistribution = new GaussianDistribution(Double.parseDouble(string2));
                }
                boolean bl = Boolean.valueOf(element.getAttribute("max"));
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node instanceof Element) {
                        Element element2 = (Element)node;
                        DiscreteDistribution discreteDistribution2 = this.readDistribution(element2);
                        if (discreteDistribution2 != null) {
                            discreteDistribution = discreteDistribution2;
                        } else {
                            constraint = this.readConstraint(element2);
                        }
                    }
                    node = node.getNextSibling();
                }
                if (discreteDistribution == null) {
                    throw new BioError("No distribution");
                }
                if (constraint == null) {
                    throw new BioError("No constraint");
                }
                return new PositionedConstraint(constraint, n, discreteDistribution, bl);
            }
            if (string.equals("weightmatrix")) {
                String string3 = element.getAttribute("reverse");
                double d = 0.0;
                d = string3 == null || string3.equals("false") ? 0.0 : (string3.equals("true") ? 0.5 : Double.parseDouble(string3));
                WeightMatrix weightMatrix = this.readWeightMatrix(element);
                return new WeightMatrixConstraint(weightMatrix, d);
            }
            if (string.equals("bundle")) {
                ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node instanceof Element) {
                        arrayList.add(this.readConstraint((Element)node));
                    }
                    node = node.getNextSibling();
                }
                return new BundleConstraint(arrayList);
            }
            throw new BioError("Unknown element in model: " + string);
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }
}

