/*
 * Decompiled with CFR 0.152.
 */
package org.acedb;

import java.util.Date;
import org.acedb.Ace;
import org.acedb.AceError;
import org.acedb.AceException;
import org.acedb.AceNode;
import org.acedb.AceUtils;
import org.acedb.Database;
import org.acedb.PeekStringTokenizer;
import org.acedb.staticobj.StaticAceNode;
import org.acedb.staticobj.StaticAceObject;
import org.acedb.staticobj.StaticDateValue;
import org.acedb.staticobj.StaticFloatValue;
import org.acedb.staticobj.StaticIntValue;
import org.acedb.staticobj.StaticModelInclude;
import org.acedb.staticobj.StaticModelNode;
import org.acedb.staticobj.StaticModelReference;
import org.acedb.staticobj.StaticModelType;
import org.acedb.staticobj.StaticReference;
import org.acedb.staticobj.StaticStringValue;

public class AcePerlParser {
    private Database parentDB;

    public AcePerlParser(Database database) {
        this.parentDB = database;
    }

    private StaticAceNode constructNode(StaticAceNode staticAceNode, String string, String string2, String string3) throws AceException {
        StaticAceNode staticAceNode2 = null;
        if (string.equals("in")) {
            staticAceNode2 = new StaticIntValue(Integer.parseInt(string2), staticAceNode);
        } else if (string.equals("fl")) {
            staticAceNode2 = new StaticFloatValue(Float.parseFloat(string2), staticAceNode);
        } else if (string.equals("dt")) {
            int n = Integer.parseInt(string2.substring(0, 4));
            int n2 = Integer.parseInt(string2.substring(5, 7));
            int n3 = Integer.parseInt(string2.substring(8, 10));
            staticAceNode2 = new StaticDateValue(new Date(n, n2, n3), staticAceNode);
        } else if (string.equals("tx")) {
            staticAceNode2 = new StaticStringValue(string2, staticAceNode);
        } else if (string.equals("ob")) {
            string2 = AceUtils.encode(string2);
            string3 = AceUtils.encode(string3);
            staticAceNode2 = staticAceNode != null ? new StaticReference(string2, staticAceNode, AceUtils.rootURL(staticAceNode.toURL()).relativeURL(string3)) : new StaticAceObject(string2, Ace.fetch(this.parentDB.toURL().relativeURL(string3)), string3);
        } else if (string.equals("tg")) {
            staticAceNode2 = new StaticAceNode(AceUtils.encode(string2), staticAceNode);
        } else if (string.equals("model-node")) {
            staticAceNode2 = new StaticModelNode(AceUtils.encode(string2), staticAceNode);
        } else if (string.equals("model-reference")) {
            staticAceNode2 = new StaticModelReference(AceUtils.encode(string2), staticAceNode);
        } else if (string.equals("model-include")) {
            staticAceNode2 = new StaticModelInclude(AceUtils.encode(string2), staticAceNode);
        } else if (string.equals("model-type")) {
            staticAceNode2 = new StaticModelType(AceUtils.encode(string2), staticAceNode);
        } else {
            throw new AceError("Don't know how to handle type " + string);
        }
        return staticAceNode2;
    }

    private void getChildren(StaticAceNode staticAceNode, PeekStringTokenizer peekStringTokenizer) throws AceException {
        while (true) {
            String string;
            if ((string = peekStringTokenizer.nextToken()).equals("{")) {
                staticAceNode.addNode(this.getNode(staticAceNode, peekStringTokenizer));
                continue;
            }
            if (string.equals("]")) break;
        }
    }

    private AceNode getNode(StaticAceNode staticAceNode, PeekStringTokenizer peekStringTokenizer) throws AceException {
        String string = null;
        String string2 = null;
        String string3 = null;
        StaticAceNode staticAceNode2 = null;
        while (true) {
            String string4;
            if ((string4 = peekStringTokenizer.nextToken()).equals(",")) {
                continue;
            }
            if (string4.startsWith("ty=>")) {
                if (string != null) {
                    throw new AceError("Resetting old ty value " + string + " with " + string4);
                }
                string = string4.substring(4).trim();
                continue;
            }
            if (string4.startsWith("va=>")) {
                if (string2 != null) {
                    throw new AceError("Resetting old va value " + string2 + " with " + string4);
                }
                if (string4.length() > 4) {
                    string2 = string4.substring(4);
                    continue;
                }
                string2 = peekStringTokenizer.nextToken();
                continue;
            }
            if (string4.equals("cl=>")) {
                if (string3 != null) {
                    throw new AceError("Resetting old cl value " + string3 + " with " + string4);
                }
                if (string4.length() > 4) {
                    string3 = string4.substring(4);
                    continue;
                }
                string3 = peekStringTokenizer.nextToken();
                continue;
            }
            if (string4.equals("Pn=>")) {
                if (!peekStringTokenizer.nextToken().equals("[")) {
                    throw new AceError("Unrecoverable parsing error: expecting [");
                }
                if (string == null) {
                    throw new AceError("Got null ty field for object");
                }
                staticAceNode2 = this.constructNode(staticAceNode, string, string2, string3);
                this.getChildren(staticAceNode2, peekStringTokenizer);
                string = null;
                string2 = null;
                string3 = null;
                continue;
            }
            if (string4.equals("}")) {
                if (staticAceNode2 != null) {
                    return staticAceNode2;
                }
                return this.constructNode(staticAceNode, string, string2, string3);
            }
            if (string4.indexOf("=>") == 2) {
                System.out.println("Unknown tag in perl-style dump: " + string4);
                if (string4.length() != 4) continue;
                string4 = peekStringTokenizer.nextToken();
                System.out.println("Throwing away next token: " + string4);
                continue;
            }
            if (string != null || string2 != null) {
                throw new AceException("Attempted to create model element with '" + string4 + "' when ty was " + string + " and va was " + string2);
            }
            String string5 = string4.trim();
            if (string5.startsWith("?")) {
                string = "model-reference";
                string5 = string5.substring(1);
                continue;
            }
            if (string4.startsWith("#")) {
                string = "model-include";
                string5 = string5.substring(1);
                continue;
            }
            if (string4.equals("Text") || string4.equals("DateType") || string4.equals("Int") || string4.equals("Float")) {
                string = "model-type";
                continue;
            }
            string = "model-node";
        }
    }

    public AceNode parseObject(String string) throws AceException {
        if ((string = string.trim()).startsWith("/")) {
            throw new AceException("Empty object!");
        }
        PeekStringTokenizer peekStringTokenizer = new PeekStringTokenizer(string, "{},[] \t\n\r", true);
        if (!peekStringTokenizer.nextToken().equals("{")) {
            throw new AceError("Unrecoverable parsing error: expecting {");
        }
        return this.getNode(null, peekStringTokenizer);
    }
}

