/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.gbregion.Extends;
import edu.msu.cme.rdp.readseq.utils.gbregion.SingleSeqRegion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinUtils {
    public static final char UNKNOWN_AA = 'X';
    private Map<Integer, AminoAcid[][][]> translationTableMap = new LinkedHashMap<Integer, AminoAcid[][][]>();
    private static final Pattern tableIdPattern = Pattern.compile("transl_table=(\\d+)");
    private static final Pattern tableEntryPattern = Pattern.compile("([A-Z]{3})\\s+([A-Z*]{1})\\s+[A-Z][a-z]{2}(\\s+i)?");
    private static final byte[] asciiMap = new byte[127];

    private ProteinUtils() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/data/protein_coding_tables.txt")));
            Integer currTable = -1;
            AminoAcid[][][] translationTable = new AminoAcid[4][4][4];
            while ((line = reader.readLine()) != null) {
                Matcher m = tableIdPattern.matcher(line);
                if (m.find()) {
                    if (currTable != -1) {
                        this.translationTableMap.put(currTable, translationTable);
                    }
                    currTable = new Integer(m.group(1));
                    translationTable = new AminoAcid[4][4][4];
                    continue;
                }
                m = tableEntryPattern.matcher(line);
                while (m.find()) {
                    String strCodon = m.group(1).toLowerCase();
                    AminoAcid aa = new AminoAcid(Character.valueOf(m.group(2).charAt(0)), m.group().endsWith("i"));
                    HashSet<String> codons = new HashSet<String>();
                    codons.add(strCodon.toLowerCase());
                    if (strCodon.contains("t")) {
                        codons.add(strCodon.replace("t", "u"));
                    }
                    if (strCodon.contains("u")) {
                        codons.add(strCodon.replace("u", "t"));
                    }
                    for (String c : codons) {
                        char[] codon = strCodon.toCharArray();
                        if (codon.length != 3) {
                            throw new IOException("Unexpected codon length in line " + line);
                        }
                        translationTable[ProteinUtils.asciiMap[codon[0]]][ProteinUtils.asciiMap[codon[1]]][ProteinUtils.asciiMap[codon[2]]] = aa;
                    }
                }
            }
            if (!this.translationTableMap.containsKey(currTable)) {
                this.translationTableMap.put(currTable, translationTable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AminoAcid[][][] getTranslationTable(int table) {
        return this.translationTableMap.get(table);
    }

    public int proteinTables() {
        return this.translationTableMap.size();
    }

    public static ProteinUtils getInstance() {
        return ProteinUtilsHolder.holder;
    }

    public String translateToProtein(String unalignedNucSeq, boolean dontAllowInitiators, int translTable) {
        AminoAcid[][][] proteinMapping = this.translationTableMap.get(translTable);
        if (proteinMapping == null) {
            throw new IllegalArgumentException("No such protein translation table " + translTable);
        }
        StringBuilder ret = new StringBuilder();
        char[] bases = unalignedNucSeq.toLowerCase().toCharArray();
        int index = 0;
        while (index + 3 <= bases.length) {
            AminoAcid aa = null;
            if (asciiMap[bases[index]] != -1 && asciiMap[bases[index + 1]] != -1 && asciiMap[bases[index + 2]] != -1) {
                aa = proteinMapping[asciiMap[bases[index]]][asciiMap[bases[index + 1]]][asciiMap[bases[index + 2]]];
            }
            if (aa == null) {
                ret.append('X');
            } else if (index == 0 && !dontAllowInitiators && aa.isInitiator()) {
                ret.append('m');
            } else {
                ret.append(aa.getAminoAcid());
            }
            index += 3;
        }
        return ret.toString();
    }

    private TranslateResult backTranslate(String protSeq, String unalignedNucSeq, boolean dontAllowInitiators, int translTable) {
        AminoAcid[][][] proteinMapping = this.translationTableMap.get(translTable);
        if (proteinMapping == null) {
            throw new IllegalArgumentException("No such protein translation table " + translTable);
        }
        int unalignedIndex = 0;
        int errors = 0;
        char[] bases = unalignedNucSeq.toLowerCase().toCharArray();
        StringBuilder nucSeq = new StringBuilder();
        for (int index = 0; index < protSeq.length(); ++index) {
            char protBase = protSeq.charAt(index);
            int nucSeqIndex = unalignedIndex * 3;
            if (protBase == 'x' || protBase == 'X') {
                nucSeq.append(Character.toLowerCase(bases[nucSeqIndex])).append(Character.toLowerCase(bases[nucSeqIndex + 1])).append(Character.toLowerCase(bases[nucSeqIndex + 2]));
                ++unalignedIndex;
                continue;
            }
            if (Character.isLetter(protBase)) {
                if (nucSeqIndex + 3 > unalignedNucSeq.length() + 1) {
                    throw new IllegalStateException("Ran out of nucleotides but there were still proteins...");
                }
                char p = protBase;
                AminoAcid aa = null;
                if (asciiMap[bases[nucSeqIndex]] != -1 && asciiMap[bases[nucSeqIndex + 1]] != -1 && asciiMap[bases[nucSeqIndex + 2]] != -1) {
                    aa = proteinMapping[asciiMap[bases[nucSeqIndex]]][asciiMap[bases[nucSeqIndex + 1]]][asciiMap[bases[nucSeqIndex + 2]]];
                }
                if (aa != null) {
                    int aminoAcid = aa.getAminoAcid().charValue();
                    if (index == 0 && !dontAllowInitiators && aa.isInitiator()) {
                        aminoAcid = 109;
                    }
                    if (Character.toUpperCase((char)aminoAcid) != Character.toUpperCase(p)) {
                        ++errors;
                    }
                } else {
                    throw new IllegalArgumentException("Failed to translate codon: " + bases[nucSeqIndex] + "" + bases[nucSeqIndex + 1] + "" + bases[nucSeqIndex + 2]);
                }
                if (Character.isUpperCase(protBase)) {
                    nucSeq.append(Character.toUpperCase(bases[nucSeqIndex])).append(Character.toUpperCase(bases[nucSeqIndex + 1])).append(Character.toUpperCase(bases[nucSeqIndex + 2]));
                } else {
                    nucSeq.append(Character.toLowerCase(bases[nucSeqIndex])).append(Character.toLowerCase(bases[nucSeqIndex + 1])).append(Character.toLowerCase(bases[nucSeqIndex + 2]));
                }
                ++unalignedIndex;
                continue;
            }
            if (protBase == '-') {
                nucSeq.append("---");
                continue;
            }
            if (protBase == '.') {
                nucSeq.append("...");
                continue;
            }
            if (protBase == '*') {
                if (index + 1 != protSeq.length()) {
                    ++errors;
                }
                ++unalignedIndex;
                nucSeq.append(Character.toLowerCase(bases[nucSeqIndex])).append(Character.toLowerCase(bases[nucSeqIndex + 1])).append(Character.toLowerCase(bases[nucSeqIndex + 2]));
                continue;
            }
            throw new IllegalArgumentException("Unexpected amino acid '" + protBase + "'");
        }
        TranslateResult result = new TranslateResult();
        result.errors = errors;
        result.translStr = nucSeq.toString();
        return result;
    }

    public String getAlignedNucSeq(String alignedProtSeq, String unalignedNucSeq, SingleSeqRegion r, int translTable) {
        return this.backTranslate((String)alignedProtSeq, (String)unalignedNucSeq, (boolean)(r.getExtends() == Extends.BEYOND_BEGIN || r.getExtends() == Extends.BEYOND_BOTH ? true : false), (int)translTable).translStr;
    }

    public float getTranslScore(String proteinSeq, String nucSeq, SingleSeqRegion r, int translTable) {
        int errors = this.backTranslate((String)proteinSeq, (String)nucSeq, (boolean)(r.getExtends() == Extends.BEYOND_BEGIN || r.getExtends() == Extends.BEYOND_BOTH ? true : false), (int)translTable).errors;
        return (float)(proteinSeq.length() - errors) / (float)proteinSeq.length();
    }

    public String getAlignedNucSeq(String alignedProtSeq, String unalignedNucSeq, boolean dontAllowInitiators, int translTable) {
        return this.backTranslate((String)alignedProtSeq, (String)unalignedNucSeq, (boolean)dontAllowInitiators, (int)translTable).translStr;
    }

    public float getTranslScore(String proteinSeq, String nucSeq, boolean dontAllowInitiators, int translTable) {
        int errors = this.backTranslate((String)proteinSeq, (String)nucSeq, (boolean)dontAllowInitiators, (int)translTable).errors;
        return (float)(proteinSeq.length() - errors) / (float)proteinSeq.length();
    }

    public List<Sequence> allTranslate(Sequence seq) {
        String seqString = seq.getSeqString();
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        if (seqString.length() < 3) {
            return ret;
        }
        for (int frame = 0; frame < 3; ++frame) {
            String frameSeq = seqString.substring(frame);
            String reverseFrameSeq = IUBUtilities.reverseComplement(seqString).substring(frame);
            if (frameSeq.length() < 3) continue;
            ret.add(new Sequence(seq.getSeqName() + "_" + (frame + 1), "", this.translateToProtein(frameSeq, true, 11)));
            ret.add(new Sequence(seq.getSeqName() + "_-" + (frame + 1), "", this.translateToProtein(reverseFrameSeq, true, 11)));
        }
        return ret;
    }

    public List<Sequence> allFrames(Sequence seq) {
        String seqString = seq.getSeqString();
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        if (seqString.length() < 3) {
            return ret;
        }
        for (int frame = 0; frame < 3; ++frame) {
            String frameSeq = seqString.substring(frame);
            String reverseFrameSeq = IUBUtilities.reverseComplement(seqString).substring(frame);
            if (frameSeq.length() < 3) continue;
            ret.add(new Sequence(seq.getSeqName() + "_" + (frame + 1), "", frameSeq));
            ret.add(new Sequence(seq.getSeqName() + "_-" + (frame + 1), "", reverseFrameSeq));
        }
        return ret;
    }

    public static void main(String[] args) {
        char[] nucl;
        HashMap<Character, Integer> codonToProt = new HashMap<Character, Integer>();
        int i = 0;
        for (String s : "A        C        D        E        F        G        H        I        K        L        M        N        P        Q        R        S        T        V        W        Y".split("\\s+")) {
            codonToProt.put(Character.valueOf(s.charAt(0)), i);
            System.out.println(s + " " + i);
            ++i;
        }
        codonToProt.put(Character.valueOf('*'), -1);
        for (char b1 : nucl = new char[]{'a', 'c', 'g', 't'}) {
            for (char b2 : nucl) {
                for (char b3 : nucl) {
                    Character aa = Character.valueOf(Character.toUpperCase(ProteinUtils.getInstance().translationTableMap.get(11)[asciiMap[b1]][asciiMap[b2]][asciiMap[b3]].getAminoAcid().charValue()));
                    System.out.println("bct_codons[twobit_repr('" + b1 + "') << 4 | twobit_repr('" + b2 + "') << 2 | twobit_repr('" + b3 + "')] = " + codonToProt.get(aa) + "; //" + aa);
                }
            }
        }
    }

    static {
        Arrays.fill(asciiMap, (byte)-1);
        ProteinUtils.asciiMap[97] = 0;
        ProteinUtils.asciiMap[65] = 0;
        ProteinUtils.asciiMap[99] = 1;
        ProteinUtils.asciiMap[67] = 1;
        ProteinUtils.asciiMap[103] = 2;
        ProteinUtils.asciiMap[71] = 2;
        ProteinUtils.asciiMap[117] = 3;
        ProteinUtils.asciiMap[85] = 3;
        ProteinUtils.asciiMap[116] = 3;
        ProteinUtils.asciiMap[84] = 3;
    }

    private static class TranslateResult {
        int errors;
        String translStr;

        private TranslateResult() {
        }
    }

    private static class ProteinUtilsHolder {
        private static ProteinUtils holder = new ProteinUtils();

        private ProteinUtilsHolder() {
        }
    }

    public static class AminoAcid {
        private Character aminoAcid;
        private boolean initiator;

        public AminoAcid(Character aminoAcid, boolean initiator) {
            this.aminoAcid = Character.valueOf(Character.toLowerCase(aminoAcid.charValue()));
            this.initiator = initiator;
        }

        public Character getAminoAcid() {
            return this.aminoAcid;
        }

        public boolean isInitiator() {
            return this.initiator;
        }

        public boolean matches(char c) {
            return this.aminoAcid.charValue() == Character.toLowerCase(c);
        }
    }
}

