## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
    collapse=TRUE,
    comment="#>",
    warning=FALSE,
    message=FALSE
)

## ----eval=FALSE---------------------------------------------------------------
#  ## Install the development version from GitHub
#  devtools::install_github("dpique/receptLoss",
#                              build_opts=c("--no-resave-data", "--no-manual"),
#                              build_vignettes=TRUE)

## ----warning=FALSE, message=FALSE---------------------------------------------
library(receptLoss)
library(dplyr)
library(ggplot2)

set.seed(100)

## Simulate matrix of expression values from
## 10 genes measured in both normal tissue and 
## tumor tissue in 100 patients

exprMatrNml <- matrix(abs(rnorm(100, mean=2.5)), nrow=10) 
exprMatrTum <- matrix(abs(rnorm(1000)), nrow=10)
geneNames <- paste0(letters[seq_len(nrow(exprMatrNml))], 
                seq_len(nrow(exprMatrNml)))
rownames(exprMatrNml) <- rownames(exprMatrTum) <- geneNames


## -----------------------------------------------------------------------------
nSdBelow <- 2
minPropPerGroup <- .2
rl <- receptLoss(exprMatrNml, exprMatrTum, nSdBelow, minPropPerGroup)
head(rl)

## -----------------------------------------------------------------------------
clrs <- c("#E78AC3", "#8DA0CB")

tryCatch({plotReceptLoss(exprMatrNml, exprMatrTum, rl, 
    geneName=as.character(rl[1,1]), clrs=clrs)}, 
    warning=function(cond){
        knitr::include_graphics("rl_fig.png")
    }, error=function(cond){
        knitr::include_graphics("rl_fig.png")
    }
)

## -----------------------------------------------------------------------------
receptLoss::nhrs

## ----eval=FALSE---------------------------------------------------------------
#  vignette("receptLoss")

## -----------------------------------------------------------------------------
sessionInfo()

