## ----echo=FALSE, message=FALSE------------------------------------------------
library(sesame)

## -----------------------------------------------------------------------------
sset = sesameDataGet('EPIC.1.LNCaP')$sset
inferSex(sset)
inferSexKaryotypes(sset)

## -----------------------------------------------------------------------------
inferEthnicity(sset)

## -----------------------------------------------------------------------------
betas <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
predictAgeHorvath353(betas)

## -----------------------------------------------------------------------------
meanIntensity(sset)

## ---- message=FALSE, fig.width=6----------------------------------------------
ssets.normal <- sesameDataGet('EPIC.5.normal')
segs <- cnSegmentation(sset, ssets.normal)

## ---- message=FALSE, fig.width=6----------------------------------------------
visualizeSegments(segs)

## ---- message=FALSE-----------------------------------------------------------
betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
estimateLeukocyte(betas.tissue)

