## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)

## ---- eval=TRUE---------------------------------------------------------------
dest_dir = tempdir()
res_grn = sesameDataDownload("3999492009_R01C01_Grn.idat", dest_dir=dest_dir)
res_red = sesameDataDownload("3999492009_R01C01_Red.idat", dest_dir=dest_dir)

## ---- eval=TRUE---------------------------------------------------------------

deIdentify(res_grn$dest_file, sprintf("%s/deidentified_Grn.idat", dest_dir))
deIdentify(res_red$dest_file, sprintf("%s/deidentified_Red.idat", dest_dir))

betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", dest_dir)))

head(betas1[grep('rs',names(betas1))]) 
head(betas2[grep('rs',names(betas2))])

## ---- eval=TRUE---------------------------------------------------------------

my_secret <- 13412084
set.seed(my_secret)

deIdentify(res_grn$dest_file,
    sprintf("%s/deidentified_Grn.idat", dest_dir), randomize=TRUE)

my_secret <- 13412084
set.seed(my_secret)
deIdentify(res_red$dest_file,
    sprintf("%s/deidentified_Red.idat", dest_dir), randomize=TRUE)

betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", dest_dir)))

head(betas1[grep('rs',names(betas1))]) 
head(betas2[grep('rs',names(betas2))]) 


## ---- eval=TRUE---------------------------------------------------------------

my_secret <- 13412084
set.seed(my_secret)

reIdentify(sprintf("%s/deidentified_Grn.idat", dest_dir),
    sprintf("%s/reidentified_Grn.idat", dest_dir))

my_secret <- 13412084
set.seed(my_secret)
reIdentify(sprintf("%s/deidentified_Red.idat", dest_dir),
    sprintf("%s/reidentified_Red.idat", dest_dir))

betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
betas2 = getBetas(readIDATpair(sprintf("%s/reidentified", dest_dir)))

head(betas1[grep('rs',names(betas1))]) 
head(betas2[grep('rs',names(betas2))]) 


## -----------------------------------------------------------------------------
sset <- sesameDataGet('EPIC.1.LNCaP')$sset
annoS = sesameDataGetAnno("EPIC/EPIC.hg19.snp_overlap_b151.rds")
annoI = sesameDataGetAnno("EPIC/EPIC.hg19.typeI_overlap_b151.rds")
head(formatVCF(sset, annoS=annoS, annoI=annoI)) # output to console

## ----message = FALSE----------------------------------------------------------
library(sesame)
options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
fset <- openSesameToFile('mybetas',
    system.file('extdata',package='sesameData'))

## -----------------------------------------------------------------------------
fset

## -----------------------------------------------------------------------------
head(fset$samples) # sample IDs
head(fset$probes) # probe IDs

## -----------------------------------------------------------------------------
sliceFileSet(fset, '4207113116_B', c('cg00006414','cg00007981'))

## -----------------------------------------------------------------------------
fset <- readFileSet('mybetas')
sliceFileSet(fset, '4207113116_A', 'cg00000292')

## -----------------------------------------------------------------------------
fset2 <- initFileSet('mybetas2', 'HM450', c('sample1', 'sample2'))

## -----------------------------------------------------------------------------
hypothetical_betas <- setNames(runif(fset2$n), fset2$probes)
mapFileSet(fset2, 'sample2', hypothetical_betas)

## -----------------------------------------------------------------------------
abs(sliceFileSet(fset2,'sample2','cg00000108') -
        hypothetical_betas['cg00000108']) < 1e-7

