## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    error = FALSE,
    warning=FALSE,
    message=FALSE,
    collapse = TRUE,
    comment = "#>"
)
library("BiocStyle")

## ----setup--------------------------------------------------------------------
library("snifter")
library("scRNAseq")
library("scran")
library("scuttle")
library("scater")
library("ggplot2")
theme_set(theme_bw())
set.seed(42)

## ----data---------------------------------------------------------------------
data <- ZeiselBrainData()
data <- data[rowMeans(counts(data) != 0) > 0.05, ]
data <- computeSumFactors(data, cluster = quickCluster(data))
data <- logNormCounts(data)
data <- runPCA(data, ncomponents = 20)
## Convert this to a factor to use as colouring variable later
data$level1class <- factor(data$level1class)

## ----run----------------------------------------------------------------------
mat <- reducedDim(data)
fit <- fitsne(mat, random_state = 42L)
ggplot() +
    aes(fit[, 1], fit[, 2], colour = data$level1class) +
    geom_point(pch = 19) +
    scale_colour_discrete(name = "Cell type") +
    labs(x = "t-SNE 1", y = "t-SNE 2")

## ----split--------------------------------------------------------------------
test_ind <- sample(nrow(mat), nrow(mat) / 2)
train_ind <- setdiff(seq_len(nrow(mat)), test_ind)
train_mat <- mat[train_ind, ]
test_mat <- mat[test_ind, ]

train_label <- data$level1class[train_ind]
test_label <- data$level1class[test_ind]

embedding <- fitsne(train_mat, random_state = 42L)

## ----plot-embed---------------------------------------------------------------
new_coords <- project(embedding, new = test_mat, old = train_mat)
ggplot() +
    geom_point(
        aes(embedding[, 1], embedding[, 2],
            colour = train_label,
            shape = "Train"
        )
    ) +
    geom_point(
        aes(new_coords[, 1], new_coords[, 2], 
            colour = test_label,
            shape = "Test"
        )
    ) +
    scale_colour_discrete(name = "Cell type") +
    scale_shape_discrete(name = NULL) +
    labs(x = "t-SNE 1", y = "t-SNE 2")

## -----------------------------------------------------------------------------
sessionInfo()

