## ----lkd----------------------------------------------------------------------
suppressPackageStartupMessages({
library(BiocOncoTK)
library(ggplot2)
})
molpo_CDS

## ----make2a-------------------------------------------------------------------
library(SummarizedExperiment)
sev = apply(assay(molpo_CDS),1,sum)
litass = assay(molpo_CDS[names(sort(sev,decreasing=TRUE)[1:50]),])
dd = data.frame(t(litass), tumor=molpo_CDS$tumor_type)
library(dplyr)
library(magrittr)
names(dd) = gsub("_.*", "", names(dd))
library(reshape2)
ddm = melt(dd)
names(ddm)[2] = "gene"
names(ddm)[3] = "msi_cds"
if (.Platform$OS.type != "windows") {
ggplot(ddm %>% filter(msi_cds>0), aes(x=gene,fill=tumor)) + geom_bar() +
  theme(axis.text.x = element_text(angle = 90, hjust = 1))
}

## ----make3a-------------------------------------------------------------------
lit = molpo_WGS[1,molpo_WGS$tumor_type %in% c("UCEC", "BRCA", "KIRP")]
myd = data.frame(totmsi=t(assay(lit[1,])), tumor=lit$tumor_type)
ss = split(myd, myd$tumor)
ss[[1]]$x = 1:nrow(ss[[1]])
ss[[2]]$x = 1:nrow(ss[[2]])
ss[[3]]$x = 1:nrow(ss[[3]])
ssd = do.call(rbind,ss)
if (.Platform$OS.type != "windows") {
ggplot(ssd, aes(y=Total_number_MSI_events+1,x=x)) + geom_point() +
   facet_grid(.~tumor, scales="free_x")+ scale_y_log10()
}

## ----getms--------------------------------------------------------------------
data(MSIsensor.10k)
data(patient_to_tumor_code)
names(MSIsensor.10k)[1] = "patient_barcode"
mm = merge(MSIsensor.10k, patient_to_tumor_code)
if (.Platform$OS.type != "windows") {
ggplot(mm, aes(y=MSIsensor.score+1, x=tumor_code)) + 
  geom_boxplot() + coord_flip() + scale_y_log10()
}

