/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected static Runnable ENDTASK = new /* Unavailable Anonymous Inner Class!! */;
    protected volatile boolean shutdown_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public QueuedExecutor(Channel channel) {
        this.queue_ = channel;
        this.runLoop_ = new RunLoop(this);
    }

    public QueuedExecutor() {
        this((Channel)new BoundedLinkedQueue());
    }

    public synchronized void restart() {
        if (this.thread_ == null && !this.shutdown_) {
            this.thread_ = this.threadFactory_.newThread((Runnable)this.runLoop_);
            this.thread_.start();
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.restart();
        this.queue_.put((Object)runnable);
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        if (!this.shutdown_) {
            try {
                this.queue_.put((Object)ENDTASK);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownAfterProcessingCurrentTask() {
        this.shutdown_ = true;
        try {
            while (this.queue_.poll(0L) != null) {
            }
            this.queue_.put((Object)ENDTASK);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        Thread thread = this.thread_;
        if (thread != null) {
            thread.interrupt();
        }
        this.shutdownAfterProcessingCurrentTask();
    }
}

