/*
 * Decompiled with CFR 0.152.
 */
package coltginy;

public class IntLinkedList {
    protected Entry first;
    protected Entry last;
    protected int size;

    public IntLinkedList() {
        this(null);
    }

    public IntLinkedList(int[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (this.last == null) {
                    this.first = this.last = new Entry(elements[i], null);
                    continue;
                }
                this.last = this.last.next = new Entry(elements[i], null);
            }
            this.size = elements.length;
        }
    }

    public Entry first() {
        return this.first;
    }

    public Entry last() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(int value) {
        if (this.last == null || this.first == null) {
            this.first = this.last = new Entry(value, null);
        } else {
            this.last = this.last.next = new Entry(value, null);
        }
        ++this.size;
    }

    public void delete(int value) {
        Entry last_entry = null;
        Entry entry = this.first;
        while (entry != null) {
            if (entry.value == value) {
                if (last_entry == null) {
                    this.first = entry.next;
                } else {
                    last_entry.next = entry.next;
                }
                --this.size;
                return;
            }
            last_entry = entry;
            entry = entry.next;
        }
    }

    public int[] elements() {
        int[] elements = new int[this.size];
        Entry entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            elements[i] = entry.value;
            entry = entry.next;
        }
        return elements;
    }

    public class Entry {
        protected int value;
        protected Entry next;

        public int value() {
            return this.value;
        }

        public Entry next() {
            return this.next;
        }

        public Entry(int value, Entry next) {
            this.value = value;
            this.next = next;
        }
    }
}

