/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class FixCrLfAction
extends SystemInstallOrUninstallAction {
    private File file;
    private String[] suffixes;
    private boolean recursive;

    public File getFile() {
        return FixCrLfAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String[] getSuffixes() {
        return FixCrLfAction.replaceVariables(this.suffixes);
    }

    public void setSuffixes(String[] stringArray) {
        this.suffixes = stringArray;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    protected boolean execute(Context context) throws UserCanceledException {
        if (this.getFile() == null) {
            return false;
        }
        File file = context.getDestinationFile(this.getFile());
        if (!file.exists()) {
            return false;
        }
        return this.fixFiles(file, this.createFilenameFilter(), true, context);
    }

    private FilenameFilter createFilenameFilter() {
        final String[] stringArray = this.getSuffixes();
        return new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (stringArray == null || stringArray.length == 0 || new File(file, string).isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!string.endsWith(string2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private boolean fixFiles(File file, FilenameFilter filenameFilter, boolean bl, Context context) throws UserCanceledException {
        if (file.isDirectory()) {
            boolean bl2 = true;
            if (bl) {
                File[] fileArray = file.listFiles(filenameFilter);
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (this.fixFiles(file2, filenameFilter, this.isRecursive(), context)) continue;
                    bl2 = false;
                }
            }
            return bl2;
        }
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file, false);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        }
        return this.fixSingleFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixSingleFile(File file) {
        try {
            Object object;
            long l = file.lastModified();
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((object = bufferedReader.readLine()) != null) {
                    arrayList.add((String)object);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            object = null;
            try {
                object = new PrintWriter(new FileOutputStream(file));
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((PrintWriter)object).println((String)arrayList.get(i));
                }
            }
            finally {
                if (object != null) {
                    ((PrintWriter)object).close();
                }
            }
            file.setLastModified(l);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

