/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.InstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class Installer {
    private Installer() {
    }

    public static void main(String[] stringArray) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(stringArray);
            new Controller(screenExecutor).start();
        }
        catch (Throwable throwable) {
            InstallerUtil.reportException(throwable);
            System.exit(1);
        }
    }

    private static ScreenExecutor getScreenExecutor(String[] stringArray) {
        ScreenExecutor screenExecutor;
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(stringArray);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (commandLineOptions.installDir != null) {
            if (!commandLineOptions.installDir.isAbsolute()) {
                System.err.println("The installation directory must be absolute. Aborting.");
                System.exit(1);
            }
            installerConfig.setInstallationDirectory(commandLineOptions.installDir);
        }
        if (commandLineOptions.quiet && installerConfig.isAllowUnattended()) {
            screenExecutor = new InstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite);
        } else if (commandLineOptions.console && installerConfig.isAllowConsole()) {
            screenExecutor = new InstallerConsoleScreenExecutor();
        } else {
            final ScreenExecutor[] screenExecutorArray = new ScreenExecutor[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        screenExecutorArray[0] = new InstallerWizardScreenExecutor();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new RuntimeException(interruptedException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                throw new RuntimeException(invocationTargetException.getMessage());
            }
            screenExecutor = screenExecutorArray[0];
        }
        InstallerVariables.init(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

